/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.unix.rpm;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.DesktopStarter;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.unix.rpm.Rpm;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

class RpmControlFileBuilder {
    private static final char NEWLINE = '\n';
    private final Rpm rpm;
    private final SetupBuilder setup;
    private File buildDir;
    private Collection<String> confFiles = new ArrayList<String>();
    Map<Script, StringBuilder> scriptMap = new HashMap<Script, StringBuilder>();
    private String javaMainExecutable;

    RpmControlFileBuilder(Rpm rpm, SetupBuilder setup, File buildDir, String javaMainExecutable) {
        this.rpm = rpm;
        this.setup = setup;
        this.buildDir = buildDir;
        this.javaMainExecutable = javaMainExecutable;
    }

    void build() throws Exception {
        this.createControlFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createControlFile() throws IOException {
        if (!this.buildDir.exists()) {
            this.buildDir.mkdirs();
        } else if (!this.buildDir.isDirectory()) {
            throw new IllegalArgumentException("The buildDir parameter must be a directory!");
        }
        FileOutputStream fileoutput = null;
        OutputStreamWriter controlWriter = null;
        try {
            File spec = new File(this.buildDir, this.setup.getAppIdentifier() + ".spec");
            fileoutput = new FileOutputStream(spec);
            controlWriter = new OutputStreamWriter((OutputStream)fileoutput, "UTF-8");
            this.putSummary(controlWriter);
            this.putName(controlWriter);
            this.putVersion(controlWriter);
            this.putRelease(controlWriter);
            this.putLicense(controlWriter);
            this.putSection(controlWriter);
            this.putBuildRoot(controlWriter);
            this.putURL(controlWriter);
            this.putVendor(controlWriter);
            this.putPackager(controlWriter);
            this.putPrefix(controlWriter);
            this.putDepends(controlWriter);
            this.putArchitecture(controlWriter);
            this.putAdditionalHeaderInformation(controlWriter);
            this.putBackwardCompatibility(controlWriter);
            this.putDescription(controlWriter);
            this.putPrep(controlWriter);
            this.putBuild(controlWriter);
            this.putInstall(controlWriter);
            this.putClean(controlWriter);
            this.putFiles(controlWriter);
            this.putPre(controlWriter);
            this.putPost(controlWriter);
            this.putPreun(controlWriter);
            this.putPostun(controlWriter);
            controlWriter.flush();
        }
        finally {
            if (controlWriter != null) {
                try {
                    controlWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (fileoutput != null) {
                try {
                    fileoutput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void putBackwardCompatibility(OutputStreamWriter controlWriter) throws IOException {
        if (this.rpm.isBackwardCompatible()) {
            controlWriter.write("\n%define _binary_payload w9.gzdio\n");
            controlWriter.write("\n%define _source_payload w9.gzdio\n");
            controlWriter.write("\n%define _binary_filedigest_algorithm 1\n");
            controlWriter.write("\n%define _source_filedigest_algorithm 1\n");
        }
    }

    private void putPreun(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%preun\n");
        controlWriter.write("\nif [ $1 -eq 0 ]; then\n");
        controlWriter.write("\necho \"preun step\"\n");
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        this.writeHeadContentTail(controlWriter, Script.PRERMHEAD, this.rpm.getPrerm(), Script.PRERMTAIL);
        List<String> del_files = this.setup.getDeleteFiles();
        for (String string : del_files) {
            controlWriter.write("if [ -f \"${RPM_INSTALL_PREFIX}/" + string + "\" ]; then\n  rm -f \"${RPM_INSTALL_PREFIX}/" + string + "\"\nfi" + '\n');
        }
        List<String> del_dirs = this.setup.getDeleteFolders();
        for (String dirs : del_dirs) {
            controlWriter.write("rm -R -f \"${RPM_INSTALL_PREFIX}/" + dirs + "\"" + '\n');
        }
        DesktopStarter desktopStarter = this.setup.getRunBeforeUninstall();
        if (desktopStarter != null) {
            String workingDir;
            controlWriter.write(10);
            String executable = desktopStarter.getExecutable();
            String mainClass = desktopStarter.getMainClass();
            String string = workingDir = desktopStarter.getWorkDir() != null ? "/" + desktopStarter.getWorkDir() : "";
            if (executable != null) {
                if (this.rpm.getDaemonUser().equalsIgnoreCase("root")) {
                    controlWriter.write("( cd \"${RPM_INSTALL_PREFIX}" + workingDir + "\" && " + executable + " " + desktopStarter.getStartArguments() + " )" + '\n');
                } else {
                    controlWriter.write("(su " + this.rpm.getDaemonUser() + " -c 'cd \"${RPM_INSTALL_PREFIX}" + workingDir + "\" && " + executable + " " + desktopStarter.getStartArguments() + "' )" + '\n');
                }
            } else if (mainClass != null) {
                if (this.rpm.getDaemonUser().equalsIgnoreCase("root")) {
                    controlWriter.write("( cd \"${RPM_INSTALL_PREFIX}" + workingDir + "\" && \"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", desktopStarter.getJavaVMArguments()) + " -cp \"" + desktopStarter.getMainJar() + "\" " + mainClass + " " + desktopStarter.getStartArguments() + " )" + '\n');
                } else {
                    controlWriter.write("(su " + this.rpm.getDaemonUser() + " -c 'cd \"${RPM_INSTALL_PREFIX}/" + workingDir + "\" && \"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", desktopStarter.getJavaVMArguments()) + " -cp \"" + desktopStarter.getMainJar() + "\" " + mainClass + " " + desktopStarter.getStartArguments() + "' )" + '\n');
                }
            }
            controlWriter.write(10);
        }
        controlWriter.write("\nfi\n");
    }

    private void putPre(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%pre\n");
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        this.writeHeadContentTail(controlWriter, Script.PREINSTHEAD, this.rpm.getPreinst(), Script.PREINSTTAIL);
        List<String> del_files = this.setup.getDeleteFiles();
        for (String file : del_files) {
            controlWriter.write("if [ -f \"${RPM_INSTALL_PREFIX}/" + file + "\" ]; then\n  rm -f \"${RPM_INSTALL_PREFIX}/" + file + "\"\nfi" + '\n');
        }
        List<String> del_dirs = this.setup.getDeleteFolders();
        for (String dirs : del_dirs) {
            controlWriter.write("rm -R -f \"${RPM_INSTALL_PREFIX}/" + dirs + "\"" + '\n');
        }
    }

    private void putPost(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%post\n");
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        this.writeHeadContentTail(controlWriter, Script.POSTINSTHEAD, this.rpm.getPostinst(), Script.POSTINSTTAIL);
        DesktopStarter runAfterStarter = this.setup.getRunAfter();
        if (runAfterStarter != null) {
            String workingDir;
            String executable = runAfterStarter.getExecutable();
            String mainClass = runAfterStarter.getMainClass();
            String string = workingDir = runAfterStarter.getWorkDir() != null ? "/" + runAfterStarter.getWorkDir() : "";
            if (executable != null) {
                controlWriter.write("( cd \"${RPM_INSTALL_PREFIX}" + workingDir + "\" && " + executable + " " + runAfterStarter.getStartArguments() + " & )" + '\n');
            } else if (mainClass != null) {
                controlWriter.write("( cd \"${RPM_INSTALL_PREFIX}" + workingDir + "\" && \"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", runAfterStarter.getJavaVMArguments()) + " -cp \"" + runAfterStarter.getMainJar() + "\" " + mainClass + " " + runAfterStarter.getStartArguments() + " )" + '\n');
            }
        }
        controlWriter.write("gtk-update-icon-cache /usr/share/icons/hicolor &>/dev/null || :\n");
    }

    private void putPostun(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%postun\n");
        if (this.rpm.getPostrm().size() > 0 || this.scriptMap.get((Object)Script.POSTRMHEAD) != null || this.scriptMap.get((Object)Script.POSTRMTAIL) != null) {
            controlWriter.write("\nif [ $1 -eq 0 ]; then\n");
        }
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        this.writeHeadContentTail(controlWriter, Script.POSTRMHEAD, this.rpm.getPostrm(), Script.POSTRMTAIL);
        if (this.rpm.getPostrm().size() > 0 || this.scriptMap.get((Object)Script.POSTRMHEAD) != null || this.scriptMap.get((Object)Script.POSTRMTAIL) != null) {
            controlWriter.write("\nfi\n");
        }
    }

    private void putFiles(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%files\n");
        controlWriter.write("\"" + this.rpm.getInstallationRoot() + "\"" + '\n');
        if (this.setup.getDesktopStarters() != null && this.setup.getDesktopStarters().size() > 0) {
            controlWriter.write("/usr/share/applications/*\n");
            controlWriter.write("/usr/share/icons/**/*\n");
            controlWriter.write("/usr/bin/*\n");
        }
        if (this.setup.getServices() != null && this.setup.getServices().size() > 0) {
            controlWriter.write("/etc/init.d/*\n");
        }
        if (this.rpm.getDefaultServiceFile() != null) {
            controlWriter.write("/etc/sysconfig/*\n");
        }
        if (this.setup.getLicenseFiles() != null && this.setup.getLicenseFiles().size() > 0) {
            controlWriter.write("/usr/share/licenses/**/*\n");
        }
    }

    private void putClean(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%clean\n");
        String release = this.rpm.getRelease();
        if (release == null || release.length() == 0) {
            release = "1";
        }
        controlWriter.write("cp ../SRPMS/" + this.setup.getAppIdentifier() + "-" + this.rpm.getVersion() + "-" + release + ".src.rpm '" + this.setup.getDestinationDir().getAbsolutePath() + "'" + '\n');
        controlWriter.write("mv -f ../RPMS/" + this.rpm.getArchitecture() + "/" + this.setup.getAppIdentifier() + "-" + this.rpm.getVersion() + "-" + release + "." + this.rpm.getArchitecture() + ".rpm '" + this.rpm.getSetupFile() + "'" + '\n');
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        ArrayList<String> cleans = this.rpm.getClean();
        for (String clean : cleans) {
            controlWriter.write(clean + '\n');
        }
    }

    private void putInstall(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%install\n");
        controlWriter.write("cp -R . '%{buildroot}'\n");
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        ArrayList<String> installs = this.rpm.getInstall();
        for (String install : installs) {
            controlWriter.write(install + '\n');
        }
    }

    private void putBuild(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%build\n");
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        ArrayList<String> builds = this.rpm.getBuild();
        for (String build : builds) {
            controlWriter.write(build + '\n');
        }
    }

    private void putPrep(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%prep\n");
        controlWriter.write(this.rpm.getVariablesTemplate() + '\n');
        ArrayList<String> preps = this.rpm.getPrep();
        for (String prep : preps) {
            controlWriter.write(prep + '\n');
        }
    }

    private void putPrefix(OutputStreamWriter controlWriter) throws IOException {
        String prefix = this.rpm.getInstallationRoot();
        controlWriter.write("Prefix: \"" + prefix + "\"" + '\n');
    }

    private void putPackager(OutputStreamWriter controlWriter) throws IOException {
        String vendor = this.setup.getVendor();
        if (vendor == null || vendor.length() == 0) {
            throw new RuntimeException("No vendor declared in the setup configuration.");
        }
        controlWriter.write("Packager: " + vendor + '\n');
    }

    private void putURL(OutputStreamWriter controlWriter) throws IOException {
        String url = this.rpm.getHomepage();
        if (url != null && url.length() > 0) {
            controlWriter.write("URL: " + url + '\n');
        }
    }

    private void putBuildRoot(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("BuildRoot: ${_builddir}/%{name}-root\n");
    }

    private void putLicense(OutputStreamWriter controlWriter) throws IOException {
        String license = this.rpm.getLicense();
        if (license == null || license.length() == 0) {
            license = "Restricted";
        }
        controlWriter.write("License: " + license + '\n');
    }

    private void putRelease(OutputStreamWriter controlWriter) throws IOException {
        String release = this.rpm.getRelease();
        if (release == null || release.length() == 0) {
            release = "1";
        }
        controlWriter.write("Release: " + release + '\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDescription(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("\n%define __jar_repack %{nil}\n");
        List<LocalizedResource> descriptions = this.setup.getLongDescriptions();
        if (descriptions.size() > 0) {
            for (LocalizedResource desc : descriptions) {
                String lang = desc.getLanguage();
                StringBuffer content = new StringBuffer("\n%description");
                content.append(lang.equalsIgnoreCase(this.setup.getDefaultResourceLanguage()) ? "\n" : " -l " + lang + '\n');
                try {
                    Scanner scanner = new Scanner(desc.getResource(), "UTF8");
                    Throwable throwable = null;
                    try {
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            content.append(" " + (line.isEmpty() ? Character.valueOf('|') : line) + '\n');
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                finally {
                    controlWriter.write(content.toString() + '\n');
                }
            }
        } else {
            controlWriter.write("\n%description\n\n");
        }
    }

    private void putVendor(OutputStreamWriter controlWriter) throws IOException {
        String vendor = this.setup.getVendor();
        if (vendor == null || vendor.length() == 0) {
            throw new RuntimeException("No vendor declared in the setup configuration.");
        }
        controlWriter.write("Vendor: " + vendor + '\n');
    }

    private void putDepends(OutputStreamWriter controlWriter) throws IOException {
        String depends = this.rpm.getDepends();
        if (depends == null || depends.length() == 0) {
            depends = "";
        }
        if (this.setup.getServices() == null || this.setup.getServices().size() > 0) {
            // empty if block
        }
        if (depends.trim().length() > 0) {
            controlWriter.write("Requires: " + depends + '\n');
        }
    }

    private void putArchitecture(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("BuildArchitectures: " + this.rpm.getArchitecture() + '\n');
    }

    private void putAdditionalHeaderInformation(OutputStreamWriter controlWriter) {
        this.rpm.getSpecHeader().forEach(header -> {
            try {
                controlWriter.write(header + '\n');
            }
            catch (IOException e) {
                this.setup.getProject().getLogger().error(e.getLocalizedMessage());
            }
        });
    }

    private void putSection(OutputStreamWriter controlWriter) throws IOException {
        String section = this.rpm.getSection();
        if (section != null && section.length() > 0) {
            controlWriter.write("Group: " + section + '\n');
        }
    }

    private void putVersion(OutputStreamWriter controlWriter) throws IOException {
        String version = this.rpm.getVersion();
        if (version == null || version.length() == 0) {
            throw new RuntimeException("No version declared in the setup configuration.");
        }
        controlWriter.write("Version: " + version + '\n');
    }

    private void putSummary(OutputStreamWriter controlWriter) throws IOException {
        String summary = this.rpm.getSummary();
        if (summary == null || summary.length() == 0) {
            throw new RuntimeException("No summary declared in the setup configuration.");
        }
        controlWriter.write("Summary: " + summary + '\n');
    }

    private void putName(OutputStreamWriter controlWriter) throws IOException {
        String packages = this.setup.getAppIdentifier();
        if (packages == null || packages.length() == 0) {
            throw new RuntimeException("No package declared in the setup configuration.");
        }
        controlWriter.write("Name: " + packages + '\n');
    }

    public void addConfFile(String file) {
        this.confFiles.add(file);
    }

    public void addScriptFragment(Script script, String scriptFragment) {
        StringBuilder sb = this.scriptMap.get((Object)script);
        if (sb == null) {
            sb = new StringBuilder();
            this.scriptMap.put(script, sb);
        } else {
            sb.append("\n\n");
        }
        sb.append(scriptFragment);
    }

    private void writeHeadContentTail(OutputStreamWriter controlWriter, Script headSection, ArrayList<String> bodySection, Script tailSection) throws IOException {
        StringBuilder head = this.scriptMap.get((Object)headSection);
        if (head != null) {
            controlWriter.write(head.toString() + '\n');
        }
        for (String body : bodySection) {
            controlWriter.write(body + '\n');
        }
        StringBuilder tail = this.scriptMap.get((Object)tailSection);
        if (tail != null) {
            controlWriter.write(tail.toString() + '\n');
        }
    }

    static enum Script {
        PREINSTHEAD,
        PREINSTTAIL,
        POSTINSTHEAD,
        POSTINSTTAIL,
        PRERMHEAD,
        PRERMTAIL,
        POSTRMHEAD,
        POSTRMTAIL;

    }
}

