/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.unix.rpm;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.Template;
import com.inet.gradle.setup.abstracts.DesktopStarter;
import com.inet.gradle.setup.abstracts.DocumentType;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.unix.UnixBuilder;
import com.inet.gradle.setup.unix.rpm.Rpm;
import com.inet.gradle.setup.unix.rpm.RpmControlFileBuilder;
import com.inet.gradle.setup.util.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.gradle.api.internal.file.FileResolver;

public class RpmBuilder
extends UnixBuilder<Rpm, SetupBuilder> {
    private RpmControlFileBuilder controlBuilder;

    public RpmBuilder(Rpm rpm, SetupBuilder setup, FileResolver fileResolver) {
        super(rpm, setup, fileResolver);
    }

    public void build() {
        try {
            String release = ((Rpm)this.task).getRelease();
            if (release == null || release.length() == 0) {
                release = "1";
            }
            File filesPath = new File(this.buildDir.getAbsolutePath() + "/BUILD" + ((Rpm)this.task).getInstallationRoot());
            ((Rpm)this.task).copyTo(filesPath);
            this.changeFilePermissionsTo644(filesPath);
            this.addBundleJre(filesPath);
            this.controlBuilder = new RpmControlFileBuilder((Rpm)this.task, this.setup, new File(this.buildDir, "SPECS"), this.javaMainExecutable);
            this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.PREINSTHEAD, "# check for java. the service will need it and other parts probably too[ ! -x '" + this.javaMainExecutable + "' ] && echo \"The program 'java' does not exist but will be needed. (Looked up at '" + this.javaMainExecutable + "')\" && exit 1 || :\n\n");
            String daemonuser = ((Rpm)this.task).getDaemonUser();
            if (!daemonuser.equalsIgnoreCase("root")) {
                this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTINSTHEAD, "useradd -r -m -U " + daemonuser + " 2> /dev/null || true\n[ \"$(id " + daemonuser + " 2> /dev/null 1>&2; echo $?)\" == \"0\" ] && chown -R " + daemonuser + ":" + daemonuser + " '" + ((Rpm)this.task).getInstallationRoot() + "' && chmod -R g+w '" + ((Rpm)this.task).getInstallationRoot() + "' || true \n\n");
            }
            for (Service service : this.setup.getServices()) {
                this.setupService(service);
            }
            for (DesktopStarter starter : this.setup.getDesktopStarters()) {
                this.setupStarter(starter);
            }
            if (!daemonuser.equalsIgnoreCase("root")) {
                this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTRMTAIL, "userdel -r " + daemonuser + " 2> /dev/null || true \n");
                this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTRMTAIL, "groupdel " + daemonuser + " 2> /dev/null || true \n");
            }
            for (LocalizedResource license : this.setup.getLicenseFiles()) {
                File licensetarget = new File(this.buildDir.getAbsolutePath() + "/BUILD/usr/share/licenses/" + this.setup.getApplication() + "/" + license.getResource().getName());
                licensetarget.mkdirs();
                Files.copy(license.getResource().toPath(), licensetarget.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.controlBuilder.build();
            this.changeDirectoryPermissionsTo755(this.buildDir);
            this.createRpmPackage();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setupService(Service service) throws IOException {
        String serviceUnixName = service.getId();
        String installationRoot = ((Rpm)this.task).getInstallationRoot();
        String workingDir = installationRoot + (service.getWorkDir() != null ? "/" + service.getWorkDir() : "");
        String mainJarPath = workingDir + "/" + service.getMainJar();
        String initTemplate = "unix/init-service.sh";
        Template initScript = new Template(initTemplate);
        initScript.setPlaceholder("name", serviceUnixName);
        String version = ((Rpm)this.task).getVersion();
        initScript.setPlaceholder("majorversion", version.substring(0, version.indexOf(46)));
        initScript.setPlaceholder("displayName", this.setup.getApplication());
        initScript.setPlaceholder("description", service.getDescription());
        initScript.setPlaceholder("wait", "2");
        initScript.setPlaceholder("workdir", workingDir);
        initScript.setPlaceholder("mainJar", mainJarPath);
        initScript.setPlaceholder("startArguments", service.getStartArguments().trim());
        initScript.setPlaceholder("javaVMArguments", String.join((CharSequence)" ", service.getJavaVMArguments()).trim());
        initScript.setPlaceholder("mainClass", service.getMainClass());
        initScript.setPlaceholder("daemonUser", ((Rpm)this.task).getDaemonUser());
        initScript.setPlaceholder("daemonExec", this.javaMainExecutable);
        initScript.setPlaceholder("additionalServiceScript", ((Rpm)this.task).getAdditionalServiceScript());
        String initScriptFile = "BUILD/etc/init.d/" + serviceUnixName;
        initScript.writeTo(this.createFile(initScriptFile, true));
        this.controlBuilder.addConfFile(initScriptFile);
        this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.PREINSTHEAD, "[ -f \"/etc/init.d/" + serviceUnixName + "\" ] && \"/etc/init.d/" + serviceUnixName + "\" stop || true");
        this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTINSTTAIL, "if [ -f \"/etc/init.d/" + serviceUnixName + "\" ]  && [ \"" + installationRoot + "\" != \"$RPM_INSTALL_PREFIX\" ] ; then\necho replace path\nsed -i 's|'" + installationRoot + "'|'$RPM_INSTALL_PREFIX'|g' /etc/init.d/" + serviceUnixName + "\nfi");
        if (((Rpm)this.task).getDefaultServiceFile() != null) {
            File serviceDestFile = this.createFile("BUILD/etc/sysconfig/" + serviceUnixName, true);
            Files.copy(((Rpm)this.task).getDefaultServiceFile().toPath(), serviceDestFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTINSTTAIL, "( [ -f \"/etc/init.d/" + serviceUnixName + "\" ] && chkconfig --add " + serviceUnixName + " && systemctl enable " + serviceUnixName + " ) || true");
        if (((Rpm)this.task).shouldStartDefaultService()) {
            this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTINSTTAIL, "[ -f \"/etc/init.d/" + serviceUnixName + "\" ] && /etc/init.d/" + serviceUnixName + " start || true");
        }
        this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.PRERMHEAD, "[ -f \"/etc/init.d/" + serviceUnixName + "\" ] && /etc/init.d/" + serviceUnixName + " stop || true");
        this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.PRERMHEAD, "( [ -f \"/etc/init.d/" + serviceUnixName + "\" ] && systemctl disable " + serviceUnixName + " && chkconfig --del " + serviceUnixName + " ) || true");
    }

    private void setupStarter(DesktopStarter starter) throws IOException {
        String unixName = starter.getDisplayName();
        String consoleStarterPath = "/usr/bin/" + unixName;
        try (FileWriter fw = new FileWriter(this.createFile("BUILD" + consoleStarterPath, true));){
            fw.write("#!/bin/sh\n");
            if (starter.getExecutable() != null) {
                fw.write("\"" + ((Rpm)this.task).getInstallationRoot() + "/" + starter.getExecutable() + "\" " + starter.getStartArguments() + " \"$@\"");
            } else {
                fw.write("\"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", starter.getJavaVMArguments()) + " -cp \"" + ((Rpm)this.task).getInstallationRoot() + "/" + starter.getMainJar() + "\" " + starter.getMainClass() + " " + starter.getStartArguments() + " \"$@\"");
            }
        }
        int[] iconSizes = new int[]{16, 32, 48, 64, 128, 256, 512};
        String iconName = "";
        if (starter.getIcons() != null) {
            iconName = starter.getIcons().toString();
            int index = iconName.lastIndexOf(47);
            if (index > -1) {
                iconName = iconName.substring(index + 1);
            }
            if (!iconName.endsWith(".png")) {
                index = iconName.lastIndexOf(46);
                if (index > -1) {
                    iconName = iconName.substring(0, index);
                }
                iconName = iconName + ".png";
            }
        }
        for (int size : iconSizes) {
            File iconDir = new File(this.buildDir, "BUILD/usr/share/icons/hicolor/" + size + "x" + size + "/apps/");
            iconDir.mkdirs();
            File scaledFile = this.setup.getIconForType(iconDir, "png" + size);
            if (scaledFile == null) continue;
            File iconFile = starter.getIcons() != null ? new File(iconDir, iconName) : new File(iconDir, unixName + ".png");
            scaledFile.renameTo(iconFile);
            RpmBuilder.setPermissions(iconFile, false);
        }
        try (FileWriter fw = new FileWriter(this.createFile("BUILD/usr/share/applications/" + unixName + ".desktop", false));){
            fw.write("[Desktop Entry]\n");
            fw.write("Name=" + starter.getDisplayName() + "\n");
            fw.write("Comment=" + starter.getDescription().replace('\n', ' ') + "\n");
            if (starter.getExecutable() != null) {
                fw.write("Exec=\"" + ((Rpm)this.task).getInstallationRoot() + "/" + starter.getExecutable() + "\"\n");
            } else {
                fw.write("Exec=\"/" + consoleStarterPath + "\" %F\n");
            }
            if (starter.getIcons() != null) {
                int index = iconName.lastIndexOf(46);
                if (index > -1) {
                    iconName = iconName.substring(0, index);
                }
                fw.write("Icon=" + iconName + "\n");
            } else {
                fw.write("Icon=" + unixName + "\n");
            }
            String cwd = starter.getWorkDir();
            if (cwd != null) {
                if (cwd.isEmpty() || cwd.equals(".")) {
                    fw.write("Path=" + ((Rpm)this.task).getInstallationRoot() + "\n");
                } else {
                    fw.write("Path=" + cwd + "\n");
                }
            }
            fw.write("Terminal=false\n");
            fw.write("StartupNotify=true\n");
            fw.write("Type=Application\n");
            if (starter.getMimeTypes() != null) {
                fw.write("MimeType=" + starter.getMimeTypes() + "\n");
            }
            if (starter.getCategories() != null) {
                fw.write("Categories=" + starter.getCategories() + "\n");
            }
        }
        for (DocumentType docType : starter.getDocumentType()) {
            for (String extension : docType.getFileExtension()) {
                String simpleVendor = this.setup.getVendor();
                simpleVendor = simpleVendor.replaceAll("\\W", "");
                try (FileWriter fw = new FileWriter(this.createFile("BUILD/" + ((Rpm)this.task).getInstallationRoot() + "/" + simpleVendor + "-" + extension + ".xml", false));){
                    fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    fw.write("<mime-info xmlns=\"http://www.freedesktop.org/standards/shared-mime-info\">\n");
                    if (starter.getMimeTypes() != null) {
                        fw.write("    <mime-type type=\"" + starter.getMimeTypes() + "\">\n");
                    } else {
                        fw.write("    <mime-type type=\"" + docType.getMimetype() + "\">\n");
                    }
                    fw.write("        <comment>" + this.setup.getApplication() + "</comment>\n");
                    fw.write("        <glob-deleteall/>\n");
                    fw.write("        <glob pattern=\"*." + extension + "\"/>\n");
                    fw.write("    </mime-type>\n");
                    fw.write("</mime-info>\n");
                }
                this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTINSTTAIL, "xdg-mime install \"" + ((Rpm)this.task).getInstallationRoot() + "/" + simpleVendor + "-" + extension + ".xml\" || true");
                this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.PRERMHEAD, "xdg-mime uninstall \"" + ((Rpm)this.task).getInstallationRoot() + "/" + simpleVendor + "-" + extension + ".xml\" || true");
                String iconame = unixName;
                if (starter.getIcons() != null) {
                    iconame = iconName;
                }
                this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.POSTINSTTAIL, "xdg-icon-resource install --context mimetypes --novendor --size 48 /usr/share/icons/hicolor/48x48/apps/" + iconame + ".png " + iconame + " || true");
                this.controlBuilder.addScriptFragment(RpmControlFileBuilder.Script.PRERMHEAD, "xdg-icon-resource uninstall --context mimetypes --size 48 " + iconame + " || true");
            }
        }
    }

    private File createFile(String path, boolean executable) throws IOException {
        File file = new File(this.buildDir, path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        RpmBuilder.setPermissions(file, executable);
        return file;
    }

    private void createRpmPackage() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("rpmbuild");
        command.add("-ba");
        command.add("-v");
        command.add("--clean");
        command.add("--define=_topdir " + this.buildDir.getAbsolutePath());
        command.add("--define=_build_id_links none");
        command.add("SPECS/" + this.setup.getAppIdentifier() + ".spec");
        this.exec(command);
    }

    @FunctionalInterface
    private static interface ThrowingBiConsumer<T, P>
    extends BiConsumer<T, P> {
        @Override
        default public void accept(T elem, P mele) {
            try {
                this.acceptThrows(elem, mele);
            }
            catch (Exception e) {
                Logging.syserr("handling an exception...");
                throw new RuntimeException(e);
            }
        }

        public void acceptThrows(T var1, P var2) throws Exception;
    }
}

