/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.unix.deb;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.Template;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.unix.deb.Deb;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

class DebControlFileBuilder {
    private static final char NEWLINE = '\n';
    private final Deb deb;
    private final SetupBuilder setup;
    private File buildDir;
    private Collection<String> confFiles = new ArrayList<String>();
    Map<Script, StringBuilder> scriptHeadMap = new HashMap<Script, StringBuilder>();
    Map<Script, StringBuilder> scriptTailMap = new HashMap<Script, StringBuilder>();

    DebControlFileBuilder(Deb deb, SetupBuilder setup, File buildDir) {
        this.deb = deb;
        this.setup = setup;
        this.buildDir = buildDir;
    }

    void build() throws Exception {
        this.createControlFile();
        this.createConfFilesFile();
        this.createScripts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createControlFile() throws IOException {
        if (!this.buildDir.exists()) {
            this.buildDir.mkdirs();
        } else if (!this.buildDir.isDirectory()) {
            throw new IllegalArgumentException("The buildDir parameter must be a directory!");
        }
        FileOutputStream fileoutput = null;
        OutputStreamWriter controlWriter = null;
        try {
            File control = new File(this.buildDir, "control");
            fileoutput = new FileOutputStream(control);
            controlWriter = new OutputStreamWriter((OutputStream)fileoutput, "UTF-8");
            this.putPackage(controlWriter);
            this.putVersion(controlWriter);
            this.putSection(controlWriter);
            this.putPriority(controlWriter);
            this.putArchitecture(controlWriter);
            this.putInstallSize(controlWriter);
            this.putRecommends(controlWriter);
            this.putPreDepends(controlWriter);
            this.putDepends(controlWriter);
            this.putMaintainer(controlWriter);
            this.putDescription(controlWriter);
            this.putHomepage(controlWriter);
            controlWriter.flush();
        }
        finally {
            if (controlWriter != null) {
                try {
                    controlWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (fileoutput != null) {
                try {
                    fileoutput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDescription(OutputStreamWriter controlWriter) throws IOException {
        List<LocalizedResource> longDescriptions = this.setup.getLongDescriptions();
        if (longDescriptions.size() > 0) {
            for (LocalizedResource localizedResource : this.setup.getLongDescriptions()) {
                String lang = localizedResource.getLanguage().equalsIgnoreCase(this.setup.getDefaultResourceLanguage()) ? "" : "-" + localizedResource.getLanguage();
                StringBuffer content = new StringBuffer("Description" + lang + ": " + this.deb.getDescription() + '\n');
                try {
                    Scanner scanner = new Scanner(localizedResource.getResource(), "UTF8");
                    Throwable throwable = null;
                    try {
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            content.append(" " + (line.isEmpty() ? Character.valueOf('.') : line) + '\n');
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                finally {
                    controlWriter.write(content.toString());
                }
            }
        } else {
            controlWriter.write("Description: " + this.deb.getDescription() + '\n');
        }
    }

    private void putMaintainer(OutputStreamWriter controlWriter) throws IOException {
        String vendor = this.setup.getVendor();
        if (vendor == null || vendor.length() == 0) {
            throw new RuntimeException("No vendor declared in the setup configuration.");
        }
        controlWriter.write("Maintainer: " + vendor + " <" + this.deb.getMaintainerEmail() + ">" + '\n');
    }

    private void putDepends(OutputStreamWriter controlWriter) throws IOException {
        String depends = this.deb.getDepends();
        if (depends != null && depends.length() > 0) {
            controlWriter.write("Depends: " + depends + '\n');
        }
    }

    private void putPreDepends(OutputStreamWriter controlWriter) throws IOException {
        String depends = this.deb.getDepends();
        if (depends == null || depends.length() == 0) {
            depends = "debconf";
        }
        controlWriter.write("Pre-Depends: " + depends + '\n');
    }

    private void putRecommends(OutputStreamWriter controlWriter) throws IOException {
        String recommends = this.deb.getRecommends();
        if ((recommends == null || recommends.length() == 0) && this.setup.getBundleJre() != null) {
            recommends = "openjdk-8-jre | openjdk-8-jdk | default-jre | default-jdk, libgtk2-perl";
        }
        controlWriter.write("Recommends: " + recommends + '\n');
    }

    private void putInstallSize(OutputStreamWriter controlWriter) throws IOException {
        String installSize = this.deb.getInstallSize();
        if (installSize == null || installSize.length() == 0) {
            long fileSize = 0L;
            for (File file : this.deb.getSetupSource().getFiles()) {
                if (!file.isFile()) continue;
                fileSize += file.length();
            }
            for (File file : this.deb.getSource().getFiles()) {
                if (!file.isFile()) continue;
                fileSize += file.length();
            }
            installSize = String.valueOf(fileSize / 1024L);
        }
        controlWriter.write("Installed-Size: " + installSize + '\n');
    }

    private void putArchitecture(OutputStreamWriter controlWriter) throws IOException {
        controlWriter.write("Architecture: " + this.deb.getArchitecture() + '\n');
    }

    private void putPriority(OutputStreamWriter controlWriter) throws IOException {
        String priority = this.deb.getPriority();
        if (priority == null || priority.length() == 0) {
            priority = "optional";
        }
        controlWriter.write("Priority: " + priority + '\n');
    }

    private void putSection(OutputStreamWriter controlWriter) throws IOException {
        String section = this.deb.getSection();
        if (section == null || section.length() == 0) {
            section = "java";
        }
        controlWriter.write("Section: " + section + '\n');
    }

    private void putVersion(OutputStreamWriter controlWriter) throws IOException {
        String version = this.deb.getVersion();
        if (version == null || version.length() == 0) {
            throw new RuntimeException("No version declared in the setup configuration.");
        }
        controlWriter.write("Version: " + version + '\n');
    }

    private void putPackage(OutputStreamWriter controlWriter) throws IOException {
        String packages = this.setup.getAppIdentifier();
        if (packages == null || packages.length() == 0) {
            throw new RuntimeException("No package declared in the setup configuration.");
        }
        controlWriter.write("Package: " + packages + '\n');
    }

    private void putHomepage(OutputStreamWriter controlWriter) throws IOException {
        String homepage = this.deb.getHomepage();
        if (homepage != null && homepage.length() > 0) {
            controlWriter.write("Homepage: " + homepage + '\n');
        }
    }

    public void addConfFile(String file) {
        this.confFiles.add(file);
    }

    private void createConfFilesFile() throws IOException {
        if (this.confFiles.size() > 0) {
            File cfile = new File(this.buildDir, "conffiles");
            try (FileWriter writer = new FileWriter(cfile);){
                for (String confFile : this.confFiles) {
                    writer.write(47);
                    writer.write(confFile);
                    writer.write(10);
                }
            }
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            Files.setPosixFilePermissions(cfile.toPath(), perms);
        }
    }

    public void addTailScriptFragment(Script script, String scriptFragment) {
        StringBuilder sb = this.scriptTailMap.get((Object)script);
        if (sb == null) {
            sb = new StringBuilder();
            this.scriptTailMap.put(script, sb);
        } else {
            sb.append("\n\n");
        }
        sb.append(scriptFragment);
    }

    public void addHeadScriptFragment(Script script, String scriptFragment) {
        StringBuilder sb = this.scriptHeadMap.get((Object)script);
        if (sb == null) {
            sb = new StringBuilder();
            this.scriptHeadMap.put(script, sb);
        } else {
            sb.append("\n\n");
        }
        sb.append(scriptFragment);
    }

    private void createScripts() throws IOException {
        for (Script script : Script.values()) {
            String scriptName = script.toString().toLowerCase();
            Template tmpl = new Template("unix/deb/template/" + scriptName + ".sh");
            StringBuilder head = this.scriptHeadMap.get((Object)script);
            StringBuilder tail = this.scriptTailMap.get((Object)script);
            if (head == null && tail == null) continue;
            tmpl.setPlaceholder("variables", this.deb.getVariablesTemplate());
            if (head != null) {
                tmpl.setPlaceholder("head", head.toString());
            } else {
                tmpl.setPlaceholder("head", "");
            }
            if (tail != null) {
                tmpl.setPlaceholder("tail", tail.toString());
            } else {
                tmpl.setPlaceholder("tail", "");
            }
            File file = new File(this.buildDir, scriptName);
            tmpl.writeTo(file);
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
    }

    static enum Script {
        PREINST,
        POSTINST,
        PRERM,
        POSTRM;

    }
}

