/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.unix.deb;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.Template;
import com.inet.gradle.setup.abstracts.DesktopStarter;
import com.inet.gradle.setup.abstracts.DocumentType;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.unix.UnixBuilder;
import com.inet.gradle.setup.unix.deb.Deb;
import com.inet.gradle.setup.unix.deb.DebControlFileBuilder;
import com.inet.gradle.setup.unix.deb.DebDocumentFileBuilder;
import com.inet.gradle.setup.util.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.gradle.api.internal.file.FileResolver;

public class DebBuilder
extends UnixBuilder<Deb, SetupBuilder> {
    private DebControlFileBuilder controlBuilder;
    private DebDocumentFileBuilder documentBuilder;

    public DebBuilder(Deb deb, SetupBuilder setup, FileResolver fileResolver) {
        super(deb, setup, fileResolver);
    }

    public void build() {
        try {
            File filesPath = new File(this.buildDir, ((Deb)this.task).getInstallationRoot());
            ((Deb)this.task).copyTo(filesPath);
            this.changeFilePermissionsTo644(filesPath);
            this.addBundleJre(filesPath);
            this.controlBuilder = new DebControlFileBuilder((Deb)this.task, this.setup, new File(this.buildDir, "DEBIAN"));
            this.addScriptsToControlFiles();
            for (Service service : this.setup.getServices()) {
                this.setupService(service);
            }
            for (DesktopStarter desktopStarter : this.setup.getDesktopStarters()) {
                this.setupStarter(desktopStarter);
            }
            if (this.setup.getLicenseFiles().size() > 0) {
                this.setupEula();
            }
            List<String> del_files = this.setup.getDeleteFiles();
            for (String string : del_files) {
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PREINST, "if [ -f \"" + ((Deb)this.task).getInstallationRoot() + "/" + string + "\" ]; then\n  rm -f \"" + ((Deb)this.task).getInstallationRoot() + "/" + string + "\"\nfi\n");
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "if [ -f \"" + ((Deb)this.task).getInstallationRoot() + "/" + string + "\" ]; then\n  rm -f \"" + ((Deb)this.task).getInstallationRoot() + "/" + string + "\"\nfi\n");
            }
            List<String> list = this.setup.getDeleteFolders();
            for (String folder : list) {
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PREINST, "rm -R -f \"" + ((Deb)this.task).getInstallationRoot() + "/" + folder + "\"\n");
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "rm -R -f \"" + ((Deb)this.task).getInstallationRoot() + "/" + folder + "\"\n");
            }
            DesktopStarter desktopStarter = this.setup.getRunAfter();
            String installationRoot = ((Deb)this.task).getInstallationRoot();
            if (desktopStarter != null) {
                String executable = desktopStarter.getExecutable();
                String mainClass = desktopStarter.getMainClass();
                String workingDir = installationRoot + (desktopStarter.getWorkDir() != null ? "/" + desktopStarter.getWorkDir() : "");
                String mainJarPath = workingDir + "/" + desktopStarter.getMainJar();
                if (executable != null) {
                    this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "( cd \"" + workingDir + "\" && " + executable + " " + desktopStarter.getStartArguments() + " & )\n");
                } else if (mainClass != null) {
                    this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "( cd \"" + workingDir + "\" && \"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", desktopStarter.getJavaVMArguments()) + " -cp \"" + mainJarPath + "\" " + mainClass + " " + desktopStarter.getStartArguments() + ")\n");
                }
            }
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "gtk-update-icon-cache /usr/share/icons/hicolor &>/dev/null || : \n");
            DesktopStarter runBeforeUninstall = this.setup.getRunBeforeUninstall();
            if (runBeforeUninstall != null) {
                String executable = runBeforeUninstall.getExecutable();
                String mainClass = runBeforeUninstall.getMainClass();
                String workingDir = installationRoot + (runBeforeUninstall.getWorkDir() != null ? "/" + runBeforeUninstall.getWorkDir() : "");
                String mainJarPath = workingDir + "/" + runBeforeUninstall.getMainJar();
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "case \"$1\" in remove|purge)");
                if (executable != null) {
                    if (((Deb)this.task).getDaemonUser().equalsIgnoreCase("root")) {
                        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "( cd \"" + workingDir + "\" && " + executable + " " + runBeforeUninstall.getStartArguments() + " )");
                    } else {
                        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "(su " + ((Deb)this.task).getDaemonUser() + " -c 'cd \"" + workingDir + "\" && " + executable + " " + runBeforeUninstall.getStartArguments() + "' )");
                    }
                } else if (mainClass != null) {
                    if (((Deb)this.task).getDaemonUser().equalsIgnoreCase("root")) {
                        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "( cd \"" + workingDir + "\" && \"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", runBeforeUninstall.getJavaVMArguments()) + " -cp \"" + mainJarPath + "\" " + mainClass + " " + runBeforeUninstall.getStartArguments() + ")");
                    } else {
                        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "(su " + ((Deb)this.task).getDaemonUser() + " -c 'cd \"" + workingDir + "\" && \"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", runBeforeUninstall.getJavaVMArguments()) + " -cp \"" + mainJarPath + "\" " + mainClass + " " + runBeforeUninstall.getStartArguments() + "' )");
                    }
                }
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "    ;;\nesac");
            }
            this.controlBuilder.build();
            this.documentBuilder = new DebDocumentFileBuilder((Deb)this.task, this.setup, new File(this.buildDir, "/usr/share/doc/" + this.setup.getAppIdentifier()));
            this.documentBuilder.build();
            this.changeDirectoryPermissionsTo755(this.buildDir);
            this.createDebianPackage();
            this.checkDebianPackage();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addScriptsToControlFiles() {
        this.controlBuilder.addHeadScriptFragment(DebControlFileBuilder.Script.PREINST, "# check for java. the service woll need it and other parts probably too[ ! -x '" + this.javaMainExecutable + "' ] && echo \"The program 'java' does not exist but will be needed. (Looked up at '" + this.javaMainExecutable + "')\" && exit 1 || :\n\n");
        String daemonuser = ((Deb)this.task).getDaemonUser();
        if (!daemonuser.equalsIgnoreCase("root")) {
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "useradd -r -m -U " + daemonuser + " 2> /dev/null || true\n[ \"$(id " + daemonuser + " 2> /dev/null 1>&2; echo $?)\" == \"0\" ] && chown -R " + daemonuser + ":" + daemonuser + " '" + ((Deb)this.task).getInstallationRoot() + "' && chmod -R g+w '" + ((Deb)this.task).getInstallationRoot() + "' || true \n\n");
        }
        ArrayList<String> preinsts = ((Deb)this.task).getPreinst();
        for (String string : preinsts) {
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PREINST, string);
        }
        ArrayList<String> postinsts = ((Deb)this.task).getPostinst();
        for (String string : postinsts) {
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, string);
        }
        ArrayList<String> arrayList = ((Deb)this.task).getPrerm();
        for (String prerm : arrayList) {
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, prerm);
        }
        ArrayList<String> arrayList2 = ((Deb)this.task).getPostrm();
        for (String postrm : arrayList2) {
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTRM, postrm);
        }
        if (!daemonuser.equalsIgnoreCase("root")) {
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTRM, "if [ \"$1\" = \"purge\" ] ; then\nuserdel -r " + daemonuser + " 2> /dev/null || true \ngroupdel " + daemonuser + " 2> /dev/null || true \nfi");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupEula() throws IOException {
        String templateLicenseName = this.setup.getAppIdentifier() + "/license";
        String templateAcceptName = this.setup.getAppIdentifier() + "/accept-license";
        String templateErrorName = this.setup.getAppIdentifier() + "/error-license";
        try (FileWriter fw = new FileWriter(this.createFile("DEBIAN/templates", false));){
            fw.write("Template: " + templateLicenseName + "\n");
            fw.write("Type: note\n");
            for (LocalizedResource localizedResource : this.setup.getLicenseFiles()) {
                StringBuffer content = new StringBuffer();
                String lang = localizedResource.getLanguage().equalsIgnoreCase(this.setup.getDefaultResourceLanguage()) ? "" : "-" + localizedResource.getLanguage();
                content.append("Description" + lang + ": License agreement\n");
                try {
                    Scanner scanner = new Scanner(localizedResource.getResource(), "UTF8");
                    Throwable throwable = null;
                    try {
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            content.append(" " + (line.isEmpty() ? Character.valueOf('.') : line) + "\n");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                finally {
                    fw.write(content.toString());
                }
            }
            fw.write(10);
            fw.write("Template: " + templateAcceptName + "\n");
            fw.write("Type: boolean\n");
            fw.write("Description: Do you accept the license agreement?\n");
            fw.write("Description-de.UTF-8: Akzeptieren Sie die Lizenzvereinbarung?\n");
            fw.write(10);
            fw.write("Template: " + templateErrorName + "\n");
            fw.write("Type: error\n");
            fw.write("Description: It is required to accept the license to install this package.\n");
            fw.write("Description-de.UTF-8: Zur Installation dieser Anwendung m\u00fcssen Sie die Lizenz akzeptieren.\n");
            fw.write(10);
        }
        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTRM, "if [ \"$1\" = \"remove\" ] || [ \"$1\" = \"purge\" ]  ; then\n  db_purge\nfi");
        this.controlBuilder.addHeadScriptFragment(DebControlFileBuilder.Script.PREINST, "if [ \"$1\" = \"install\" ] ; then\n  db_get " + templateAcceptName + "\n  if [ \"$RET\" = \"true\" ]; then\n    echo \"License already accepted\"\n  else\n    db_input high " + templateLicenseName + " || true\n    db_input high " + templateAcceptName + " || true\n    db_go\n    db_get " + templateAcceptName + "\n    if [ \"$RET\" != \"true\" ]; then\n        echo \"License was not accepted by the user\"\n        db_input high " + templateErrorName + " || true\n        db_go\n        db_purge\n        exit 1\n    fi\n  fi\nfi");
    }

    private void setupService(Service service) throws IOException {
        String serviceUnixName = service.getId();
        String installationRoot = ((Deb)this.task).getInstallationRoot();
        String workingDir = installationRoot + (service.getWorkDir() != null ? "/" + service.getWorkDir() : "");
        String mainJarPath = workingDir + "/" + service.getMainJar();
        Template initScript = new Template("unix/init-service.sh");
        initScript.setPlaceholder("name", serviceUnixName);
        String version = ((Deb)this.task).getVersion();
        initScript.setPlaceholder("majorversion", version.substring(0, version.indexOf(46)));
        initScript.setPlaceholder("displayName", this.setup.getApplication());
        initScript.setPlaceholder("description", service.getDescription());
        initScript.setPlaceholder("wait", "2");
        initScript.setPlaceholder("workdir", workingDir);
        initScript.setPlaceholder("mainJar", mainJarPath);
        initScript.setPlaceholder("startArguments", service.getStartArguments().trim());
        initScript.setPlaceholder("javaVMArguments", String.join((CharSequence)" ", service.getJavaVMArguments()).trim());
        initScript.setPlaceholder("mainClass", service.getMainClass());
        initScript.setPlaceholder("daemonUser", ((Deb)this.task).getDaemonUser());
        initScript.setPlaceholder("daemonExec", this.javaMainExecutable);
        initScript.setPlaceholder("additionalServiceScript", ((Deb)this.task).getAdditionalServiceScript());
        String initScriptFile = "etc/init.d/" + serviceUnixName;
        initScript.writeTo(this.createFile(initScriptFile, true));
        if (((Deb)this.task).getDefaultServiceFile() != null) {
            File serviceDestFile = new File(this.buildDir.getAbsolutePath(), "/etc/default/" + serviceUnixName);
            serviceDestFile.mkdirs();
            Files.copy(((Deb)this.task).getDefaultServiceFile().toPath(), serviceDestFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "[ -f \"/etc/init.d/" + serviceUnixName + "\" ] && update-rc.d " + serviceUnixName + " defaults 91 09 >/dev/null || true");
        if (((Deb)this.task).shouldStartDefaultService()) {
            this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "[ -f \"/etc/init.d/" + serviceUnixName + "\" ] && service " + serviceUnixName + " start || true");
        }
        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "[ -f \"/etc/init.d/" + serviceUnixName + "\" ] && service " + serviceUnixName + " stop || true");
        this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTRM, "[ \"$1\" = \"purge\" ] && update-rc.d " + serviceUnixName + " remove >/dev/null || true ");
    }

    private void setupStarter(DesktopStarter starter) throws IOException {
        String unixName = starter.getDisplayName();
        String consoleStarterPath = "usr/bin/" + unixName;
        try (FileWriter fw = new FileWriter(this.createFile(consoleStarterPath, true));){
            fw.write("#!/bin/bash\n");
            if (starter.getExecutable() != null) {
                fw.write("\"" + ((Deb)this.task).getInstallationRoot() + "/" + starter.getExecutable() + "\" " + starter.getStartArguments() + " \"$@\"");
            } else {
                fw.write("\"" + this.javaMainExecutable + "\" " + String.join((CharSequence)" ", starter.getJavaVMArguments()) + " -cp \"" + ((Deb)this.task).getInstallationRoot() + "/" + starter.getMainJar() + "\" " + starter.getMainClass() + " " + starter.getStartArguments() + " \"$@\"");
            }
        }
        int[] iconSizes = new int[]{16, 32, 48, 64, 128};
        String iconName = "";
        if (starter.getIcons() != null) {
            iconName = starter.getIcons().toString();
            int index = iconName.lastIndexOf(47);
            if (index > -1) {
                iconName = iconName.substring(index + 1);
            }
            if (!iconName.endsWith(".png")) {
                index = iconName.lastIndexOf(46);
                if (index > -1) {
                    iconName = iconName.substring(0, index);
                }
                iconName = iconName + ".png";
            }
        }
        for (int size : iconSizes) {
            File iconDir = new File(this.buildDir, "usr/share/icons/hicolor/" + size + "x" + size + "/apps/");
            iconDir.mkdirs();
            File scaledFile = this.setup.getIconForType(iconDir, "png" + size);
            if (scaledFile == null) continue;
            File iconFile = starter.getIcons() != null ? new File(iconDir, iconName) : new File(iconDir, unixName + ".png");
            scaledFile.renameTo(iconFile);
            DebBuilder.setPermissions(iconFile, false);
        }
        try (FileWriter fw = new FileWriter(this.createFile("usr/share/applications/" + unixName + ".desktop", false));){
            fw.write("[Desktop Entry]\n");
            fw.write("Name=" + starter.getDisplayName() + "\n");
            fw.write("Comment=" + starter.getDescription().replace('\n', ' ') + "\n");
            if (starter.getExecutable() != null) {
                fw.write("Exec=\"" + ((Deb)this.task).getInstallationRoot() + "/" + starter.getExecutable() + "\"\n");
            } else {
                fw.write("Exec=\"/" + consoleStarterPath + "\" %F\n");
            }
            if (starter.getIcons() != null) {
                int index = iconName.lastIndexOf(46);
                if (index > -1) {
                    iconName = iconName.substring(0, index);
                }
                fw.write("Icon=" + iconName + "\n");
            } else {
                fw.write("Icon=" + unixName + "\n");
            }
            String cwd = starter.getWorkDir();
            if (cwd != null) {
                if (cwd.isEmpty() || cwd.equals(".")) {
                    fw.write("Path=" + ((Deb)this.task).getInstallationRoot() + "\n");
                } else {
                    fw.write("Path=" + cwd + "\n");
                }
            }
            fw.write("Terminal=false\n");
            fw.write("StartupNotify=true\n");
            fw.write("Type=Application\n");
            if (starter.getMimeTypes() != null) {
                fw.write("MimeType=" + starter.getMimeTypes() + "\n");
            }
            if (starter.getCategories() != null) {
                fw.write("Categories=" + starter.getCategories() + "\n");
            }
        }
        for (DocumentType docType : starter.getDocumentType()) {
            for (String extension : docType.getFileExtension()) {
                String simpleVendor = this.setup.getVendor();
                simpleVendor = simpleVendor.replaceAll("\\W", "");
                try (FileWriter fw = new FileWriter(this.createFile(((Deb)this.task).getInstallationRoot() + "/" + simpleVendor + "-" + extension + ".xml", false));){
                    fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    fw.write("<mime-info xmlns=\"http://www.freedesktop.org/standards/shared-mime-info\">\n");
                    if (starter.getMimeTypes() != null) {
                        fw.write("    <mime-type type=\"" + starter.getMimeTypes() + "\">\n");
                    } else {
                        fw.write("    <mime-type type=\"" + docType.getMimetype() + "\">\n");
                    }
                    fw.write("        <comment>" + this.setup.getApplication() + "</comment>\n");
                    fw.write("        <glob-deleteall/>\n");
                    fw.write("        <glob pattern=\"*." + extension + "\"/>\n");
                    fw.write("    </mime-type>\n");
                    fw.write("</mime-info>\n");
                }
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "xdg-mime install \"" + ((Deb)this.task).getInstallationRoot() + "/" + simpleVendor + "-" + extension + ".xml\" || true");
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "xdg-mime uninstall \"" + ((Deb)this.task).getInstallationRoot() + "/" + simpleVendor + "-" + extension + ".xml\" || true");
                String iconame = unixName;
                if (starter.getIcons() != null) {
                    iconame = iconName;
                }
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.POSTINST, "xdg-icon-resource install --context mimetypes --novendor --size 48 /usr/share/icons/hicolor/48x48/apps/" + iconame + ".png " + iconame + " || true");
                this.controlBuilder.addTailScriptFragment(DebControlFileBuilder.Script.PRERM, "xdg-icon-resource uninstall --context mimetypes --size 48 " + iconame + " || true");
            }
        }
    }

    private File createFile(String path, boolean executable) throws IOException {
        File file = new File(this.buildDir, path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        DebBuilder.setPermissions(file, executable);
        return file;
    }

    private void checkDebianPackage() {
        if (((Deb)this.task).shouldCheckPackage()) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("lintian");
            command.add(((Deb)this.task).getLintianOptions());
            command.add(((Deb)this.task).getSetupFile().getPath());
            this.exec(command);
        }
    }

    private void createDebianPackage() {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add("fakeroot");
            command.add("dpkg-deb");
            command.add("--build");
            command.add(this.buildDir.getAbsolutePath());
            command.add(((Deb)this.task).getSetupFile().getPath());
            this.exec(command);
        }
        catch (Throwable e) {
            Logging.syserr("Error. Control File was:");
            try {
                Logging.syserr(String.join((CharSequence)"\n", Files.readAllLines(new File(this.buildDir.getAbsolutePath(), "DEBIAN/control").toPath())));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw e;
        }
    }
}

