/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.unix;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.AbstractBuilder;
import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.unix.Unix;
import com.inet.gradle.setup.util.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileResolver;

public abstract class UnixBuilder<T extends Unix, S extends AbstractSetupBuilder>
extends AbstractBuilder<T, S> {
    protected SetupBuilder setup;
    private String javaCommandSuffix = "/bin/java";
    protected String javaMainExecutable = "/usr" + this.javaCommandSuffix;

    protected UnixBuilder(T task, SetupBuilder setup, FileResolver fileResolver) {
        super(task, fileResolver);
        this.setup = setup;
    }

    protected void addBundleJre(File filesPath) throws IOException {
        File jreDir = ((Unix)this.task).getBundleJre();
        if (jreDir == null) {
            ((Unix)this.task).getProject().getLogger().lifecycle("\tNo JRE for bundling set.");
            return;
        }
        File jreTarget = new File(filesPath, this.setup.getBundleJreTarget());
        if (jreDir.isDirectory()) {
            File jdkCheck = new File(jreDir, "jre");
            if (jdkCheck.isDirectory()) {
                jreDir = jdkCheck;
            }
            this.checkForBinJava(jreDir);
            ((Unix)this.task).getProject().getLogger().lifecycle("\tJRE is set and will be copied from: '" + jreDir.getAbsolutePath() + "' to' " + jreTarget.getAbsolutePath() + "'");
            ResourceUtils.copy(jreDir, jreTarget);
        } else if (jreDir.isFile()) {
            FileTree tree = null;
            if (jreDir.getName().endsWith(".zip")) {
                tree = this.setup.getProject().zipTree((Object)jreDir);
            } else if (jreDir.getName().endsWith(".tar.gz") || jreDir.getName().endsWith(".tgz")) {
                tree = this.setup.getProject().tarTree((Object)jreDir);
            } else {
                throw new GradleException("Unsupported content set as Java Runtime, please use .zip, .tar.gz or .tgz - or a Directory '" + jreDir + "'");
            }
            FileTree sourceTree = tree;
            File javaCopy = new File(this.setup.getProject().getBuildDir() + "/java_copy");
            this.setup.getProject().copy(spec -> {
                spec.from(new Object[]{sourceTree});
                spec.into((Object)javaCopy);
            });
            File[] files = javaCopy.listFiles();
            if (files != null && files.length == 1) {
                Files.move(files[0].toPath(), jreTarget.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(javaCopy.toPath(), jreTarget.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            this.checkForBinJava(jreTarget);
        } else {
            throw new GradleException("Unsupported content set as Java Runtime '" + jreDir + "'");
        }
        this.javaMainExecutable = String.join((CharSequence)"/", ((Unix)this.task).getInstallationRoot(), this.setup.getBundleJreTarget(), this.javaCommandSuffix).replaceAll("\\/+", "\\/");
        ((Unix)this.task).getProject().getLogger().lifecycle("\tUpdated the Java Executable Path to: '" + this.javaMainExecutable + "'");
    }

    private void checkForBinJava(File jreDir) {
        File javaCommand = new File(jreDir, this.javaCommandSuffix);
        String javaVersion = this.exec("sh", "-c", javaCommand.getAbsolutePath() + " -version 2>&1 | awk -F '\"' '/version/ {print $2}'");
        if (javaVersion.length() == 0) {
            throw new GradleException("Java - Command '" + this.javaCommandSuffix + "' not found in '" + jreDir + "'");
        }
    }

    protected void changeDirectoryPermissionsTo755(File path) throws IOException {
        if (path == null) {
            return;
        }
        UnixBuilder.setPermissions(path, true);
        for (File file : path.listFiles()) {
            if (!file.isDirectory()) continue;
            this.changeDirectoryPermissionsTo755(file);
        }
    }

    protected void changeFilePermissionsTo644(File path) throws IOException {
        if (path == null) {
            return;
        }
        for (File file : path.listFiles()) {
            if (file.isDirectory()) {
                this.changeFilePermissionsTo644(file);
                continue;
            }
            if (file.getName().endsWith(".sh")) {
                UnixBuilder.setPermissions(file, true);
                continue;
            }
            UnixBuilder.setPermissions(file, false);
        }
    }

    public static void setPermissions(File file, boolean executable) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.OTHERS_READ);
        if (executable) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        try {
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }
}

