/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.unix;

import com.inet.gradle.setup.abstracts.AbstractUnixSetupTask;
import java.io.File;

public abstract class Unix
extends AbstractUnixSetupTask {
    private String section;
    private String architecture;
    private String recommends;
    private String depends;
    private String homepage;
    private String installationRoot;
    private Object defaultServiceFile;
    private boolean startDefaultService = true;
    private String additionalServiceScript;
    private Object bundleJre;

    public Unix(String format) {
        super(format);
    }

    public String getVariablesTemplate() {
        String variables = "";
        variables = variables + "APPLICATION_DISPLAY_NAME=\"" + this.getSetupBuilder().getApplication() + "\"\n";
        variables = variables + "DAEMON_USER=\"" + this.getDaemonUser() + "\"\n";
        variables = variables + "INSTALLATION_ROOT=\"" + this.getInstallationRoot() + "\"\n";
        return variables;
    }

    public String getSection() {
        if (this.section != null) {
            return this.section;
        }
        return "Applications/Productivity";
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getRecommends() {
        return this.recommends;
    }

    public void setRecommends(String recommends) {
        this.recommends = recommends;
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String depends) {
        this.depends = depends;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getInstallationRoot() {
        if (this.installationRoot == null) {
            return "/usr/share/" + this.getSetupBuilder().getApplication().toLowerCase().replaceAll("[^a-z0-9-_]", "-");
        }
        return this.installationRoot;
    }

    public void setInstallationRoot(String installationRoot) {
        this.installationRoot = installationRoot.endsWith("/") ? installationRoot.substring(0, installationRoot.length() - 1) : installationRoot;
    }

    public File getDefaultServiceFile() {
        if (this.defaultServiceFile != null) {
            return this.getProject().file(this.defaultServiceFile);
        }
        return null;
    }

    public void setDefaultServiceFile(Object defaultServiceFile) {
        this.defaultServiceFile = defaultServiceFile;
    }

    public String getAdditionalServiceScript() {
        return this.additionalServiceScript != null ? this.additionalServiceScript : "";
    }

    public void setAdditionalServiceScript(String additionalServiceScript) {
        this.additionalServiceScript = additionalServiceScript;
    }

    public boolean shouldStartDefaultService() {
        return this.startDefaultService;
    }

    public void setStartDefaultService(boolean startDefaultService) {
        this.startDefaultService = startDefaultService;
    }

    public File getBundleJre() {
        Object jre = this.bundleJre;
        if (jre == null) {
            jre = this.getSetupBuilder().getBundleJre();
        }
        if (jre == null) {
            return null;
        }
        File jreDir = null;
        try {
            jreDir = this.getProject().file(jre);
        }
        catch (Exception e) {
            this.getProject().getLogger().error("bundleJre version '" + jre + "' can not be resolved to a Java Runtime Directory which is required for embedding!");
        }
        return jreDir;
    }

    public void setBundleJre(Object bundleJre) {
        this.bundleJre = bundleJre;
    }
}

