/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.DesktopStarter;
import com.inet.gradle.setup.abstracts.DocumentType;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.abstracts.ProtocolHandler;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.msi.CommandLine;
import com.inet.gradle.setup.msi.Msi;
import com.inet.gradle.setup.msi.MsiLanguages;
import com.inet.gradle.setup.msi.MsiLocalizedResource;
import com.inet.gradle.setup.util.ResourceUtils;
import com.inet.gradle.setup.util.Strings;
import com.inet.gradle.setup.util.XmlFileBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class WxsFileBuilder
extends XmlFileBuilder<Msi> {
    private static final String ICON_ID = "icon.ico";
    private Set<String> components = new LinkedHashSet<String>();
    private HashMap<String, String> ids = new HashMap();
    private String jvmDll;
    private String javaDir;
    private boolean isAddFiles;
    private Element product;
    private Element installDir;

    WxsFileBuilder(Msi msi, SetupBuilder setup, File wxsFile, File buildDir, URL template, boolean addFiles) throws Exception {
        super(msi, setup, wxsFile, buildDir, template);
        this.isAddFiles = addFiles;
    }

    void build() throws Exception {
        Element wix = this.getOrCreateChild(this.doc, "Wix", true);
        wix.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.microsoft.com/wix/2006/wi");
        wix.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:util", "http://schemas.microsoft.com/wix/UtilExtension");
        this.product = this.getOrCreateChild(wix, "Product");
        this.addAttributeIfNotExists(this.product, "Id", UUID.randomUUID().toString());
        this.addAttributeIfNotExists(this.product, "Language", "1033");
        this.addAttributeIfNotExists(this.product, "Manufacturer", this.setup.getVendor());
        this.addAttributeIfNotExists(this.product, "Name", this.setup.getApplication());
        this.addAttributeIfNotExists(this.product, "Version", ((Msi)this.task).getVersion());
        this.addAttributeIfNotExists(this.product, "UpgradeCode", this.getGuid("UpgradeCode"));
        Element media = this.getOrCreateChildById(this.product, "Media", "1", false);
        this.addAttributeIfNotExists(media, "Cabinet", "media1.cab");
        this.addAttributeIfNotExists(media, "EmbedCab", "yes");
        Element packge = this.getOrCreateChild(this.product, "Package", false);
        if (this.product.getFirstChild() != packge) {
            this.product.insertBefore(packge, this.product.getFirstChild());
        }
        this.addAttributeIfNotExists(packge, "Compressed", "yes");
        if (!this.setup.getDescription().isEmpty()) {
            this.addAttributeIfNotExists(packge, "Comments", this.setup.getDescription());
        }
        this.addAttributeIfNotExists(packge, "InstallScope", ((Msi)this.task).getInstallScope().name());
        if (((Msi)this.task).getMultiInstanceCount() <= 1) {
            Element update = this.getOrCreateChild(this.product, "MajorUpgrade");
            this.addAttributeIfNotExists(update, "AllowDowngrades", "yes");
        }
        Element directory = this.getOrCreateChildById(this.product, "Directory", "TARGETDIR");
        this.addAttributeIfNotExists(directory, "Name", "SourceDir");
        Element programFiles = this.getOrCreateChildById(directory, "Directory", ((Msi)this.task).is64Bit() ? "ProgramFiles64Folder" : "ProgramFilesFolder");
        Element appDirectory = this.getOrCreateChildById(programFiles, "Directory", "INSTALLDIR");
        this.addAttributeIfNotExists(appDirectory, "Name", this.setup.getApplication());
        this.installDir = this.getOrCreateChildById(this.product, "DirectoryRef", "INSTALLDIR");
        ((Msi)this.task).processFiles(new CopyActionProcessingStreamAction(){

            public void processFile(FileCopyDetailsInternal details) {
                block4: {
                    try {
                        File file;
                        if (details.isDirectory()) break block4;
                        String[] segments = details.getRelativePath().getSegments();
                        try {
                            file = details.getFile();
                        }
                        catch (UnsupportedOperationException ex) {
                            File buildDir = ((Msi)WxsFileBuilder.this.task).getTemporaryDir();
                            file = new File(buildDir, details.getRelativePath().getPathString());
                            details.copyTo(file);
                        }
                        WxsFileBuilder.this.addFile(file, segments);
                    }
                    catch (Exception ex) {
                        throw new GradleException("Can't add file: " + details, (Throwable)ex);
                    }
                }
            }
        });
        this.setMinimumOsVersion();
        this.setOnly32BitCondition();
        this.saveLoadLastInstallDir();
        this.addMultiInstanceTransforms();
        this.addBundleJre();
        this.addGUI();
        this.addIcon();
        this.addServices();
        this.addShortcutsAndRegisterProtocols();
        this.addRunBeforeUninstall();
        this.addRunAfter();
        this.addDeleteFiles();
        this.addPreAndPostScripts();
        Element feature = this.getOrCreateChildById(this.product, "Feature", "MainApplication");
        for (String compID : this.components) {
            this.getOrCreateChildById(feature, "ComponentRef", compID);
        }
        this.save();
    }

    private void registerSchemeDefinition(ProtocolHandler handler) {
        for (String scheme : handler.getSchemes()) {
            Element registryEntries = this.getComponent(this.installDir, this.id(scheme) + "protocol_handler_RegistryEntries");
            Element registryKey = this.addRegistryKey(registryEntries, "HKCR", this.id(scheme + "_protocol_handler"), scheme);
            this.addRegistryValue(registryKey, null, "string", handler.getDisplayName());
            this.addRegistryValue(registryKey, "URL Protocol", "string", "");
            Element registrySubKey = this.addRegistryKey(registryEntries, "HKCR", this.id(scheme + "_protocol_handler_shell"), scheme + "\\shell\\open\\command");
            CommandLine cmd = new CommandLine(handler, this.javaDir);
            String fullCommand = cmd.full;
            if (!fullCommand.contains("%1")) {
                fullCommand = fullCommand + " \"%1\"";
            }
            this.addRegistryValue(registrySubKey, null, "string", fullCommand);
        }
    }

    private void setMinimumOsVersion() {
        String os;
        double version = ((Msi)this.task).getMinOS();
        if (version == 0.0) {
            return;
        }
        int intVersion = 100 * (int)version + (int)(version * 10.0 % 10.0);
        switch (intVersion) {
            case 1000: {
                os = "Windows 10, Windows Server 2016";
                break;
            }
            case 603: {
                os = "Windows 8.1, Windows Server 2012 R2";
                break;
            }
            case 602: {
                os = "Windows 8, Windows Server 2012";
                break;
            }
            case 601: {
                os = "Windows 7, Windows Server 2008 R2";
                break;
            }
            case 600: {
                os = "Windows Vista, Windows Server 2008";
                break;
            }
            case 502: {
                os = "Windows Server 2003";
                break;
            }
            case 501: {
                os = "Windows XP";
                break;
            }
            case 500: {
                os = "Windows 2000";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported minimum OS version: " + version + ", " + intVersion);
            }
        }
        String msg = MessageFormat.format("{0} is only supported on {1}, or higher.", this.setup.getApplication(), os);
        Element condition = this.getOrCreateChildByKeyValue(this.product, "Condition", "Message", msg);
        condition.setTextContent("Installed OR (VersionNT >= " + intVersion + ")");
    }

    private void setOnly32BitCondition() {
        if (!((Msi)this.task).isOnly32Bit()) {
            return;
        }
        String msg = "You are attempting to run the 32-bit installer on a 64-bit version of Windows.";
        Element condition = this.getOrCreateChildByKeyValue(this.product, "Condition", "Message", msg);
        condition.setTextContent("NOT Msix64");
    }

    private void saveLoadLastInstallDir() {
        String key = "Software\\" + this.setup.getVendor() + '\\' + this.setup.getApplication() + '\\' + "LastInstallDir";
        Element component = this.getComponent(this.installDir, "install_path");
        Element regkey = this.addRegistryKey(component, "HKLM", "install_path_reg", key);
        this.addRegistryValue(regkey, null, "string", "[INSTALLDIR]");
        Element lastInstalldir = this.getOrCreateChildById(this.product, "Property", "INSTALLDIR");
        this.addAttributeIfNotExists(lastInstalldir, "Secure", "yes");
        Element search = this.getOrCreateChildById(lastInstalldir, "RegistrySearch", "SearchInstallDir");
        this.addAttributeIfNotExists(search, "Root", "HKLM");
        this.addAttributeIfNotExists(search, "Key", key);
        this.addAttributeIfNotExists(search, "Type", "directory");
    }

    private Element getDirectory(String[] segments) {
        return this.getDirectory(segments, segments.length - 1);
    }

    private Element getDirectory(String[] segments, int length) {
        Element parent = this.installDir;
        for (int i = 0; i < length; ++i) {
            String seg = segments[i];
            parent = this.getOrCreateChildById(parent, "Directory", this.id(segments, i + 1));
            this.addAttributeIfNotExists(parent, "Name", seg);
        }
        return parent;
    }

    private Element getComponent(Element dir, String compID) {
        this.components.add(compID);
        Element component = this.getOrCreateChildById(dir, "Component", compID);
        this.addAttributeIfNotExists(component, "Guid", this.getGuid(compID));
        if (((Msi)this.task).getMultiInstanceCount() > 1) {
            this.addAttributeIfNotExists(component, "MultiInstance", "yes");
        }
        return component;
    }

    private String addFile(File file, String[] segments) {
        Element parent = this.getDirectory(segments);
        String pathID = this.id(segments, segments.length - 1);
        String compID = this.id((pathID.length() > 0 ? pathID : "root") + "_Comp");
        Element component = this.getComponent(parent, compID);
        String name = segments[segments.length - 1];
        String id = this.addFile(component, file, segments, this.isAddFiles);
        ((Msi)this.task).getProject().getLogger().debug("adding file: '" + file.toString() + "' '" + name + "' '" + id + "' '" + pathID + "' '" + compID + "' '" + String.join((CharSequence)"%", segments) + "'");
        if (name.equals("jvm.dll")) {
            StringBuilder jvm = new StringBuilder();
            for (String segment : segments) {
                if (jvm.length() > 0) {
                    jvm.append('\\');
                }
                jvm.append(segment);
            }
            this.jvmDll = jvm.toString();
        }
        return id;
    }

    private String addFile(Element component, File file, String[] segments, boolean isAddFiles) {
        String name = segments[segments.length - 1];
        String id = this.id(segments, segments.length);
        if (isAddFiles) {
            Element fileEl = this.getOrCreateChildById(component, "File", id);
            this.addAttributeIfNotExists(fileEl, "Source", file.getAbsolutePath());
            this.addAttributeIfNotExists(fileEl, "Name", name);
        } else {
            this.getOrCreateChild(component, "CreateFolder");
        }
        return id;
    }

    private void addDirectory(File dir, int baseLength, String target) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.addDirectory(file, baseLength, target);
                continue;
            }
            String name = file.getAbsolutePath().substring(baseLength);
            this.addFile(file, this.segments(target + name));
        }
    }

    private void addBundleJre() {
        File jreDir;
        Object jre = this.setup.getBundleJre();
        if (jre == null) {
            return;
        }
        try {
            jreDir = ((Msi)this.task).getProject().file(jre);
        }
        catch (Exception e) {
            jreDir = null;
        }
        if (jreDir == null || !jreDir.isDirectory()) {
            String programFiles = System.getenv(((Msi)this.task).is64Bit() ? "ProgramW6432" : "ProgramFiles(x86)");
            if (programFiles == null) {
                throw new GradleException("Environment ProgramFiles not found.");
            }
            File java = new File(new File(programFiles), "Java");
            if (!java.isDirectory()) {
                throw new GradleException("No installed Java VMs found: " + java);
            }
            List<File> versions = WxsFileBuilder.getMatchingJREs(java, jre.toString());
            if (versions.isEmpty()) {
                throw new GradleException("bundleJre version " + jre + " can not be found in: '" + java + "' Its search for an folder that starts with: jre" + jre);
            }
            Collections.sort(versions);
            jreDir = versions.get(versions.size() - 1);
            if (jreDir.getName().startsWith("jdk")) {
                jreDir = new File(jreDir, "jre");
            }
        }
        ((Msi)this.task).getProject().getLogger().lifecycle("\tbundle jre: " + jreDir);
        int baseLength = jreDir.getAbsolutePath().length();
        this.javaDir = this.setup.getBundleJreTarget().replace('/', '\\');
        if (this.javaDir.endsWith("\\")) {
            ++baseLength;
        }
        this.addDirectory(jreDir, baseLength, this.javaDir);
    }

    private static List<File> getMatchingJREs(File parent, String jre) {
        if (jre.length() > 2 && jre.startsWith("1.")) {
            jre = jre.substring(2);
        }
        Pattern jreMatcher = Pattern.compile("\\Aj(re|dk)-?(1\\.)?" + Pattern.quote(jre));
        List<File> versions = Arrays.asList(parent.listFiles(file -> file.isDirectory() && jreMatcher.matcher(file.getName()).find()));
        return versions;
    }

    private void addGUI() throws Exception {
        Element licenseNode;
        File file;
        Element wixUiInstalldir = this.getOrCreateChildById(this.product, "Property", "WIXUI_INSTALLDIR");
        this.addAttributeIfNotExists(wixUiInstalldir, "Value", "INSTALLDIR");
        this.getOrCreateChildById(this.product, "UIRef", "WixUI_ErrorProgressText");
        this.getOrCreateChildById(this.product, "UIRef", "WixUI_InstallDir");
        boolean isLicense = this.addLicense(this.product);
        if (!isLicense) {
            Element ui = this.getOrCreateChild(this.product, "UI");
            Element child = this.getOrCreateChildByKeyValue(ui, "Publish", "Dialog", "WelcomeDlg");
            child.setAttribute("Control", "Next");
            child.setAttribute("Event", "NewDialog");
            child.setAttribute("Value", "InstallDirDlg");
            child.setAttribute("Order", "2");
            child.setTextContent("1");
            child = this.getOrCreateChildByKeyValue(ui, "Publish", "Dialog", "InstallDirDlg");
            child.setAttribute("Control", "Back");
            child.setAttribute("Event", "NewDialog");
            child.setAttribute("Value", "WelcomeDlg");
            child.setAttribute("Order", "2");
            child.setTextContent("1");
        }
        if ((file = ((Msi)this.task).getBannerBmp()) != null) {
            licenseNode = this.getOrCreateChildById(this.product, "WixVariable", "WixUIBannerBmp");
            this.addAttributeIfNotExists(licenseNode, "Value", file.getAbsolutePath());
        }
        if ((file = ((Msi)this.task).getDialogBmp()) != null) {
            licenseNode = this.getOrCreateChildById(this.product, "WixVariable", "WixUIDialogBmp");
            this.addAttributeIfNotExists(licenseNode, "Value", file.getAbsolutePath());
        }
    }

    private void addIcon() throws IOException {
        File iconFile = this.setup.getIconForType(this.buildDir, "ico");
        if (iconFile == null) {
            return;
        }
        Element icon = this.getOrCreateChildById(this.product, "Icon", ICON_ID);
        this.addAttributeIfNotExists(icon, "SourceFile", iconFile.getAbsolutePath());
        Element appProduction = this.getOrCreateChildById(this.product, "Property", "ARPPRODUCTICON");
        this.addAttributeIfNotExists(appProduction, "Value", ICON_ID);
    }

    private boolean addLicense(Element product) throws Exception {
        if (this.setup.getLicenseFiles().size() == 0) {
            return false;
        }
        File res = null;
        for (LocalizedResource localizedResource : this.setup.getLicenseFiles()) {
            boolean isRtf;
            String lang = localizedResource.getLanguage();
            File rtfOutputName = MsiLocalizedResource.localizedRtfFile(((Msi)this.task).getTemporaryDir(), MsiLanguages.getMsiLanguage(lang));
            try (FileInputStream fis = new FileInputStream(localizedResource.getResource());){
                byte[] bytes = new byte[5];
                fis.read(bytes);
                isRtf = "{\\rtf".equals(new String(bytes));
            }
            if (!isRtf) {
                JEditorPane p = new JEditorPane();
                EditorKit kit = p.getEditorKitForContentType("text/plain; charset=utf-8");
                p.setContentType("text/rtf");
                DefaultStyledDocument doc = (DefaultStyledDocument)p.getDocument();
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(localizedResource.getResource()), StandardCharsets.UTF_8);){
                    kit.read(reader, (Document)doc, 0);
                }
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                StyleConstants.setFontSize(attrs, 9);
                StyleConstants.setFontFamily(attrs, "Courier New");
                doc.setCharacterAttributes(0, doc.getLength(), attrs, false);
                kit = p.getEditorKitForContentType("text/rtf");
                try (FileOutputStream output = new FileOutputStream(rtfOutputName);){
                    kit.write(output, (Document)doc, 0, doc.getLength());
                }
            }
            var9_9 = null;
            try (FileInputStream input = new FileInputStream(localizedResource.getResource());){
                Files.copy(input, rtfOutputName.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            if (res != null) continue;
            res = rtfOutputName;
        }
        File defaultLicenseResource = MsiLocalizedResource.localizedRtfFile(((Msi)this.task).getTemporaryDir(), MsiLanguages.getMsiLanguage(this.setup.getDefaultResourceLanguage()));
        if (defaultLicenseResource == null) {
            defaultLicenseResource = res;
        }
        Element licenseNode = this.getOrCreateChildById(product, "WixVariable", "WixUILicenseRtf");
        this.addAttributeIfNotExists(licenseNode, "Value", defaultLicenseResource.getAbsolutePath());
        this.addAttributeIfNotExists(licenseNode, "Overridable", "yes");
        return true;
    }

    private void addServices() throws IOException {
        List<Service> services = this.setup.getServices();
        if (services == null || services.isEmpty()) {
            return;
        }
        File prunsrv = ResourceUtils.extract(this.getClass(), ((Msi)this.task).getArch() + "/prunsrv.exe", this.buildDir);
        File prunmgr = ResourceUtils.extract(this.getClass(), "x86/prunmgr.exe", this.buildDir);
        for (Service service : services) {
            String name = service.getId();
            String id = this.id(name.replace('-', '_')) + "_service";
            String exe = service.getWrapper().replace('\\', '/') + ".exe";
            String subdir = service.getWorkDir();
            if (subdir != null && !subdir.isEmpty()) {
                exe = new File(new File(subdir), exe).getPath();
                if (!subdir.endsWith("\\")) {
                    subdir = subdir + '\\';
                }
            } else {
                subdir = "";
            }
            String logPath = Strings.defaultString(service.getLogPath(), "[INSTALLDIR]" + subdir);
            String logPrefix = Strings.defaultString(service.getLogPrefix(), "service");
            String logLevel = service.getLogLevel();
            String pidFile = service.getPidFile();
            String stdOutput = service.getStdOutput();
            String stdError = service.getStdError();
            String libraryPath = service.getLibraryPath();
            String javaHome = service.getJavaHome();
            String jvm = service.getJvm();
            String[] segments = this.segments(exe);
            Element directory = this.getDirectory(segments);
            Element component = this.getComponent(directory, id);
            this.addFile(component, prunsrv, segments, true);
            Element install = this.getOrCreateChildById(component, "ServiceInstall", id + "_install");
            this.addAttributeIfNotExists(install, "Name", name);
            this.addAttributeIfNotExists(install, "DisplayName", service.getDisplayName());
            if (!service.getDescription().isEmpty()) {
                this.addAttributeIfNotExists(install, "Description", service.getDescription());
            }
            this.addAttributeIfNotExists(install, "Start", service.isStartOnBoot() ? "auto" : "demand");
            this.addAttributeIfNotExists(install, "Type", "ownProcess");
            this.addAttributeIfNotExists(install, "ErrorControl", "normal");
            this.addAttributeIfNotExists(install, "Arguments", " \"//RS//" + name + "\"");
            Element regkey = this.getOrCreateChildById(component, "RegistryKey", id + "_RegParameters");
            this.addAttributeIfNotExists(regkey, "Root", "HKLM");
            this.addAttributeIfNotExists(regkey, "Key", "SYSTEM\\CurrentControlSet\\Services\\" + name + "\\Parameters");
            this.addAttributeIfNotExists(regkey, "ForceDeleteOnUninstall", "yes");
            this.addAttributeIfNotExists(regkey, "ForceCreateOnInstall", "yes");
            String baseKey = ((Msi)this.task).is64Bit() ? "SOFTWARE\\Wow6432Node\\Apache Software Foundation\\ProcRun 2.0\\" : "SOFTWARE\\Apache Software Foundation\\ProcRun 2.0\\";
            regkey = this.addRegistryKey(component, "HKLM", id + "_RegProcrunParameters", baseKey + name + "\\Parameters");
            this.addRegistryValue(regkey, "LibraryPath", "string", libraryPath);
            regkey = this.addRegistryKey(component, "HKLM", id + "_RegJava", baseKey + name + "\\Parameters\\Java");
            this.addRegistryValue(regkey, "Classpath", "string", service.getMainJar());
            if (this.setup.getBundleJre() != null && (jvm != null || javaHome != null)) {
                throw new IllegalStateException("Combining bundleJre with jvm/javaHome is not allowed");
            }
            if (this.setup.getBundleJre() != null) {
                this.addRegistryValue(regkey, "JavaHome", "string", "[INSTALLDIR]" + this.setup.getBundleJreTarget());
                this.addRegistryValue(regkey, "Jvm", "string", "[INSTALLDIR]" + this.jvmDll);
            }
            if (javaHome != null) {
                this.addRegistryValue(regkey, "JavaHome", "string", javaHome);
            }
            if (jvm != null) {
                this.addRegistryValue(regkey, "Jvm", "string", jvm);
            }
            this.addMultiStringRegistryValue(regkey, "Options", service.getJavaVMArguments());
            regkey = this.addRegistryKey(component, "HKLM", id + "_RegStart", baseKey + name + "\\Parameters\\Start");
            this.addRegistryValue(regkey, "Class", "string", service.getMainClass());
            this.addRegistryValue(regkey, "Mode", "string", "jvm");
            this.addRegistryValue(regkey, "WorkingPath", "string", "[INSTALLDIR]" + subdir);
            this.addMultiStringRegistryValue(regkey, "Params", Arrays.asList(service.getStartArguments().split(" ")).stream().filter(e -> e.length() > 0).collect(Collectors.toList()));
            regkey = this.addRegistryKey(component, "HKLM", id + "_RegLog", baseKey + name + "\\Parameters\\Log");
            this.addRegistryValue(regkey, "Path", "string", logPath);
            this.addRegistryValue(regkey, "Prefix", "string", logPrefix);
            if (logLevel != null) {
                this.addRegistryValue(regkey, "Level", "string", logLevel);
            }
            if (pidFile != null) {
                this.addRegistryValue(regkey, "PidFile", "string", pidFile);
            }
            if (stdOutput != null) {
                this.addRegistryValue(regkey, "StdOutput", "string", stdOutput);
            }
            if (stdError != null) {
                this.addRegistryValue(regkey, "StdError", "string", stdError);
            }
            regkey = this.addRegistryKey(component, "HKLM", id + "_RegStop", baseKey + name + "\\Parameters\\Stop");
            this.addRegistryValue(regkey, "Class", "string", "java.lang.System");
            this.addRegistryValue(regkey, "Mode", "string", "jvm");
            this.addRegistryValue(regkey, "WorkingPath", "string", "[INSTALLDIR]" + subdir);
            if (service.isStartOnBoot()) {
                Element start = this.getOrCreateChildById(component, "ServiceControl", id + "_start");
                this.addAttributeIfNotExists(start, "Name", name);
                this.addAttributeIfNotExists(start, "Start", "install");
                this.addAttributeIfNotExists(start, "Stop", "both");
                this.addAttributeIfNotExists(start, "Remove", "uninstall");
                this.addAttributeIfNotExists(start, "Wait", "yes");
                DesktopStarter run = new DesktopStarter(this.setup);
                run.setExecutable("net");
                run.setStartArguments("start \"" + name + "\"");
                this.addRun(run, id + "Restart", "ignore", null);
                this.addCustomActionToSequence(id + "Restart", true, "InstallFiles", true, "NOT REMOVE");
            }
            String target = name.replace('[', '_').replace(']', '_');
            this.addFile(component, prunmgr, this.segments(id + "GUI\\" + target + ".exe"), true);
            this.renameFileIfDynamic(id, subdir, target + ".exe", name + ".exe");
            this.addDeleteFiles(String.format("%s%s.*.log", subdir, logPrefix));
        }
    }

    private void renameFileIfDynamic(String id, String directory, String sourceName, String targetName) {
        int idx = targetName.indexOf(91);
        if (idx < 0 || targetName.indexOf(93) < idx) {
            return;
        }
        DesktopStarter run = new DesktopStarter(this.setup);
        run.setExecutable("ren");
        run.setStartArguments("\"" + directory + sourceName + "\" \"" + targetName + "\"");
        this.addRun(run, id + "Rename", "ignore", null);
        this.addCustomActionToSequence(id + "Rename", true, "CreateShortcuts", true, null);
        run = new DesktopStarter(this.setup);
        run.setExecutable("del");
        run.setStartArguments("/Q /F \"" + directory + targetName + "\"");
        this.addRun(run, id + "Delete", "ignore", null);
        this.addCustomActionToSequence(id + "Delete", true, "InstallFiles", false, "NOT Installed OR REINSTALL OR REMOVE");
    }

    private Element getShortcutComponent(DesktopStarter starter, Element product) {
        String refDirID;
        Element targetDir = this.getOrCreateChildById(product, "Directory", "TARGETDIR");
        boolean removeOnUninstall = false;
        switch (starter.getLocation()) {
            default: {
                refDirID = "ProgramMenuFolder";
                this.getOrCreateChildById(targetDir, "Directory", refDirID);
                this.getOrCreateChildById(product, "DirectoryRef", refDirID);
                break;
            }
            case ApplicationMenu: {
                refDirID = "ApplicationProgramsFolder";
                Element menuFolders = this.getOrCreateChildById(targetDir, "Directory", "ProgramMenuFolder");
                Element appProgrammsFolder = this.getOrCreateChildById(menuFolders, "Directory", refDirID);
                this.addAttributeIfNotExists(appProgrammsFolder, "Name", this.setup.getApplication());
                removeOnUninstall = true;
                break;
            }
            case InstallDir: {
                refDirID = "INSTALLDIR";
                break;
            }
            case DesktopDir: {
                refDirID = "DesktopFolder";
                Element desktopMenuFolders = this.getOrCreateChildById(targetDir, "Directory", "ProgramMenuFolder");
                Element desktopProgrammsFolder = this.getOrCreateChildById(desktopMenuFolders, "Directory", refDirID);
                this.addAttributeIfNotExists(desktopProgrammsFolder, "Name", "Desktop");
                removeOnUninstall = true;
            }
        }
        Element dirRef = this.getOrCreateChildById(product, "DirectoryRef", refDirID);
        Element component = this.getComponent(dirRef, "shortcuts_" + refDirID);
        if (removeOnUninstall) {
            Element removeFolder = this.getOrCreateChildById(component, "RemoveFolder", "Remove" + refDirID);
            this.addAttributeIfNotExists(removeFolder, "Directory", refDirID);
            this.addAttributeIfNotExists(removeFolder, "On", "uninstall");
        }
        Element reg = this.addRegistryKey(component, "HKCU", "shortcuts_reg_" + refDirID, "Software\\" + this.setup.getVendor() + "\\" + this.setup.getApplication());
        reg = this.addRegistryValue(reg, "shortcut_" + refDirID, "string", "");
        this.addAttributeIfNotExists(reg, "KeyPath", "yes");
        return component;
    }

    private void addShortcutsAndRegisterProtocols() throws IOException {
        for (DesktopStarter desktopStarter : this.setup.getDesktopStarters()) {
            this.addShortcutsImpl(desktopStarter);
        }
        for (DesktopStarter desktopStarter : ((Msi)this.task).getLaunch4js()) {
            CommandLine cmd = new CommandLine(desktopStarter, this.javaDir);
            this.registerFileExtension(desktopStarter, cmd);
            this.registerSchemeDefinition(desktopStarter);
        }
    }

    private void addShortcutsImpl(DesktopStarter starter) throws IOException {
        String linkLocation;
        String iconID;
        Element component = this.getShortcutComponent(starter, this.product);
        String idSource = starter.getExecutable();
        if (idSource == null || idSource.isEmpty()) {
            idSource = (Object)((Object)starter.getLocation()) + "_" + starter.getDisplayName();
        }
        String id = this.id(idSource);
        Element shortcut = this.getOrCreateChildById(component, "Shortcut", id);
        String name = starter.getDisplayName().replace('[', '_').replace(']', '_');
        this.addAttributeIfNotExists(shortcut, "Name", name);
        if (!starter.getDescription().isEmpty()) {
            this.addAttributeIfNotExists(shortcut, "Description", starter.getDescription());
        }
        this.addAttributeIfNotExists(shortcut, "WorkingDirectory", this.getWorkingDirID(starter));
        String target = starter.getExecutable();
        if (starter.getIcons() != null) {
            if (starter.getIcons().equals(this.setup.getIcons())) {
                iconID = ICON_ID;
            } else {
                File iconFile = starter.getIconForType(this.buildDir, "ico");
                iconID = this.id(starter.getDisplayName() + ".ico");
                Element icon = this.getOrCreateChildById(this.product, "Icon", iconID);
                this.addAttributeIfNotExists(icon, "SourceFile", iconFile.getAbsolutePath());
            }
        } else {
            iconID = null;
        }
        if ((target == null || target.isEmpty()) && iconID == null) {
            iconID = ICON_ID;
        }
        CommandLine cmd = new CommandLine(starter, this.javaDir);
        this.addAttributeIfNotExists(shortcut, "Target", cmd.target);
        if (!cmd.arguments.isEmpty()) {
            this.addAttributeIfNotExists(shortcut, "Arguments", cmd.arguments);
        }
        if (iconID != null) {
            this.addAttributeIfNotExists(shortcut, "Icon", iconID);
        }
        switch (starter.getLocation()) {
            default: {
                linkLocation = "[ProgramMenuFolder]";
                break;
            }
            case ApplicationMenu: {
                linkLocation = "[ApplicationProgramsFolder]";
                break;
            }
            case InstallDir: {
                linkLocation = "[INSTALLDIR]";
                break;
            }
            case DesktopDir: {
                linkLocation = "[ApplicationDesktopShortcut]";
            }
        }
        if (starter.getWorkDir() != null) {
            linkLocation = linkLocation + starter.getWorkDir();
        }
        this.renameFileIfDynamic(id, linkLocation, name + ".lnk", starter.getDisplayName() + ".lnk");
        this.registerFileExtension(starter, cmd);
        this.registerSchemeDefinition(starter);
    }

    private void registerFileExtension(DesktopStarter starter, CommandLine cmd) throws IOException {
        if (this.isAddFiles) {
            for (DocumentType docType : starter.getDocumentType()) {
                for (String fileExtension : docType.getFileExtension()) {
                    File iconFile;
                    if (fileExtension.startsWith(".")) {
                        fileExtension = fileExtension.substring(1);
                    }
                    String pID = this.id(this.setup.getAppIdentifier() + "." + fileExtension);
                    Element component = this.getComponent(this.installDir, pID + "_file_extension");
                    this.getOrCreateChild(component, "CreateFolder");
                    Element progID = this.getOrCreateChildById(component, "ProgId", pID);
                    if (!docType.getName().isEmpty()) {
                        this.addAttributeIfNotExists(progID, "Description", docType.getName());
                    }
                    if ((iconFile = starter.getIconForType(this.buildDir, "ico")) != null) {
                        String iconID = this.addFile(iconFile, new String[]{iconFile.getName()});
                        this.addAttributeIfNotExists(progID, "Icon", iconID);
                    }
                    Element extension = this.getOrCreateChildById(progID, "Extension", fileExtension);
                    this.addAttributeIfNotExists(extension, "ContentType", docType.getMimetype());
                    Element verb = this.getOrCreateChildById(extension, "Verb", "open");
                    Element reg = this.addRegistryKey(component, "HKCR", this.id(pID + "\\shell\\open"), pID + "\\shell\\open");
                    this.addRegistryValue(reg, "FriendlyAppName", "string", this.setup.getApplication());
                    String targetFile = cmd.relativTarget;
                    if (targetFile.startsWith("[INSTALLDIR]")) {
                        targetFile = targetFile.substring("[INSTALLDIR]".length());
                    }
                    String[] segments = this.segments(targetFile);
                    this.addAttributeIfNotExists(verb, "TargetFile", this.id(segments, segments.length));
                    String arguments = cmd.arguments;
                    if (!arguments.contains("%1")) {
                        arguments = arguments + " \"%1\"";
                    }
                    this.addAttributeIfNotExists(verb, "Argument", arguments);
                }
            }
        }
    }

    private String getWorkingDirID(DesktopStarter starter) {
        String workDir = starter.getWorkDir();
        if (workDir != null && !workDir.isEmpty()) {
            String[] segments = this.segments(workDir);
            Element dir = this.getDirectory(segments, segments.length);
            return dir.getAttribute("Id");
        }
        return "INSTALLDIR";
    }

    private void addRun(DesktopStarter run, String id, String Return, String execute) {
        String command;
        String dllEntry;
        String targetID;
        CommandLine cmd = new CommandLine(run, this.javaDir);
        Element action = this.getOrCreateChildById(this.product, "CustomAction", id);
        this.addAttributeIfNotExists(action, "Execute", execute == null ? "deferred" : execute);
        this.addAttributeIfNotExists(action, "Impersonate", "no");
        if (Return != null) {
            this.addAttributeIfNotExists(action, "Return", Return);
        }
        if (!"asyncNoWait".equals(Return)) {
            if (cmd.arguments.isEmpty()) {
                targetID = "WixShellExecTarget";
                dllEntry = "WixShellExec";
                command = cmd.full;
            } else {
                targetID = id;
                dllEntry = "CAQuietExec";
                command = "\"[SystemFolder]cmd.exe\" /C \"cd /D \"[INSTALLDIR]" + cmd.workDir + "\" & " + cmd.relativFull + '\"';
            }
        } else {
            this.addAttributeIfNotExists(action, "Directory", this.getWorkingDirID(run));
            this.addAttributeIfNotExists(action, "ExeCommand", '\"' + cmd.target + "\" " + cmd.arguments);
            return;
        }
        Element target = this.getOrCreateChildByKeyValue(this.product, "SetProperty", "Action", id + "_target");
        this.addAttributeIfNotExists(target, "Id", targetID);
        this.addAttributeIfNotExists(target, "Before", id);
        this.addAttributeIfNotExists(target, "Sequence", "execute");
        this.addAttributeIfNotExists(target, "Value", command);
        this.addAttributeIfNotExists(action, "BinaryKey", "WixCA");
        this.addAttributeIfNotExists(action, "DllEntry", dllEntry);
    }

    private void addRunBeforeUninstall() {
        DesktopStarter runBeforeUninstall = this.setup.getRunBeforeUninstall();
        if (runBeforeUninstall == null) {
            return;
        }
        String id = "runBeforeUninstall";
        this.addRun(runBeforeUninstall, id, "ignore", null);
        this.addCustomActionToSequence(id, true, "StopServices", true, "REMOVE=\"ALL\" AND NOT UPGRADINGPRODUCTCODE");
    }

    private void addRunAfter() {
        DesktopStarter runAfter = this.setup.getRunAfter();
        if (runAfter == null) {
            return;
        }
        String id = "runAfter";
        Element ui = this.getOrCreateChild(this.product, "UI");
        Element exitDialog = this.getOrCreateChildByKeyValue(ui, "Publish", "Dialog", "ExitDialog");
        this.addAttributeIfNotExists(exitDialog, "Control", "Finish");
        this.addAttributeIfNotExists(exitDialog, "Event", "DoAction");
        this.addAttributeIfNotExists(exitDialog, "Value", id);
        Element optionalExitText = this.getOrCreateChildByKeyValue(this.product, "CustomAction", "Id", "CA_Set_WIXUI_EXITDIALOGOPTIONALTEXT");
        this.addAttributeIfNotExists(optionalExitText, "Property", "WIXUI_EXITDIALOGOPTIONALTEXT");
        this.addAttributeIfNotExists(optionalExitText, "Value", "!(loc.OptionalExitText)");
        Element optionalExitTextSequence = this.getOrCreateChild(this.product, "InstallUISequence");
        Element optionalExitTextAction = this.getOrCreateChildByKeyValue(optionalExitTextSequence, "Custom", "Action", "CA_Set_WIXUI_EXITDIALOGOPTIONALTEXT");
        this.addAttributeIfNotExists(optionalExitTextAction, "After", "FindRelatedProducts");
        optionalExitTextAction.setTextContent("NOT Installed");
        if (((Msi)this.task).isRunAfterOptional()) {
            exitDialog.setTextContent("WIXUI_EXITDIALOGOPTIONALCHECKBOX = 1 and NOT Installed");
            Element optionalEnabled = this.getOrCreateChildByKeyValue(this.product, "Property", "Id", "WIXUI_EXITDIALOGOPTIONALCHECKBOX");
            this.addAttributeIfNotExists(optionalEnabled, "Value", "1");
            Element optional = this.getOrCreateChildByKeyValue(this.product, "CustomAction", "Id", "CA_Set_WIXUI_EXITDIALOGOPTIONALCHECKBOXTEXT");
            this.addAttributeIfNotExists(optional, "Property", "WIXUI_EXITDIALOGOPTIONALCHECKBOXTEXT");
            this.addAttributeIfNotExists(optional, "Value", "!(loc.OptionalRunAfterText)");
            Element sequence = this.getOrCreateChild(this.product, "InstallUISequence");
            Element action = this.getOrCreateChildByKeyValue(sequence, "Custom", "Action", "CA_Set_WIXUI_EXITDIALOGOPTIONALCHECKBOXTEXT");
            this.addAttributeIfNotExists(action, "After", "FindRelatedProducts");
            action.setTextContent("NOT Installed");
        } else {
            exitDialog.setTextContent("NOT Installed OR REINSTALL OR UPGRADINGPRODUCTCODE");
        }
        this.addRun(runAfter, id, "asyncNoWait", "immediate");
    }

    private Element addCustomActionToSequence(String id, boolean execute, String sequenceAction, boolean after, String condition) {
        Element executeSequence = this.getOrCreateChild(this.product, execute ? "InstallExecuteSequence" : "InstallUISequence");
        Element custom = this.getOrCreateChildByKeyValue(executeSequence, "Custom", "Action", id);
        this.addAttributeIfNotExists(custom, after ? "After" : "Before", sequenceAction);
        if (condition != null) {
            custom.setTextContent(condition);
        }
        return custom;
    }

    private void addDeleteFiles() {
        for (String pattern : this.setup.getDeleteFiles()) {
            this.addDeleteFiles(pattern);
        }
        for (String folder : this.setup.getDeleteFolders()) {
            folder = folder.replace('/', '\\');
            String id = this.id("rmdir_" + folder);
            if (folder.endsWith("\\")) {
                folder = folder.substring(0, folder.length() - 1);
            }
            DesktopStarter run = new DesktopStarter(this.setup);
            run.setExecutable("rmdir");
            run.setStartArguments("/S /Q \"[INSTALLDIR]" + folder + '\"');
            this.addRun(run, id, "ignore", null);
            this.addCustomActionToSequence(id, true, "RemoveFolders", true, "NOT Installed OR REMOVE=\"ALL\" OR REINSTALL=\"ALL\" OR UPGRADINGPRODUCTCODE");
        }
    }

    private Element addDeleteFiles(String pattern) {
        String[] segments = this.segments(pattern);
        Element dir = this.getDirectory(segments);
        String id = this.id(pattern);
        Element component = this.getComponent(dir, "deleteFiles" + id);
        Element remove = this.getOrCreateChildById(component, "RemoveFile", "removeFile" + id);
        this.addAttributeIfNotExists(remove, "On", "both");
        this.addAttributeIfNotExists(remove, "Name", segments[segments.length - 1]);
        return component;
    }

    private Element addRegistryKey(Element component, String root, String id, String key) {
        Element regkey = this.getOrCreateChildById(component, "RegistryKey", id);
        this.addAttributeIfNotExists(regkey, "Root", root);
        this.addAttributeIfNotExists(regkey, "Key", key);
        this.addAttributeIfNotExists(regkey, "ForceDeleteOnUninstall", "yes");
        return regkey;
    }

    private Element addRegistryValue(Element regkey, String name, String type, String value) {
        Element regValue = this.getOrCreateChildByKeyValue(regkey, "RegistryValue", "Name", name);
        this.addAttributeIfNotExists(regValue, "Type", type);
        this.addAttributeIfNotExists(regValue, "Value", value);
        return regValue;
    }

    private Element addMultiStringRegistryValue(Element regkey, String name, List<String> values) {
        if (values.isEmpty()) {
            return null;
        }
        Element regValue = this.getOrCreateChildByKeyValue(regkey, "RegistryValue", "Name", name);
        this.addAttributeIfNotExists(regValue, "Type", "multiString");
        for (String value : values) {
            this.getOrCreateChild(regValue, "MultiStringValue", value, true);
        }
        return regValue;
    }

    String[] segments(String path) {
        if ((path = path.trim()).length() > 1 && path.charAt(0) == '/' || path.charAt(0) == '\\') {
            path = path.substring(1);
        }
        return path.split("[/\\\\]");
    }

    private String id(String[] segments, int length) {
        if (length <= 0) {
            return "";
        }
        if (length == 1) {
            return this.id(segments[0]);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append('\\');
            }
            builder.append(segments[i]);
        }
        return this.id(builder.toString());
    }

    private String id(String str) {
        String id;
        StringBuilder builder = null;
        boolean needUnderscoreStart = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_') continue;
            if (ch >= '0' && ch <= '9' || ch == '.') {
                if (i > 0) continue;
                needUnderscoreStart = true;
                builder = new StringBuilder();
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(str.substring(builder.length(), i));
            builder.append('_');
        }
        if (builder == null) {
            if (str.length() <= 72) {
                if (!this.ids.containsKey(str)) {
                    this.ids.put(str, str);
                    return str;
                }
                if (str.equals(this.ids.get(str))) {
                    return str;
                }
            }
            builder = new StringBuilder();
        }
        builder.append(str.substring(builder.length()));
        if (builder.length() > 62) {
            builder.delete(0, builder.length() - 62);
            char ch = builder.charAt(0);
            boolean bl = needUnderscoreStart = ch >= '0' && ch <= '9' || ch == '.';
        }
        if (needUnderscoreStart) {
            builder.insert(0, '_');
        }
        if (!this.ids.containsKey(id = builder.toString())) {
            this.ids.put(id, str);
            return id;
        }
        if (str.equals(this.ids.get(id))) {
            return id;
        }
        builder.append('_');
        builder.append(Integer.toHexString(str.hashCode()));
        return builder.toString();
    }

    private String getGuid(String id) {
        return UUID.nameUUIDFromBytes((this.setup.getVendor() + this.setup.getApplication() + id).getBytes()).toString();
    }

    private void addMultiInstanceTransforms() throws IOException {
        Object upgrade;
        int instanceCount = ((Msi)this.task).getMultiInstanceCount();
        if (instanceCount <= 1) {
            return;
        }
        Element property = this.getOrCreateChildById(this.product, "Property", "INSTANCE_ID");
        this.addAttributeIfNotExists(property, "Value", "NotSet");
        property = this.getOrCreateChildById(this.product, "Property", "InstancesCount");
        this.addAttributeIfNotExists(property, "Value", Integer.toString(instanceCount));
        Element transforms = this.getOrCreateChildByKeyValue(this.product, "InstanceTransforms", "Property", "INSTANCE_ID");
        for (int i = 0; i < instanceCount; ++i) {
            String id = "Instance_" + i;
            String guid = this.getGuid(id);
            Element instance = this.getOrCreateChildById(transforms, "Instance", id);
            this.addAttributeIfNotExists(instance, "ProductCode", "*");
            this.addAttributeIfNotExists(instance, "UpgradeCode", guid);
            upgrade = this.getOrCreateChildById(this.product, "Upgrade", guid);
            Element upgradeVersion = this.getOrCreateChildByKeyValue((Node)upgrade, "UpgradeVersion", "Property", "WIX_UPGRADE_DETECTED_" + i);
            this.addAttributeIfNotExists(upgradeVersion, "Minimum", "0.0.0.0");
            this.addAttributeIfNotExists(upgradeVersion, "MigrateFeatures", "yes");
        }
        Element executeSequence = this.getOrCreateChild(this.product, "InstallExecuteSequence");
        Element removeExistingProducts = this.getOrCreateChild(executeSequence, "RemoveExistingProducts");
        this.addAttributeIfNotExists(removeExistingProducts, "After", "InstallValidate");
        Element action = this.getOrCreateChildById(this.product, "CustomAction", "SetInstanceID");
        this.addAttributeIfNotExists(action, "Script", "vbscript");
        Scanner scanner = new Scanner(((Msi)this.task).getMultiInstanceScript().openStream(), "UTF8");
        upgrade = null;
        try {
            String vbscript = scanner.useDelimiter("\\A").next();
            vbscript = vbscript.replace("\r\n", "\n");
            action.setTextContent(vbscript);
        }
        catch (Throwable throwable) {
            upgrade = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (upgrade != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)upgrade).addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        this.addCustomActionToSequence("SetInstanceID", false, "ExecuteAction", false, null);
        this.addCustomActionToSequence("SetInstanceID", true, "ValidateProductID", false, null);
        action = this.getOrCreateChildById(this.product, "CustomAction", "SetTransforms");
        this.addAttributeIfNotExists(action, "Property", "TRANSFORMS");
        this.addAttributeIfNotExists(action, "Value", ":[INSTANCE_ID]");
        this.addCustomActionToSequence("SetTransforms", false, "SetInstanceID", true, "ACTION = \"INSTALL\"");
        action = this.getOrCreateChildById(this.product, "CustomAction", "SetProductName");
        this.addAttributeIfNotExists(action, "Property", "ProductName");
        this.addAttributeIfNotExists(action, "Value", "[PRODUCT_NAME]");
        this.addCustomActionToSequence("SetProductName", true, "SetInstanceID", true, "PRODUCT_NAME");
        Element component = this.getComponent(this.installDir, "instance_path");
        Element key = this.addRegistryKey(component, "HKLM", "instance_path_reg", "Software\\" + this.setup.getVendor() + "\\" + this.setup.getApplication() + "\\Instances\\[INSTANCE_NUMBER]");
        this.addRegistryValue(key, null, "string", "[INSTALLDIR]");
        this.addRegistryValue(key, "PackageCode", "string", "[PackageCode]");
    }

    private void addPreAndPostScripts() throws IOException {
        this.addPreAndPostScripts("PreGUI_Script", ((Msi)this.task).getPreGUI(), false, "PrepareDlg", false, "NOT Installed OR REINSTALL OR UPGRADINGPRODUCTCODE");
        this.addPreAndPostScripts("Preinst_Script", ((Msi)this.task).getPreinst(), true, "InstallInitialize", true, "NOT Installed OR REINSTALL OR UPGRADINGPRODUCTCODE");
        this.addPreAndPostScripts("Postinst_Script", ((Msi)this.task).getPostinst(), true, "InstallFinalize", false, "NOT Installed OR REINSTALL OR UPGRADINGPRODUCTCODE");
        this.addPreAndPostScripts("Prerm_Script", ((Msi)this.task).getPrerm(), true, "InstallInitialize", true, "REMOVE");
        this.addPreAndPostScripts("Postrm_Script", ((Msi)this.task).getPostrm(), true, "InstallFinalize", false, "REMOVE");
    }

    private void addPreAndPostScripts(String actionId, List<String> scripts, boolean execute, String sequenceAction, boolean after, String condition) throws IOException {
        if (scripts == null || scripts.isEmpty()) {
            return;
        }
        for (int i = 0; i < scripts.size(); ++i) {
            String script = scripts.get(i);
            this.addPreAndPostScripts(actionId + i, script, execute, sequenceAction, after, condition);
        }
    }

    private void addPreAndPostScripts(String actionId, String script, boolean execute, String sequenceAction, boolean after, String condition) throws IOException {
        if (script == null || script.trim().isEmpty()) {
            return;
        }
        Element action = this.getOrCreateChildById(this.product, "CustomAction", actionId);
        this.addAttributeIfNotExists(action, "Script", WxsFileBuilder.getScriptLanguage(script));
        script = script.replace("\r\n", "\n");
        action.setTextContent(script);
        this.addCustomActionToSequence(actionId, execute, sequenceAction, after, condition);
        if (execute) {
            this.addAttributeIfNotExists(action, "Execute", "deferred");
            this.addAttributeIfNotExists(action, "Impersonate", "no");
            action = this.getOrCreateChildById(this.product, "CustomAction", "SetProperties" + actionId);
            this.addAttributeIfNotExists(action, "Property", actionId);
            this.addAttributeIfNotExists(action, "Value", "INSTALLDIR='[INSTALLDIR]';ProductCode='[ProductCode]';INSTANCE_ID='[INSTANCE_ID]'");
            this.addCustomActionToSequence("SetProperties" + actionId, execute, actionId, false, null);
        }
    }

    private static String getScriptLanguage(String script) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(script));
        do {
            if ((line = reader.readLine()) != null) continue;
            return "vbscript";
        } while (!line.trim().endsWith(";"));
        return "jscript";
    }
}

