/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.msi.MsiLanguages;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.gradle.util.ConfigureUtil;

public class MsiLocalizedResource {
    private MsiLanguages locale;
    private Object resource;
    private SetupBuilder setup;
    private boolean overridable;
    private File temporaryDirectory;

    public MsiLocalizedResource(SetupBuilder setup, File temporaryDirectory) {
        this.setup = setup;
        this.temporaryDirectory = temporaryDirectory;
    }

    public File getResource() {
        if (this.resource == null) {
            return null;
        }
        File input = !(this.resource instanceof File) ? this.setup.getProject().file(this.resource) : (File)this.resource;
        try {
            boolean overridable;
            File wxlFile = new File(this.temporaryDirectory, "i18n-" + input.getName() + "." + UUID.randomUUID().toString() + ".wxl");
            if (wxlFile.exists()) {
                return wxlFile;
            }
            wxlFile.getParentFile().mkdirs();
            Properties props = new Properties();
            try (InputStream stream = Files.newInputStream(input.toPath(), new OpenOption[0]);){
                props.load(stream);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("<?xml version='1.0'?>\n");
            builder.append("<WixLocalization xmlns='http://schemas.microsoft.com/wix/2006/localization' Codepage='utf-8' ");
            boolean isDefaultLanguage = this.locale.getLangID().equalsIgnoreCase(MsiLanguages.getMsiLanguage(this.setup.getDefaultResourceLanguage()).getLangID());
            boolean bl = overridable = isDefaultLanguage || this.overridable;
            if (!isDefaultLanguage) {
                builder.append("Culture='" + this.locale.getCulture() + "'");
            }
            builder.append(">\n");
            for (Object key : props.keySet()) {
                String value = props.getProperty((String)key);
                builder.append("\t<String Id='");
                builder.append(key);
                if (overridable) {
                    builder.append("' Overridable='yes");
                }
                builder.append("'>");
                builder.append(value);
                builder.append("</String>\n");
            }
            builder.append("</WixLocalization>");
            Files.write(wxlFile.toPath(), builder.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            return wxlFile;
        }
        catch (IOException e) {
            return null;
        }
    }

    public MsiLanguages getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = MsiLanguages.getMsiLanguage(locale);
    }

    public void setResource(Object resource) {
        this.resource = resource;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean overrideable) {
        this.overridable = overrideable;
    }

    public static File getLocalizedResourceFile(List<MsiLocalizedResource> list, String locale) {
        for (MsiLocalizedResource res : list) {
            if (!res.locale.getLangID().equalsIgnoreCase(locale)) continue;
            return res.getResource();
        }
        return null;
    }

    public static void addLocalizedResource(SetupBuilder parent, File temporaryDirectory, List<MsiLocalizedResource> holder, Object resource) {
        MsiLocalizedResource res = new MsiLocalizedResource(parent, temporaryDirectory);
        if (resource instanceof Closure) {
            res = (MsiLocalizedResource)ConfigureUtil.configure((Closure)((Closure)resource), (Object)res);
        } else {
            res.setLocale(parent.getDefaultResourceLanguage());
            res.setResource(resource);
        }
        holder.add(res);
    }

    public static File localizedRtfFile(File temporaryDirectory, MsiLanguages lang) {
        return new File(temporaryDirectory, "i18n/license-" + lang.getCulture().replaceAll("[^a-zA-Z0-9]", "_") + ".rtf");
    }
}

