/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.AbstractBuilder;
import com.inet.gradle.setup.msi.Launch4j;
import com.inet.gradle.setup.msi.Launch4jCreator;
import com.inet.gradle.setup.msi.Msi;
import com.inet.gradle.setup.msi.MsiLanguages;
import com.inet.gradle.setup.msi.MsiLocalizedResource;
import com.inet.gradle.setup.msi.SignTool;
import com.inet.gradle.setup.msi.WxsFileBuilder;
import com.inet.gradle.setup.util.ResourceUtils;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.FileResolver;

class MsiBuilder
extends AbstractBuilder<Msi, SetupBuilder> {
    private SetupBuilder setup;

    MsiBuilder(Msi msi, SetupBuilder setup, FileResolver fileResolver) {
        super(msi, fileResolver);
        this.setup = setup;
    }

    void build() {
        try {
            File wxsFile = this.getWxsFile();
            URL template = ((Msi)this.task).getWxsTemplate();
            new WxsFileBuilder((Msi)this.task, this.setup, wxsFile, this.buildDir, template, false).build();
            template = wxsFile.toURI().toURL();
            this.buildLauch4j();
            this.candle();
            ResourceUtils.extract(this.getClass(), "sdk/MsiTran.exe", this.buildDir);
            ResourceUtils.extract(this.getClass(), "sdk/wilangid.vbs", this.buildDir);
            ResourceUtils.extract(this.getClass(), "sdk/wisubstg.vbs", this.buildDir);
            List<MsiLanguages> languages = ((Msi)this.task).getLanguages();
            String[] languageResources = this.getLanguageResources();
            File mui = this.light(languages.get(0), languageResources);
            HashMap<MsiLanguages, File> translations = new HashMap<MsiLanguages, File>();
            for (int i = 1; i < languages.size(); ++i) {
                MsiLanguages language = languages.get(i);
                File file = this.light(language, languageResources);
                this.patchLangID(file, language);
                File mst = this.msitran(mui, file, language);
                translations.put(language, mst);
            }
            new WxsFileBuilder((Msi)this.task, this.setup, wxsFile, this.buildDir, template, true).build();
            this.candle();
            mui = this.light(languages.get(0), languageResources);
            StringBuilder langIDs = new StringBuilder(languages.get(0).getLangID());
            for (Map.Entry entry : translations.entrySet()) {
                MsiLanguages language = (MsiLanguages)((Object)entry.getKey());
                File mst = (File)entry.getValue();
                this.addTranslation(mui, mst, language);
                langIDs.append(',').append(language.getLangID());
            }
            this.patchLangID(mui, langIDs.toString());
            this.signTool(mui);
            Files.move(mui.toPath(), ((Msi)this.task).getSetupFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String[] getLanguageResources() {
        List<MsiLocalizedResource> i18n = ((Msi)this.task).getI18n();
        ArrayList<String> i18nFiles = new ArrayList<String>();
        for (MsiLocalizedResource msiLocalizedResource : i18n) {
            File result = msiLocalizedResource.getResource();
            if (result == null) continue;
            i18nFiles.add(result.getAbsolutePath());
        }
        return i18nFiles.toArray(new String[i18nFiles.size()]);
    }

    private void buildLauch4j() throws Exception {
        if (((Msi)this.task).getLaunch4js().size() > 0) {
            Launch4jCreator creator = new Launch4jCreator();
            for (Launch4j launch : ((Msi)this.task).getLaunch4js()) {
                File file = creator.create(launch, (Msi)this.task, this.setup);
                this.signTool(file);
                CopySpec copySpec = ((Msi)this.task).getProject().copySpec((Closure)null);
                ((Msi)this.task).with(new CopySpec[]{copySpec});
                copySpec.from(new Object[]{file});
                String workDir = launch.getWorkDir();
                if (workDir == null || workDir.isEmpty()) continue;
                copySpec.into((Object)workDir);
            }
            creator.close();
        }
    }

    private void callWixTool(String tool, ArrayList<String> parameters) {
        parameters.add(0, MsiBuilder.getToolPath(tool));
        this.exec(parameters);
    }

    private void candle() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-nologo");
        parameters.add("-arch");
        parameters.add(((Msi)this.task).getArch());
        parameters.add("-out");
        parameters.add(this.buildDir.getAbsolutePath() + '\\');
        parameters.add(this.getWxsFile().getAbsolutePath());
        for (File external : ((Msi)this.task).getExternals()) {
            parameters.add(external.getAbsolutePath());
        }
        parameters.add("-ext");
        parameters.add("WixUtilExtension");
        this.callWixTool("candle.exe", parameters);
    }

    private File light(MsiLanguages language, String[] languageResources) {
        File localizedRtfFile;
        File out = new File(this.buildDir, this.setup.getArchiveName() + '_' + language.getCulture() + ".msi");
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-nologo");
        parameters.add("-sice:ICE60");
        parameters.add("-ext");
        parameters.add("WixUIExtension");
        parameters.add("-ext");
        parameters.add("WixUtilExtension");
        parameters.add("-out");
        parameters.add(out.getAbsolutePath());
        parameters.add("-spdb");
        parameters.add("-cultures:" + language.getCulture() + ";neutral");
        if (languageResources != null) {
            for (String location : languageResources) {
                parameters.add("-loc");
                parameters.add(location);
            }
        }
        if ((localizedRtfFile = MsiLocalizedResource.localizedRtfFile(((Msi)this.task).getTemporaryDir(), language)).exists()) {
            parameters.add("-dWixUILicenseRtf=\"" + localizedRtfFile.getAbsolutePath() + "\"");
        }
        parameters.add("*.wixobj");
        this.callWixTool("light.exe", parameters);
        return out;
    }

    private void patchLangID(File file, MsiLanguages language) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("cscript");
        parameters.add("//Nologo");
        parameters.add(new File(this.buildDir, "sdk/wilangid.vbs").getAbsolutePath());
        parameters.add(file.getAbsolutePath());
        parameters.add("Product");
        parameters.add(language.getLangID());
        this.exec(parameters);
    }

    private void patchLangID(File mui, String langIDs) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("cscript");
        parameters.add("//Nologo");
        parameters.add(new File(this.buildDir, "sdk/wilangid.vbs").getAbsolutePath());
        parameters.add(mui.getAbsolutePath());
        parameters.add("Package");
        parameters.add(langIDs);
        this.exec(parameters);
    }

    private File msitran(File mui, File file, MsiLanguages language) {
        File mst = new File(this.buildDir, language.getCulture() + ".mst");
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(new File(this.buildDir, "sdk/MsiTran.exe").getAbsolutePath());
        parameters.add("-g");
        parameters.add(mui.getAbsolutePath());
        parameters.add(file.getAbsolutePath());
        parameters.add(mst.getAbsolutePath());
        this.exec(parameters);
        file.delete();
        return mst;
    }

    private void addTranslation(File mui, File mst, MsiLanguages language) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("cscript");
        parameters.add("//Nologo");
        parameters.add(new File(this.buildDir, "sdk/wisubstg.vbs").getAbsolutePath());
        parameters.add(mui.getAbsolutePath());
        parameters.add(mst.getAbsolutePath());
        parameters.add(language.getLangID());
        this.exec(parameters);
        mst.delete();
    }

    private void signTool(File file) throws IOException {
        SignTool sign = ((Msi)this.task).getSignTool();
        if (sign == null) {
            return;
        }
        String tool = ResourceUtils.extract(this.getClass(), "sdk/signtool.exe", this.buildDir).getAbsolutePath();
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(tool);
        parameters.add("sign");
        if (sign.getCertificate() != null) {
            parameters.add("/f");
            parameters.add(((Msi)this.task).getProject().file(sign.getCertificate()).getAbsolutePath());
        }
        if (sign.getPassword() != null) {
            parameters.add("/p");
            parameters.add(sign.getPassword());
        }
        if (sign.getSha1() != null) {
            parameters.add("/sha1");
            parameters.add(sign.getSha1());
        }
        parameters.add("/d");
        parameters.add(this.setup.getApplication());
        parameters.add(file.getAbsolutePath());
        this.exec(parameters);
        List<String> servers = sign.getTimestamp();
        if (servers != null) {
            RuntimeException allEx = null;
            for (String server : servers) {
                parameters = new ArrayList();
                parameters.add(tool);
                parameters.add("timestamp");
                parameters.add("/t");
                parameters.add(server);
                parameters.add(file.getAbsolutePath());
                try {
                    this.exec(parameters);
                    allEx = null;
                    break;
                }
                catch (RuntimeException ex) {
                    if (allEx == null) {
                        allEx = ex;
                    } else {
                        allEx.addSuppressed(ex);
                    }
                    ((Msi)this.task).getProject().getLogger().lifecycle("Timestamp failed: " + ex);
                }
            }
            if (allEx != null) {
                throw allEx;
            }
        }
    }

    private File getWxsFile() {
        return new File(this.buildDir, this.setup.getArchiveName() + ".wxs");
    }

    private static String getToolPath(String tool) {
        String[] programs;
        String programFilesStr;
        String wix = System.getenv("WIX");
        if (wix == null) {
            wix = System.getProperty("WIX");
        }
        if (wix != null) {
            File file = new File(wix);
            if ((file = new File(file, "bin\\" + tool)).exists()) {
                return file.getAbsolutePath();
            }
        }
        if ((programFilesStr = System.getenv("ProgramFiles(x86)")) == null) {
            programFilesStr = System.getenv("ProgramW6432");
        }
        if (programFilesStr == null) {
            throw new GradleException("Environment variable ProgramFiles not found.");
        }
        File programFiles = new File(programFilesStr);
        for (String program : programs = programFiles.list()) {
            File file;
            if (!program.toLowerCase().startsWith("wix toolset") || !(file = new File(programFiles, program + "\\bin\\" + tool)).exists()) continue;
            return file.getAbsolutePath();
        }
        for (String program : programs) {
            String[] wixEditFiles;
            if (!program.equalsIgnoreCase("WixEdit")) continue;
            File wixEdit = new File(programFiles, program);
            for (String wixEditFile : wixEditFiles = wixEdit.list()) {
                File file;
                if (!wixEditFile.toLowerCase().startsWith("wix") || !(file = new File(wixEdit, wixEditFile + "\\" + tool)).exists()) continue;
                return file.getAbsolutePath();
            }
        }
        throw new GradleException(tool + " was not found. You need to install the WiX Toolset or set the environment variable WIX. You can download the WiX Toolset from http://wixtoolset.org/");
    }
}

