/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.msi.Launch4j;
import com.inet.gradle.setup.msi.Launch4jConfig;
import com.inet.gradle.setup.msi.Msi;
import com.inet.gradle.setup.util.XmlFileBuilder;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Element;

class Launch4jManifest
extends XmlFileBuilder<Msi> {
    private Launch4j launch;

    Launch4jManifest(Launch4j launch, Msi task, SetupBuilder setup) throws Exception {
        super(task, setup, File.createTempFile("launch4j", ".manifest", task.getTemporaryDir()), task.getTemporaryDir(), null);
        this.launch = launch;
    }

    void build() throws IOException {
        Element assembly = this.getOrCreateChild(this.doc, "assembly");
        assembly.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:schemas-microsoft-com:asm.v1");
        this.addAttributeIfNotExists(assembly, "manifestVersion", "1.0");
        Element identity = this.getOrCreateChild(assembly, "assemblyIdentity");
        this.addAttributeIfNotExists(identity, "version", Launch4jConfig.normalizeVersionNumber(((Msi)this.task).getVersion()));
        this.addAttributeIfNotExists(identity, "processorArchitecture", "X86");
        this.addAttributeIfNotExists(identity, "name", this.launch.getDisplayName());
        this.addAttributeIfNotExists(identity, "type", "win32");
        Element compatibility = this.getOrCreateChild(assembly, "compatibility");
        compatibility.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:schemas-microsoft-com:compatibility.v1");
        Element application = this.getOrCreateChild(compatibility, "application");
        this.getOrCreateChildById(application, "supportedOS", "{e2011457-1546-43c5-a5fe-008deee3d3f0}");
        this.getOrCreateChildById(application, "supportedOS", "{35138b9a-5d96-4fbd-8e2d-a2440225f93a}");
        this.getOrCreateChildById(application, "supportedOS", "{4a2f28e3-53b9-4441-ba9c-d69d4a4a6e38}");
        this.getOrCreateChildById(application, "supportedOS", "{1f676c76-80e1-4239-95bb-83d0f6d0da78}");
        this.getOrCreateChildById(application, "supportedOS", "{8e0f7a12-bfb3-4fe8-b9a5-48fd50a15a9a}");
        this.getOrCreateChild(assembly, "description").setTextContent(this.launch.getDescription());
        Element trustInfo = this.getOrCreateChild(assembly, "trustInfo");
        trustInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:schemas-microsoft-com:asm.v2");
        String level = this.launch.getRequestedExecutionLevel();
        if (level != null && !level.isEmpty()) {
            Element security = this.getOrCreateChild(trustInfo, "security");
            Element requestedPrivileges = this.getOrCreateChild(security, "requestedPrivileges");
            Element requestedExecutionLevel = this.getOrCreateChildByKeyValue(requestedPrivileges, "requestedExecutionLevel", "level", level);
            this.addAttributeIfNotExists(requestedExecutionLevel, "uiAccess", "false");
        }
    }
}

