/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.image.image4j.io;

public class EndianUtils {
    public static short swapShort(short value) {
        return (short)((value & 0xFF00) >> 8 | (value & 0xFF) << 8);
    }

    public static int swapInteger(int value) {
        return (value & 0xFF000000) >> 24 | (value & 0xFF0000) >> 8 | (value & 0xFF00) << 8 | (value & 0xFF) << 24;
    }

    public static long swapLong(long value) {
        return (value & 0xFF00000000000000L) >> 56 | (value & 0xFF000000000000L) >> 40 | (value & 0xFF0000000000L) >> 24 | (value & 0xFF00000000L) >> 8 | (value & 0xFF000000L) << 8 | (value & 0xFF0000L) << 24 | (value & 0xFF00L) << 40 | (value & 0xFFL) << 56;
    }

    public static float swapFloat(float value) {
        int i = Float.floatToIntBits(value);
        i = EndianUtils.swapInteger(i);
        return Float.intBitsToFloat(i);
    }

    public static double swapDouble(double value) {
        long l = Double.doubleToLongBits(value);
        l = EndianUtils.swapLong(l);
        return Double.longBitsToDouble(l);
    }
}

