/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.image.icns;

import java.awt.image.BufferedImage;

public class IconSuite {
    private static final int SMALL_INDEX = 0;
    private static final int LARGE_INDEX = 1;
    private static final int HUGE_INDEX = 2;
    private static final int THUMBNAIL_INDEX = 3;
    private BufferedImage[] icons = new BufferedImage[4];

    public BufferedImage getBestMatchingIcon(int width, int height) {
        int bestMatch = -1;
        int bestWidth = -1;
        int bestHeight = -1;
        for (int i = 0; i < this.icons.length; ++i) {
            BufferedImage icon = this.icons[i];
            if (icon == null) continue;
            int iconWidth = icon.getWidth();
            int iconHeight = icon.getHeight();
            if (iconWidth == width && iconHeight == height) {
                bestMatch = i;
                break;
            }
            if (bestMatch != -1 && (iconWidth < width || iconHeight < height || bestWidth >= width || bestHeight >= height)) continue;
            bestMatch = i;
            bestWidth = iconWidth;
            bestHeight = iconHeight;
        }
        if (bestMatch != -1) {
            return this.icons[bestMatch];
        }
        return null;
    }

    public BufferedImage getThumbnailIcon() {
        return this.icons[3];
    }

    public void setThumbnailIcon(BufferedImage thumbnailIcon) {
        this.verifyIcon(thumbnailIcon, 128);
        this.icons[3] = thumbnailIcon;
    }

    public BufferedImage getHugeIcon() {
        return this.icons[2];
    }

    public void setHugeIcon(BufferedImage hugeIcon) {
        this.verifyIcon(hugeIcon, 48);
        this.icons[2] = hugeIcon;
    }

    public BufferedImage getLargeIcon() {
        return this.icons[1];
    }

    public void setLargeIcon(BufferedImage largeIcon) {
        this.verifyIcon(largeIcon, 32);
        this.icons[1] = largeIcon;
    }

    public BufferedImage getSmallIcon() {
        return this.icons[0];
    }

    public void setSmallIcon(BufferedImage smallIcon) {
        this.verifyIcon(smallIcon, 16);
        this.icons[0] = smallIcon;
    }

    private void verifyIcon(BufferedImage icon, int size) {
        if (icon != null && (icon.getWidth() != size || icon.getHeight() != size)) {
            throw new IllegalArgumentException("Incorrect icon size [actual:" + icon.getWidth() + "x" + icon.getHeight() + ",expected:" + size + "x" + size + "]");
        }
    }
}

