/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.dmg;

import com.inet.gradle.setup.Template;
import com.inet.gradle.setup.abstracts.Application;
import com.inet.gradle.setup.abstracts.Service;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;

public class OSXScriptBuilder
extends Template {
    private ArrayList<OSXScriptBuilder> scripts = new ArrayList();

    public OSXScriptBuilder(String template) throws IOException {
        super(template);
    }

    public OSXScriptBuilder(ArrayList<String> script) {
        super(script);
    }

    public OSXScriptBuilder(Application application, String template) throws IOException {
        super(template);
        this.setPlaceholder("executable", application.getExecutable());
        this.setPlaceholder("displayName", application.getDisplayName());
        this.setPlaceholder("mainClass", application.getMainClass());
        this.setPlaceholder("mainJar", application.getMainJar());
        this.setPlaceholder("workingDir", application.getWorkDir());
    }

    public OSXScriptBuilder(Service service, String template) throws IOException {
        this((Application)service, template);
        this.setPlaceholder("serviceName", service.getId());
    }

    public void addScript(OSXScriptBuilder script) {
        this.scripts.add(script);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (OSXScriptBuilder osxScriptBuilder : this.scripts) {
            if (osxScriptBuilder == null) continue;
            sb.append(osxScriptBuilder.toString());
        }
        this.setPlaceholder("script", sb.toString());
        return super.toString();
    }

    @Override
    public void writeTo(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(this.toString());
        }
        super.writeTo(file);
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(file.toPath(), perms);
    }

    @Override
    public OSXScriptBuilder setPlaceholder(String placeholder, String content) {
        super.setPlaceholder(placeholder, content);
        return this;
    }
}

