/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.dmg;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.Template;
import com.inet.gradle.setup.abstracts.AbstractBuilder;
import com.inet.gradle.setup.abstracts.AbstractSetupTask;
import com.inet.gradle.setup.abstracts.DesktopStarter;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.dmg.Dmg;
import com.inet.gradle.setup.dmg.OSXApplicationBuilder;
import com.inet.gradle.setup.dmg.OSXScriptBuilder;
import com.inet.gradle.setup.image.ImageFactory;
import com.inet.gradle.setup.util.Logging;
import com.inet.gradle.setup.util.TempPath;
import com.inet.gradle.setup.util.XmlFileBuilder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.gradle.api.internal.file.FileResolver;
import org.w3c.dom.Element;

public class DmgBuilder
extends AbstractBuilder<Dmg, SetupBuilder> {
    private String imageSourceRoot;
    private String firstExecutableName;
    private SetupBuilder setup;
    private TempPath tempPath;

    public DmgBuilder(Dmg dmg, SetupBuilder setup, FileResolver fileResolver) {
        super(dmg, fileResolver);
        this.setup = setup;
    }

    public void build() throws RuntimeException {
        this.tempPath = new TempPath(new File(this.setup.getProject().getBuildDir(), "tmp/SetupBuilder").toPath());
        try {
            if (this.setup.getServices().isEmpty() && this.setup.getDesktopStarters().isEmpty()) {
                throw new IllegalArgumentException("No Services or DesktopStarters have been defined. Will stop now.");
            }
            for (OSXApplicationBuilder builder : ((Dmg)this.task).appBuilders) {
                builder.buildService();
                if (this.firstExecutableName != null) continue;
                this.firstExecutableName = builder.getService().getDisplayName();
            }
            for (DesktopStarter application : this.setup.getDesktopStarters()) {
                new OSXApplicationBuilder((Dmg)this.task, this.setup, this.fileResolver).buildApplication(application);
                if (this.firstExecutableName != null) continue;
                this.firstExecutableName = application.getDisplayName();
            }
            this.imageSourceRoot = this.buildDir.toString();
            if (this.firstExecutableName == null) {
                this.firstExecutableName = this.setup.getApplication();
            }
            if (!this.setup.getServices().isEmpty()) {
                this.createPackageFromApp();
            }
            this.createBinary();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void createBinary() throws Throwable {
        this.createTempImage();
        this.attach();
        this.setVolumeIcon();
        this.applescript();
        this.detach();
        this.finalImage();
        new File(this.setup.getDestinationDir(), "pack.temp.dmg").delete();
    }

    private void createServiceFiles() throws IOException {
        Service core = new Service(this.setup);
        core.setId(((Dmg)this.task).getApplicationIdentifier(this.setup));
        DesktopStarter runAfter = this.setup.getRunAfter();
        DesktopStarter runBeforeUninstall = this.setup.getRunBeforeUninstall();
        OSXScriptBuilder preinstall = new OSXScriptBuilder(core, "template/preinstall.txt");
        preinstall.addScript(new OSXScriptBuilder(((Dmg)this.task).getPreinst()));
        OSXScriptBuilder postinstall = new OSXScriptBuilder(core, "template/postinstall.txt");
        preinstall.addScript(new OSXScriptBuilder(((Dmg)this.task).getPostinst()));
        OSXScriptBuilder uninstall = new OSXScriptBuilder(core, "template/uninstall.txt");
        uninstall.addScript(new OSXScriptBuilder(((Dmg)this.task).getPrerm()));
        OSXScriptBuilder watchUninstall = new OSXScriptBuilder(core, "service/watchuninstall.plist");
        if (((Dmg)this.task).getDaemonUser() != "root") {
            String home = "/Library/Application Support/" + this.setup.getApplication();
            OSXScriptBuilder createUser = new OSXScriptBuilder(core, "template/preinstall.createuser.txt");
            OSXScriptBuilder removeUser = new OSXScriptBuilder(core, "template/postuninstall.remove.user.txt");
            OSXScriptBuilder[] list = new OSXScriptBuilder[]{createUser, removeUser, postinstall};
            Arrays.asList(list).forEach(item -> {
                item.setPlaceholder("daemonUser", ((Dmg)this.task).getDaemonUser());
                item.setPlaceholder("homeDirectory", home);
            });
            preinstall.addScript(createUser);
            uninstall.addScript(removeUser);
        }
        for (Service service : this.setup.getServices()) {
            if (runBeforeUninstall != null) {
                runBeforeUninstall.setDisplayName(service.getDisplayName());
                uninstall.addScript(new OSXScriptBuilder(runBeforeUninstall, "template/runBeforeAfter.txt").setPlaceholder("installationSubdirectory", this.installationSubdirectory()).setPlaceholder("inBackground", "NO").setPlaceholder("startArgument", runBeforeUninstall.getStartArguments()));
            }
            preinstall.addScript(new OSXScriptBuilder(service, "template/preinstall.remove-service.txt"));
            postinstall.addScript(new OSXScriptBuilder(service, "template/postinstall.install-service.txt").setPlaceholder("installationSubdirectory", this.installationSubdirectory()));
            uninstall.addScript(new OSXScriptBuilder(service, "template/preinstall.remove-service.txt"));
            if (runAfter == null) continue;
            runAfter.setDisplayName(service.getDisplayName());
            postinstall.addScript(new OSXScriptBuilder(runAfter, "template/runBeforeAfter.txt").setPlaceholder("installationSubdirectory", this.installationSubdirectory()).setPlaceholder("startArgument", runAfter.getStartArguments()));
        }
        uninstall.addScript(new OSXScriptBuilder(((Dmg)this.task).getPostrm()));
        uninstall.writeTo(this.tempPath.getTempFile("scripts", "uninstall.sh"));
        watchUninstall.writeTo(this.tempPath.getTempFile("scripts", "watchuninstall.plist"));
        preinstall.writeTo(this.tempPath.getTempFile("scripts", "preinstall"));
        postinstall.writeTo(this.tempPath.getTempFile("scripts", "postinstall"));
    }

    private void createPackageFromApp() throws Throwable {
        this.createServiceFiles();
        this.extractApplicationInformation();
        this.createAndPatchDistributionXML();
        this.imageSourceRoot = this.tempPath.get("distribution").toString();
        File resultingPackage = new File(this.imageSourceRoot, this.setup.getApplication() + ".pkg");
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/productbuild");
        command.add("--distribution");
        command.add(this.tempPath.getTempString("distribution.xml"));
        command.add("--package-path");
        command.add(this.tempPath.get("packages").toString());
        command.add("--resources");
        command.add(this.tempPath.get("resources").toString());
        command.add(resultingPackage.getAbsolutePath());
        this.exec(command);
        if (((Dmg)this.task).getCodeSign() != null) {
            ((Dmg)this.task).getCodeSign().signProduct(resultingPackage);
        }
        this.packageApplescript();
        Files.copy(resultingPackage.toPath(), new File(this.setup.getDestinationDir(), "/" + this.setup.getApplication() + ".pkg").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void extractApplicationInformation() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/pkgbuild");
        command.add("--analyze");
        command.add("--root");
        command.add(this.buildDir.toString());
        command.add(this.tempPath.getTempString(this.setup.getAppIdentifier() + ".plist"));
        this.exec(command);
        command = new ArrayList();
        command.add("/usr/bin/pkgbuild");
        command.add("--root");
        command.add(this.buildDir.toString());
        command.add("--component-plist");
        command.add(this.tempPath.getTempString(this.setup.getAppIdentifier() + ".plist"));
        command.add("--identifier");
        command.add(((Dmg)this.task).getApplicationIdentifier(this.setup));
        command.add("--version");
        command.add(((Dmg)this.task).getVersion());
        command.add("--scripts");
        command.add(this.tempPath.get("scripts").toString());
        command.add("--install-location");
        command.add("/Applications/" + this.installationSubdirectory());
        command.add(this.tempPath.getTempString("packages", this.setup.getApplication() + ".pkg"));
        this.exec(command);
        Files.copy(this.tempPath.getTempFile("packages", this.setup.getApplication() + ".pkg").toPath(), new File(this.setup.getDestinationDir(), "/" + this.setup.getAppIdentifier() + ".pkgbuild.pkg").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private String installationSubdirectory() {
        return this.setup.getServices().size() + this.setup.getDesktopStarters().size() > 1 ? this.setup.getApplication() + "/" : "";
    }

    private void createAndPatchDistributionXML() throws Throwable {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/productbuild");
        command.add("--synthesize");
        command.add("--package");
        command.add(this.tempPath.getTempFile("packages", this.setup.getApplication() + ".pkg").toString());
        command.add(this.tempPath.getTempFile("distribution.xml").toString());
        this.exec(command);
        this.patchDistributionXML();
    }

    private void patchDistributionXML() throws Throwable {
        File xml = this.tempPath.getTempFile("distribution.xml");
        URL url = xml.toURI().toURL();
        XmlFileBuilder<AbstractSetupTask> xmlFile = new XmlFileBuilder<AbstractSetupTask>((AbstractSetupTask)this.task, this.setup, xml, this.buildDir, url);
        Element distribution = (Element)xmlFile.doc.getFirstChild();
        if (!"installer-gui-script".equals(distribution.getTagName())) {
            throw new IllegalArgumentException("Template does not contain an installer-gui-script root: " + distribution.getTagName());
        }
        Element title = xmlFile.getOrCreateChild(distribution, "title");
        xmlFile.addNodeText(title, this.setup.getApplication());
        File backgroundImage = ((Dmg)this.task).getSetupBackgroundImage();
        if (backgroundImage != null) {
            Files.copy(backgroundImage.toPath(), this.tempPath.getTempFile("resources", backgroundImage.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            Element background = xmlFile.getOrCreateChild(distribution, "background", false);
            xmlFile.addAttributeIfNotExists(background, "file", backgroundImage.getName());
            xmlFile.addAttributeIfNotExists(background, "alignment", "left");
            xmlFile.addAttributeIfNotExists(background, "proportional", "left");
        }
        List<LocalizedResource> welcomePages = ((Dmg)this.task).getWelcomePages();
        for (LocalizedResource localizedResource : welcomePages) {
            File welcomePage = this.checkSetupTextFile(localizedResource.getResource());
            if (welcomePage == null) continue;
            Files.copy(welcomePage.toPath(), this.tempPath.getTempFile("resources/" + localizedResource.getLanguage() + ".lproj", "Welcome").toPath(), StandardCopyOption.REPLACE_EXISTING);
            Element license = xmlFile.getOrCreateChild(distribution, "welcome", false);
            xmlFile.addAttributeIfNotExists(license, "file", "Welcome");
        }
        List<LocalizedResource> licenseFiles = this.setup.getLicenseFiles();
        for (LocalizedResource localizedResource : licenseFiles) {
            File licenseFile = this.checkSetupTextFile(localizedResource.getResource());
            if (licenseFile == null) continue;
            Files.copy(licenseFile.toPath(), this.tempPath.getTempFile("resources/" + localizedResource.getLanguage() + ".lproj", "License").toPath(), StandardCopyOption.REPLACE_EXISTING);
            Element license = xmlFile.getOrCreateChild(distribution, "license", false);
            xmlFile.addAttributeIfNotExists(license, "file", "License");
        }
        List<LocalizedResource> list = ((Dmg)this.task).getConclusionPages();
        for (LocalizedResource localizedResource : list) {
            File welcomePage = this.checkSetupTextFile(localizedResource.getResource());
            if (welcomePage == null) continue;
            Files.copy(welcomePage.toPath(), this.tempPath.getTempFile("resources/" + localizedResource.getLocale().getLanguage() + ".lproj", "Conclusion").toPath(), StandardCopyOption.REPLACE_EXISTING);
            Element license = xmlFile.getOrCreateChild(distribution, "conclusion", false);
            xmlFile.addAttributeIfNotExists(license, "file", "Conclusion");
        }
        xmlFile.save();
    }

    private File checkSetupTextFile(File file) {
        if (file != null) {
            String name = file.getName();
            for (String format : new String[]{"txt", "rtf", "rtfd", "html"}) {
                if (!name.toLowerCase().endsWith("." + format)) continue;
                return file;
            }
            System.err.println("The provided file must be of type: txt, rtf, rtfd or html. File was: " + name);
        }
        return null;
    }

    private void createTempImage() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/hdiutil");
        command.add("create");
        command.add("-srcfolder");
        command.add(this.imageSourceRoot);
        command.add("-fs");
        command.add("HFS+");
        command.add("-format");
        command.add("UDRW");
        command.add("-volname");
        command.add(this.setup.getApplication());
        command.add(this.setup.getDestinationDir() + "/pack.temp.dmg");
        this.exec(command);
    }

    private void attach() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/hdiutil");
        command.add("attach");
        command.add("-readwrite");
        command.add("-noverify");
        command.add("-noautoopen");
        command.add(this.setup.getDestinationDir() + "/pack.temp.dmg");
        command.add("-mountroot");
        command.add(this.tempPath.get());
        this.exec(command);
    }

    private void detach() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/hdiutil");
        command.add("detach");
        command.add(this.tempPath.get() + "/" + this.setup.getApplication());
        this.exec(command);
    }

    private void setVolumeIcon() throws IOException {
        File iconDestination = this.tempPath.getTempFile(this.setup.getApplication(), ".VolumeIcon.icns");
        File icons = this.setup.getIconForType(this.buildDir, "icns");
        if (icons == null) {
            throw new IllegalArgumentException("You have to specify a valid icon file");
        }
        Files.copy(icons.toPath(), iconDestination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.exec("SetFile", "-a", "C", iconDestination.getParent());
        if (((Dmg)this.task).getBackgroundImage() != null) {
            String name = ((Dmg)this.task).getBackgroundImage().getName();
            File backgroundDestination = this.tempPath.getTempFile(this.setup.getApplication(), "/.resources/background" + name.substring(name.lastIndexOf(46)));
            Files.createDirectories(backgroundDestination.getParentFile().toPath(), new FileAttribute[0]);
            Files.copy(((Dmg)this.task).getBackgroundImage().toPath(), backgroundDestination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            BufferedImage image = ImageIO.read(backgroundDestination);
            if (image != null) {
                ((Dmg)this.task).setWindowWidth(image.getWidth());
                ((Dmg)this.task).setWindowHeight(image.getHeight());
            }
        }
    }

    private void applescript() throws IOException {
        Template applescript = new Template("dmg/template/applescript.txt");
        applescript.setPlaceholder("displayName", this.setup.getApplication());
        applescript.setPlaceholder("executable", this.firstExecutableName);
        applescript.setPlaceholder("backgroundColor", ((Dmg)this.task).getBackgroundColor());
        applescript.setPlaceholder("windowWidth", ((Dmg)this.task).getWindowWidth().toString());
        applescript.setPlaceholder("windowHeight", ((Dmg)this.task).getWindowHeight().toString());
        applescript.setPlaceholder("iconSize", ((Dmg)this.task).getIconSize().toString());
        applescript.setPlaceholder("fontSize", ((Dmg)this.task).getFontSize().toString());
        if (((Dmg)this.task).getBackgroundImage() != null) {
            String name = ((Dmg)this.task).getBackgroundImage().getName();
            applescript.setPlaceholder("backgroundExt", name.substring(name.lastIndexOf(46)));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/osascript");
        Logging.sysout("Setting DMG display options.");
        Logging.sysout(applescript.toString());
        this.exec(command, new ByteArrayInputStream(applescript.toString().getBytes(StandardCharsets.UTF_8)), null, true);
    }

    private void packageApplescript() throws IOException {
        Template applescript = new Template("dmg/template/package.applescript.txt");
        applescript.setPlaceholder("icon", ImageFactory.getImageFile(((Dmg)this.task).getProject(), ((Dmg)this.task).getSetupIcon(), this.buildDir, "icns").getAbsolutePath());
        applescript.setPlaceholder("package", new File(this.imageSourceRoot, this.setup.getApplication() + ".pkg").getAbsolutePath());
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/osascript");
        Logging.sysout("Setting display options for package.");
        Logging.sysout(applescript.toString());
        this.exec(command, new ByteArrayInputStream(applescript.toString().getBytes(StandardCharsets.UTF_8)), null, true);
    }

    private void finalImage() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("/usr/bin/hdiutil");
        command.add("convert");
        command.add(this.setup.getDestinationDir() + "/pack.temp.dmg");
        command.add("-format");
        command.add("UDZO");
        command.add("-imagekey");
        command.add("zlib-level=9");
        command.add("-o");
        command.add(((Dmg)this.task).getSetupFile().toString());
        this.exec(command);
    }
}

