/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.dmg;

import com.inet.gradle.appbundler.OSXCodeSign;
import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.AbstractUnixSetupTask;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.dmg.DmgBuilder;
import com.inet.gradle.setup.dmg.OSXApplicationBuilder;
import com.inet.gradle.setup.dmg.PreferencesLink;
import com.inet.gradle.setup.util.GradleUtils;
import groovy.lang.Closure;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.ConfigureUtil;

public class Dmg
extends AbstractUnixSetupTask {
    private Object backgroundImage;
    private Object setupBackground;
    private Object setupIcon;
    private Integer windowWidth = 400;
    private Integer windowHeight = 300;
    private Integer iconSize = 128;
    private Integer fontSize = 14;
    private Integer windowWidthCorrection = 0;
    private Integer windowHeightCorrection = 22;
    private Color backgroundColor;
    private String applicationIdentifier;
    private OSXCodeSign<Dmg, SetupBuilder> codeSign;
    private List<LocalizedResource> welcomePages = new ArrayList<LocalizedResource>();
    private List<LocalizedResource> conclusionPages = new ArrayList<LocalizedResource>();
    private List<PreferencesLink> preferencesLink = new ArrayList<PreferencesLink>();
    final List<OSXApplicationBuilder> appBuilders = new ArrayList<OSXApplicationBuilder>();
    private List<String> jreIncludes = Arrays.asList("bin/java", "lib/", "COPYRIGHT", "LICENSE", "README", "THIRDPARTYLICENSEREADME-JAVAFX.txt", "THIRDPARTYLICENSEREADME.txt", "Welcome.html");
    private List<String> jreExcludes = Arrays.asList("lib/deploy/", "lib/deploy.jar", "lib/javaws.jar", "lib/libdeploy.dylib", "lib/libnpjp2.dylib", "lib/plugin.jar", "lib/security/javaws.policy");

    public Dmg() {
        super("dmg");
        this.getProject().afterEvaluate(project -> {
            boolean isExecute = GradleUtils.isTaskExecute((Task)this, project);
            if (isExecute) {
                SetupBuilder setup = this.getSetupBuilder();
                for (Service service : setup.getServices()) {
                    ProjectInternal projInternal = (ProjectInternal)project;
                    OSXApplicationBuilder builder = new OSXApplicationBuilder(this, setup, projInternal.getFileResolver());
                    builder.configSubTasks(service);
                    this.appBuilders.add(builder);
                }
            }
        });
    }

    @Override
    public void build() {
        ProjectInternal project = (ProjectInternal)this.getProject();
        new DmgBuilder(this, this.getSetupBuilder(), project.getFileResolver()).build();
    }

    public Integer getWindowWidth() {
        return this.windowWidth + this.windowWidthCorrection;
    }

    public void setWindowWidth(Integer windowWidth) {
        this.windowWidth = windowWidth;
    }

    public Integer getWindowWidthCorrection() {
        return this.windowWidthCorrection;
    }

    public void setWindowWidthCorrection(Integer windowWidthCorrection) {
        this.windowWidthCorrection = windowWidthCorrection;
    }

    public Integer getWindowHeight() {
        return this.windowHeight + this.windowHeightCorrection;
    }

    public void setWindowHeight(Integer windowHeight) {
        this.windowHeight = windowHeight;
    }

    public Integer getWindowHeightCorrection() {
        return this.windowHeightCorrection;
    }

    public void setWindowHeightCorrection(Integer windowHeightCorrection) {
        this.windowHeightCorrection = windowHeightCorrection;
    }

    public Integer getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(Integer iconSize) {
        this.iconSize = iconSize;
    }

    public File getBackgroundImage() {
        if (this.backgroundImage != null) {
            return this.getProject().file(this.backgroundImage);
        }
        return null;
    }

    public void setBackgroundImage(File backgroundFile) {
        this.backgroundImage = backgroundFile;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public void setCodeSign(Closure<OSXCodeSign<Dmg, SetupBuilder>> closure) {
        ProjectInternal project = (ProjectInternal)this.getProject();
        this.codeSign = (OSXCodeSign)ConfigureUtil.configure(closure, new OSXCodeSign(this, project.getFileResolver()));
    }

    public OSXCodeSign<Dmg, SetupBuilder> getCodeSign() {
        return this.codeSign;
    }

    public List<LocalizedResource> getConclusionPages() {
        return this.conclusionPages;
    }

    public void conclusionPage(Object conclusionPage) {
        LocalizedResource.addLocalizedResource(this.getSetupBuilder(), this.conclusionPages, conclusionPage);
    }

    public List<LocalizedResource> getWelcomePages() {
        return this.welcomePages.size() > 0 ? this.welcomePages : this.getSetupBuilder().getLongDescriptions();
    }

    public void welcomePage(Object welcomePage) {
        LocalizedResource.addLocalizedResource(this.getSetupBuilder(), this.welcomePages, welcomePage);
    }

    public File getSetupBackgroundImage() {
        if (this.setupBackground != null) {
            return this.getProject().file(this.setupBackground);
        }
        return null;
    }

    public void setSetupBackgroundImage(Object setupBackground) {
        this.setupBackground = setupBackground;
    }

    public Object getSetupIcon() {
        if (this.setupIcon == null) {
            return this.getSetupBuilder().getIcons();
        }
        return this.setupIcon;
    }

    public void setSetupIcon(Object setupIcon) {
        this.setupIcon = setupIcon;
    }

    public List<PreferencesLink> getPreferencesLinks() {
        return this.preferencesLink;
    }

    public void preferencesLink(Object link) {
        this.preferencesLink.add((PreferencesLink)ConfigureUtil.configure((Closure)((Closure)link), (Object)new PreferencesLink()));
    }

    public List<String> getJreIncludes() {
        return this.jreIncludes;
    }

    public void setJreIncludes(List<String> jreIncludes) {
        this.jreIncludes = jreIncludes;
    }

    public List<String> getJreExcludes() {
        return this.jreExcludes;
    }

    public void setJreExcludes(List<String> jreExclude) {
        this.jreExcludes = jreExclude;
    }

    public String getBackgroundColor() {
        if (this.backgroundColor == null) {
            this.backgroundColor = new Color(255, 255, 255);
        }
        return "{" + String.join((CharSequence)", ", Arrays.asList(String.valueOf(this.backgroundColor.getRed() * 257), String.valueOf(this.backgroundColor.getGreen() * 257), String.valueOf(this.backgroundColor.getBlue() * 257))) + "}";
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getApplicationIdentifier(SetupBuilder setup) {
        if (this.applicationIdentifier == null || this.applicationIdentifier.isEmpty()) {
            if (setup.getMainClass() == null || setup.getMainClass().isEmpty()) {
                return setup.getAppIdentifier();
            }
            return setup.getMainClass();
        }
        return this.applicationIdentifier;
    }

    public void setApplicationIdentifier(String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
    }
}

