/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.abstracts;

import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.abstracts.Application;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProtocolHandler
extends Application {
    private List<String> scheme = new ArrayList<String>();

    public ProtocolHandler(AbstractSetupBuilder setup) {
        super(setup);
    }

    public List<String> getSchemes() {
        return this.scheme;
    }

    public void setScheme(Object scheme) {
        this.scheme = !(scheme instanceof List) ? Arrays.asList((String)scheme) : (List)scheme;
        this.checkSchemesAreValid();
    }

    public void scheme(Object scheme) {
        if (!(scheme instanceof List)) {
            if (!((String)scheme).matches("^[a-zA-Z]+$")) {
                throw new IllegalArgumentException("The scheme only allows the letters 'a-z'. Was: " + scheme);
            }
            this.scheme.add((String)scheme);
        } else {
            this.scheme.addAll((List)scheme);
        }
        this.checkSchemesAreValid();
    }

    private void checkSchemesAreValid() {
        if (this.scheme.stream().filter(e -> !e.matches("^[a-zA-Z]+$")).findFirst().isPresent()) {
            this.scheme = new ArrayList<String>();
            throw new IllegalArgumentException("The scheme only allows the letters 'a-z'. Was: " + this.scheme);
        }
    }
}

