/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.abstracts;

import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.abstracts.DocumentType;
import com.inet.gradle.setup.abstracts.ProtocolHandler;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.util.ConfigureUtil;

public class DesktopStarter
extends ProtocolHandler {
    private String mimeTypes;
    private String categories;
    private Location location;
    private List<DocumentType> documentTypes = new ArrayList<DocumentType>();

    public DesktopStarter(AbstractSetupBuilder setup) {
        super(setup);
    }

    public void setMimeTypes(String mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public String getMimeTypes() {
        return this.mimeTypes;
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public String getCategories() {
        return this.categories;
    }

    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        return Location.StartMenu;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void documentType(Closure<?> closue) {
        DocumentType doc = (DocumentType)ConfigureUtil.configure(closue, (Object)new DocumentType(this.setup));
        if (doc.getFileExtension() == null || doc.getFileExtension().size() == 0) {
            throw new GradleException("The documentType has to contain at least one file extension.");
        }
        this.documentTypes.add(doc);
    }

    public List<DocumentType> getDocumentType() {
        return this.documentTypes;
    }

    public static enum Location {
        StartMenu,
        ApplicationMenu,
        InstallDir,
        DesktopDir;

    }
}

