/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.abstracts;

import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.abstracts.SetupSources;
import com.inet.gradle.setup.util.TempPath;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;

public abstract class AbstractTask
extends DefaultTask
implements SetupSources {
    private final CopySpecInternal rootSpec;
    private AbstractSetupBuilder setupBuilder;
    private String extension;
    private String classifier;
    private String version;

    public AbstractTask(String extension, Class<? extends AbstractSetupBuilder> setupType) {
        this.extension = extension;
        this.rootSpec = (CopySpecInternal)this.getProject().copySpec((Closure)null);
        ProjectInternal project = (ProjectInternal)this.getProject();
        this.setupBuilder = (AbstractSetupBuilder)project.getExtensions().getByType(setupType);
        this.setGroup("build");
        try {
            TempPath.clearTemporaryFolder(this.getTemporaryDir().toPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TaskAction
    public void action() {
        this.build();
        File setupFile = this.getSetupFile();
        if (!setupFile.exists()) {
            throw new GradleException("Setup file was not created: " + setupFile);
        }
        Configuration archives = this.getProject().getConfigurations().getByName("archives");
        archives.getArtifacts().add((Object)new DefaultPublishArtifact(this.setupBuilder.getAppIdentifier(), this.extension, this.extension, this.classifier, new Date(setupFile.lastModified()), setupFile, new Object[]{this}));
    }

    public void copyTo(final File target) {
        this.processFiles(new CopyActionProcessingStreamAction(){

            public void processFile(FileCopyDetailsInternal details) {
                if (!details.isDirectory()) {
                    try {
                        File f = details.getRelativePath().getFile(target);
                        if (!f.getParentFile().exists()) {
                            f.getParentFile().mkdirs();
                        }
                        try (InputStream input = details.open();){
                            Files.copy(input, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        });
    }

    protected void processFiles(CopyActionProcessingStreamAction action) {
        this.processFiles(action, this.setupBuilder.getRootSpec());
        this.processFiles(action, this.rootSpec);
    }

    private void processFiles(final CopyActionProcessingStreamAction action, CopySpecInternal copySpec) {
        if (this.setupBuilder.isFailOnEmptyFrom()) {
            for (CopySpecInternal cs : copySpec.getChildren()) {
                CopySpecResolver rootResolver = cs.buildRootResolver();
                Set files = rootResolver.getAllSource().getFiles();
                if (files.size() == 0) {
                    throw new IllegalArgumentException("No files selected by: " + ((DefaultCopySpec)cs).getSourcePaths() + " --> " + rootResolver.getDestPath() + ". This means that there are files missing or your 'from' method in your gradle script is wrong. If an empty 'from' is valid then disable the check with 'setupBuilder.failOnEmptyFrom = false'");
                }
                int includeCount = cs.getIncludes().size();
                if (files.size() >= includeCount) continue;
                StringBuilder msg = new StringBuilder("Not every 'include' match a file by: ");
                msg.append(((DefaultCopySpec)cs).getSourcePaths());
                msg.append("\n\tDeclared includes:");
                for (String include : cs.getIncludes()) {
                    msg.append("\n\t\t").append(include);
                }
                msg.append("\n\tMatching files:");
                for (File file : files) {
                    msg.append("\n\t\t").append(file);
                }
                throw new IllegalArgumentException(msg.toString());
            }
        }
        CopyActionExecuter copyActionExecuter = new CopyActionExecuter(this.getInstantiator(), this.getFileSystem(), true);
        CopyAction copyAction = new CopyAction(){

            public WorkResult execute(CopyActionProcessingStream stream) {
                stream.process(action);
                return WorkResults.didWork((boolean)true);
            }
        };
        copyActionExecuter.execute(copySpec, copyAction);
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    public abstract void build();

    protected AbstractSetupBuilder getAbstractSetupBuilder() {
        return this.setupBuilder;
    }

    public CopySpecInternal getRootSpec() {
        return this.rootSpec;
    }

    @Override
    @InputFiles
    public FileTree getSource() {
        return SetupSources.super.getSource();
    }

    @InputFiles
    public FileTree getSetupSource() {
        try {
            return this.setupBuilder.getSource();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("You have to specify input sources for your application", e);
        }
    }

    @OutputFile
    public File getSetupFile() {
        StringBuilder setupFile = new StringBuilder(this.setupBuilder.getArchiveName());
        if (this.getClassifier() != null && !this.getClassifier().isEmpty()) {
            setupFile.append('-');
            setupFile.append(this.getClassifier());
        }
        setupFile.append('.');
        setupFile.append(this.getExtension());
        return new File(this.setupBuilder.getDestinationDir(), setupFile.toString());
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getDescription() {
        String desc = super.getDescription();
        if (desc != null && !desc.isEmpty()) {
            return desc;
        }
        return this.setupBuilder.getDescription();
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return this.setupBuilder.getVersion();
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

