/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class Template {
    private String template;

    public Template(String file) throws IOException {
        try (Scanner scanner = new Scanner(this.getClass().getResourceAsStream(file), "UTF8");){
            this.template = scanner.useDelimiter("\\A").next();
        }
    }

    public Template(ArrayList<String> script) {
        this.template = script != null && !script.isEmpty() ? String.join((CharSequence)"\n", script) : "";
    }

    public Template setPlaceholder(String placeholder, String content) {
        if (content == null) {
            content = "";
        }
        this.template = this.template.replace("{{" + placeholder + "}}", content);
        return this;
    }

    public void writeTo(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(this.template);
        }
    }

    public String toString() {
        return this.template.replaceAll("\\{\\{.*?\\}\\}", "");
    }
}

