/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup;

import com.inet.gradle.setup.abstracts.AbstractSetupBuilder;
import com.inet.gradle.setup.abstracts.DesktopStarter;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.abstracts.Service;
import com.inet.gradle.setup.abstracts.SetupSources;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.util.ConfigureUtil;

public class SetupBuilder
extends AbstractSetupBuilder
implements SetupSources {
    private List<LocalizedResource> licenseFiles = new ArrayList<LocalizedResource>();
    private List<LocalizedResource> longDescription = new ArrayList<LocalizedResource>();
    private String defaultResourceLanguage = "en";
    private DesktopStarter runAfter;
    private DesktopStarter runBeforeUninstall;
    private List<Service> services = new ArrayList<Service>();
    private final List<DesktopStarter> desktopStarters = new ArrayList<DesktopStarter>();
    private List<String> deleteFiles = new ArrayList<String>();
    private List<String> deleteFolders = new ArrayList<String>();

    public SetupBuilder(Project project) {
        super(project);
    }

    public List<LocalizedResource> getLicenseFiles() {
        return this.licenseFiles;
    }

    public File getLicenseFile(String locale) {
        return LocalizedResource.getLocalizedResourceFile(this.licenseFiles, locale);
    }

    public void setLicenseFile(Object license) {
        this.licenseFiles.clear();
        this.licenseFile(license);
    }

    public void licenseFile(Object license) {
        LocalizedResource.addLocalizedResource(this, this.licenseFiles, license);
    }

    public DesktopStarter getRunAfter() {
        return this.runAfter;
    }

    public void setRunAfter(String runAfter) {
        this.runAfter = new DesktopStarter(this);
        this.runAfter.setExecutable(runAfter);
    }

    public void runAfter(Closure<?> closure) {
        this.runAfter = (DesktopStarter)ConfigureUtil.configure(closure, (Object)new DesktopStarter(this));
    }

    public DesktopStarter getRunBeforeUninstall() {
        return this.runBeforeUninstall;
    }

    public void setRunBeforeUninstall(String runAfter) {
        this.runBeforeUninstall = new DesktopStarter(this);
        this.runBeforeUninstall.setExecutable(runAfter);
    }

    public void runBeforeUninstall(Closure<DesktopStarter> closue) {
        this.runBeforeUninstall = (DesktopStarter)ConfigureUtil.configure(closue, (Object)new DesktopStarter(this));
    }

    public void service(Closure<Service> closue) {
        Service service = (Service)ConfigureUtil.configure(closue, (Object)new Service(this));
        this.services.add(service);
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void desktopStarter(Closure<?> closue) {
        DesktopStarter service = (DesktopStarter)ConfigureUtil.configure(closue, (Object)new DesktopStarter(this));
        this.desktopStarters.add(service);
    }

    public List<DesktopStarter> getDesktopStarters() {
        return this.desktopStarters;
    }

    public List<String> getDeleteFiles() {
        return this.deleteFiles;
    }

    public void deleteFiles(String pattern) {
        if (pattern.isEmpty()) {
            return;
        }
        this.deleteFiles.add(pattern);
    }

    public List<String> getDeleteFolders() {
        return this.deleteFolders;
    }

    public void deleteFolder(String folder) {
        this.deleteFolders.add(folder);
    }

    public String getDefaultResourceLanguage() {
        return this.defaultResourceLanguage;
    }

    public void setDefaultResourceLanguage(String defaultResourceLanguage) {
        this.defaultResourceLanguage = defaultResourceLanguage;
    }

    public List<LocalizedResource> getLongDescriptions() {
        return this.longDescription;
    }

    public File getLongDescription(String locale) {
        return LocalizedResource.getLocalizedResourceFile(this.longDescription, locale);
    }

    public void longDescription(Object description) {
        LocalizedResource.addLocalizedResource(this, this.longDescription, description);
    }
}

