/*
 * Decompiled with CFR 0.152.
 */
package data;

import core.entity.BuildConfig;
import core.entity.BuildStatus;
import core.usecase.PostStatusUseCase;
import data.GithubDatasource;
import data.GithubDatasourceKt;
import data.RetrofitsKt;
import io.reactivex.Observable;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Ldata/GithubDatasource;", "Lcore/usecase/PostStatusUseCase$Datasource;", "config", "Lcore/entity/BuildConfig;", "(Lcore/entity/BuildConfig;)V", "getConfig", "()Lcore/entity/BuildConfig;", "retrofit", "Lretrofit2/Retrofit;", "getRetrofit", "()Lretrofit2/Retrofit;", "retrofit$delegate", "Lkotlin/Lazy;", "service", "Ldata/GithubDatasource$Service;", "kotlin.jvm.PlatformType", "getService", "()Ldata/GithubDatasource$Service;", "service$delegate", "isActive", "", "isRemote", "name", "", "post", "Lio/reactivex/Observable;", "status", "Lcore/entity/BuildStatus;", "message", "key", "GetBody", "GithubBuildStatusBody", "Service", "BuildChecks"})
public final class GithubDatasource
implements PostStatusUseCase.Datasource {
    @NotNull
    private final BuildConfig config;
    @NotNull
    private final Lazy retrofit$delegate;
    @NotNull
    private final Lazy service$delegate;

    public GithubDatasource(@NotNull BuildConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.retrofit$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Retrofit>(this){
            final /* synthetic */ GithubDatasource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Retrofit invoke() {
                return RetrofitsKt.retrofit(this.this$0.getConfig().getBaseUrl(), this.this$0.getConfig().getAuthorization());
            }
        }));
        this.service$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Service>(this){
            final /* synthetic */ GithubDatasource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Service invoke() {
                return (Service)GithubDatasource.access$getRetrofit(this.this$0).create(Service.class);
            }
        }));
    }

    @NotNull
    public final BuildConfig getConfig() {
        return this.config;
    }

    private final Retrofit getRetrofit() {
        Lazy lazy = this.retrofit$delegate;
        return (Retrofit)lazy.getValue();
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    public Observable<Boolean> post(@NotNull BuildStatus status, @NotNull String message, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        GithubBuildStatusBody body = new GithubBuildStatusBody(GithubDatasourceKt.githubFormat(status), key, message, this.config.getBuildUrl(), null, 16, null);
        Observable observable = this.getService().postBuildStatus(this.config.getGit().getCommitHash(), body).map(arg_0 -> GithubDatasource.post$lambda$0(post.1.INSTANCE, arg_0)).onErrorReturn(arg_0 -> GithubDatasource.post$lambda$1(post.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"service.postBuildStatus(\u2026}.onErrorReturn { false }");
        return observable;
    }

    private final Service getService() {
        Lazy lazy = this.service$delegate;
        return (Service)lazy.getValue();
    }

    @Override
    public boolean isActive() {
        return this.config.isPostActivated() && StringsKt.contains$default((CharSequence)this.config.getBaseUrl(), (CharSequence)"github", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public String name() {
        return "Github";
    }

    private static final Boolean post$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean post$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Retrofit access$getRetrofit(GithubDatasource $this) {
        return $this.getRetrofit();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Ldata/GithubDatasource$GetBody;", "", "description", "", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "setDescription", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "BuildChecks"})
    public static final class GetBody {
        @Nullable
        private String description;

        public GetBody(@Nullable String description) {
            this.description = description;
        }

        public /* synthetic */ GetBody(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        @Nullable
        public final String component1() {
            return this.description;
        }

        @NotNull
        public final GetBody copy(@Nullable String description) {
            return new GetBody(description);
        }

        public static /* synthetic */ GetBody copy$default(GetBody getBody, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = getBody.description;
            }
            return getBody.copy(string);
        }

        @NotNull
        public String toString() {
            return "GetBody(description=" + this.description + ')';
        }

        public int hashCode() {
            return this.description == null ? 0 : this.description.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetBody)) {
                return false;
            }
            GetBody getBody = (GetBody)other;
            return Intrinsics.areEqual((Object)this.description, (Object)getBody.description);
        }

        public GetBody() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\n\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\r\u00a8\u0006\u001f"}, d2={"Ldata/GithubDatasource$GithubBuildStatusBody;", "", "state", "", "context", "description", "target_url", "created_at", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getContext", "()Ljava/lang/String;", "getCreated_at", "setCreated_at", "(Ljava/lang/String;)V", "getDescription", "setDescription", "getState", "getTarget_url", "setTarget_url", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "BuildChecks"})
    public static final class GithubBuildStatusBody {
        @NotNull
        private final String state;
        @NotNull
        private final String context;
        @NotNull
        private String description;
        @Nullable
        private String target_url;
        @Nullable
        private String created_at;

        public GithubBuildStatusBody(@NotNull String state, @NotNull String context, @NotNull String description, @Nullable String target_url, @Nullable String created_at) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.state = state;
            this.context = context;
            this.description = description;
            this.target_url = target_url;
            this.created_at = created_at;
        }

        public /* synthetic */ GithubBuildStatusBody(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            this(string, string2, string3, string4, string5);
        }

        @NotNull
        public final String getState() {
            return this.state;
        }

        @NotNull
        public final String getContext() {
            return this.context;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.description = string;
        }

        @Nullable
        public final String getTarget_url() {
            return this.target_url;
        }

        public final void setTarget_url(@Nullable String string) {
            this.target_url = string;
        }

        @Nullable
        public final String getCreated_at() {
            return this.created_at;
        }

        public final void setCreated_at(@Nullable String string) {
            this.created_at = string;
        }

        @NotNull
        public final String component1() {
            return this.state;
        }

        @NotNull
        public final String component2() {
            return this.context;
        }

        @NotNull
        public final String component3() {
            return this.description;
        }

        @Nullable
        public final String component4() {
            return this.target_url;
        }

        @Nullable
        public final String component5() {
            return this.created_at;
        }

        @NotNull
        public final GithubBuildStatusBody copy(@NotNull String state, @NotNull String context, @NotNull String description, @Nullable String target_url, @Nullable String created_at) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new GithubBuildStatusBody(state, context, description, target_url, created_at);
        }

        public static /* synthetic */ GithubBuildStatusBody copy$default(GithubBuildStatusBody githubBuildStatusBody, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = githubBuildStatusBody.state;
            }
            if ((n & 2) != 0) {
                string2 = githubBuildStatusBody.context;
            }
            if ((n & 4) != 0) {
                string3 = githubBuildStatusBody.description;
            }
            if ((n & 8) != 0) {
                string4 = githubBuildStatusBody.target_url;
            }
            if ((n & 0x10) != 0) {
                string5 = githubBuildStatusBody.created_at;
            }
            return githubBuildStatusBody.copy(string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "GithubBuildStatusBody(state=" + this.state + ", context=" + this.context + ", description=" + this.description + ", target_url=" + this.target_url + ", created_at=" + this.created_at + ')';
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = result * 31 + this.context.hashCode();
            result = result * 31 + this.description.hashCode();
            result = result * 31 + (this.target_url == null ? 0 : this.target_url.hashCode());
            result = result * 31 + (this.created_at == null ? 0 : this.created_at.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GithubBuildStatusBody)) {
                return false;
            }
            GithubBuildStatusBody githubBuildStatusBody = (GithubBuildStatusBody)other;
            if (!Intrinsics.areEqual((Object)this.state, (Object)githubBuildStatusBody.state)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.context, (Object)githubBuildStatusBody.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)githubBuildStatusBody.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.target_url, (Object)githubBuildStatusBody.target_url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.created_at, (Object)githubBuildStatusBody.created_at);
        }

        public GithubBuildStatusBody() {
            this(null, null, null, null, null, 31, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\b\u0001\u0010\u0006\u001a\u00020\u0007H'J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\n\u001a\u00020\u0005H'\u00a8\u0006\u000b"}, d2={"Ldata/GithubDatasource$Service;", "", "getBuildStatus", "Lio/reactivex/Observable;", "", "Ldata/GithubDatasource$GithubBuildStatusBody;", "hash", "", "postBuildStatus", "Lokhttp3/ResponseBody;", "body", "BuildChecks"})
    public static interface Service {
        @Headers(value={"Accept: application/json", "User-Agent: gradle build"})
        @POST(value="statuses/{hash}")
        @NotNull
        public Observable<ResponseBody> postBuildStatus(@Path(value="hash") @NotNull String var1, @Body @NotNull GithubBuildStatusBody var2);

        @Headers(value={"Accept: application/json", "User-Agent: gradle build"})
        @GET(value="statuses/{hash}")
        @NotNull
        public Observable<List<GithubBuildStatusBody>> getBuildStatus(@Path(value="hash") @NotNull String var1);
    }
}

