/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.androidsdk;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeSelector;

public class VersionCompatHelpers {
    private static final String OPEN_INC = "[";
    private static final String OPEN_EXC = "]";
    private static final String OPEN_EXC_MAVEN = "(";
    private static final String CLOSE_INC = "]";
    private static final String CLOSE_EXC = "[";
    private static final String CLOSE_EXC_MAVEN = ")";
    private static final String LOWER_INFINITE = "(";
    private static final String UPPER_INFINITE = ")";
    private static final String SEPARATOR = ",";
    private static final String OPEN_INC_PATTERN = "\\[";
    private static final String OPEN_EXC_PATTERN = "\\]\\(";
    private static final String CLOSE_INC_PATTERN = "\\]";
    private static final String CLOSE_EXC_PATTERN = "\\[\\)";
    private static final String LI_PATTERN = "\\(";
    private static final String UI_PATTERN = "\\)";
    private static final String SEP_PATTERN = "\\s*\\,\\s*";
    private static final String OPEN_PATTERN = "[\\[\\]\\(]";
    private static final String CLOSE_PATTERN = "[\\]\\[\\)]";
    private static final String ANY_NON_SPECIAL_PATTERN = "[^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]";
    private static final String FINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String LOWER_INFINITE_PATTERN = "\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String UPPER_INFINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)";
    private static final String SINGLE_VALUE_PATTERN = "\\[\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\]";
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private static final Pattern SINGLE_VALUE_RANGE = Pattern.compile("\\[\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\]");
    public static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)|" + SINGLE_VALUE_RANGE);

    public static VersionRangeSelector intersect(VersionRangeSelector thisVersion, VersionRangeSelector other) {
        boolean inclusive;
        StringBuilder sb = new StringBuilder();
        Version lower = null;
        Version upper = null;
        boolean lowerInc = false;
        if (VersionCompatHelpers.getLowerBound(thisVersion) == null) {
            if (VersionCompatHelpers.getLowerBound(other) == null) {
                sb.append("(");
            } else {
                sb.append(VersionCompatHelpers.isLowerInclusive(other) ? "[" : "]");
                sb.append(VersionCompatHelpers.getLowerBound(other));
                lower = VersionCompatHelpers.getLowerBoundVersion(other);
                lowerInc = VersionCompatHelpers.isLowerInclusive(other);
            }
        } else if (VersionCompatHelpers.getLowerBound(other) == null || VersionCompatHelpers.isHigher(VersionCompatHelpers.getLowerBoundVersion(thisVersion), VersionCompatHelpers.getLowerBoundVersion(other), VersionCompatHelpers.isLowerInclusive(thisVersion))) {
            lowerInc = VersionCompatHelpers.getLowerBound(thisVersion).equals(VersionCompatHelpers.getLowerBound(other)) ? VersionCompatHelpers.isLowerInclusive(thisVersion) && VersionCompatHelpers.isLowerInclusive(other) : VersionCompatHelpers.isLowerInclusive(thisVersion);
            sb.append(lowerInc ? "[" : "]");
            sb.append(VersionCompatHelpers.getLowerBound(thisVersion));
            lower = VersionCompatHelpers.getLowerBoundVersion(thisVersion);
        } else {
            lowerInc = VersionCompatHelpers.getLowerBound(other).equals(VersionCompatHelpers.getLowerBound(thisVersion)) ? VersionCompatHelpers.isLowerInclusive(thisVersion) && VersionCompatHelpers.isLowerInclusive(other) : VersionCompatHelpers.isLowerInclusive(other);
            sb.append(lowerInc ? "[" : "]");
            sb.append(VersionCompatHelpers.getLowerBound(other));
            lower = VersionCompatHelpers.getLowerBoundVersion(other);
            lowerInc = VersionCompatHelpers.isLowerInclusive(other);
        }
        sb.append(SEPARATOR);
        if (VersionCompatHelpers.getUpperBound(thisVersion) == null) {
            if (VersionCompatHelpers.getUpperBound(other) == null) {
                sb.append(")");
            } else {
                sb.append(VersionCompatHelpers.getUpperBound(other));
                sb.append(VersionCompatHelpers.isUpperInclusive(other) ? "]" : "[");
                upper = VersionCompatHelpers.getUpperBoundVersion(other);
            }
        } else if (VersionCompatHelpers.getUpperBound(other) == null || VersionCompatHelpers.isLower(VersionCompatHelpers.getUpperBoundVersion(thisVersion), VersionCompatHelpers.getUpperBoundVersion(other), VersionCompatHelpers.isUpperInclusive(thisVersion))) {
            sb.append(VersionCompatHelpers.getUpperBound(thisVersion));
            inclusive = VersionCompatHelpers.getUpperBound(thisVersion).equals(VersionCompatHelpers.getUpperBound(other)) ? VersionCompatHelpers.isUpperInclusive(thisVersion) && VersionCompatHelpers.isUpperInclusive(other) : VersionCompatHelpers.isUpperInclusive(thisVersion);
            sb.append(inclusive ? "]" : "[");
            upper = VersionCompatHelpers.getUpperBoundVersion(thisVersion);
        } else {
            sb.append(VersionCompatHelpers.getUpperBound(other));
            inclusive = VersionCompatHelpers.getUpperBound(other).equals(VersionCompatHelpers.getUpperBound(thisVersion)) ? VersionCompatHelpers.isUpperInclusive(thisVersion) && VersionCompatHelpers.isUpperInclusive(other) : VersionCompatHelpers.isUpperInclusive(other);
            sb.append(inclusive ? "]" : "[");
            upper = VersionCompatHelpers.getUpperBoundVersion(other);
        }
        if (lower != null && upper != null && VersionCompatHelpers.isHigher(lower, upper, lowerInc)) {
            return null;
        }
        if (lower != null && lower.equals(upper) && !lowerInc) {
            return null;
        }
        DefaultVersionSelectorScheme versionSelectorScheme = new DefaultVersionSelectorScheme((VersionComparator)new DefaultVersionComparator());
        return (VersionRangeSelector)versionSelectorScheme.parseSelector(sb.toString());
    }

    private static boolean isLower(Version version1, Version version2, boolean inclusive) {
        int result = VersionCompatHelpers.getComparator().compare(version1, version2);
        return result <= (inclusive ? 0 : -1);
    }

    private static boolean isHigher(Version version1, Version version2, boolean inclusive) {
        int result = VersionCompatHelpers.getComparator().compare(version1, version2);
        return result >= (inclusive ? 0 : 1);
    }

    private static Comparator<Version> getComparator() {
        return new DefaultVersionComparator().asVersionComparator();
    }

    private static Object get(VersionRangeSelector version, String fieldName) {
        try {
            Field field = VersionRangeSelector.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(version);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static String getLowerBound(VersionRangeSelector version) {
        return (String)VersionCompatHelpers.get(version, "lowerBound");
    }

    private static String getUpperBound(VersionRangeSelector version) {
        return (String)VersionCompatHelpers.get(version, "upperBound");
    }

    private static Version getLowerBoundVersion(VersionRangeSelector version) {
        String lowerBound = VersionCompatHelpers.getLowerBound(version);
        return lowerBound == null ? null : new VersionParser().transform(lowerBound);
    }

    private static Version getUpperBoundVersion(VersionRangeSelector version) {
        String upperBound = VersionCompatHelpers.getUpperBound(version);
        return upperBound == null ? null : new VersionParser().transform(upperBound);
    }

    private static boolean isLowerInclusive(VersionRangeSelector version) {
        return (Boolean)VersionCompatHelpers.get(version, "lowerInclusive");
    }

    private static boolean isUpperInclusive(VersionRangeSelector version) {
        return (Boolean)VersionCompatHelpers.get(version, "upperInclusive");
    }
}

