/*
 * Decompiled with CFR 0.152.
 */
package com.nobleworks_software.gradle.gitflow;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class GitHelper
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GitHelper() {
        MetaClass metaClass;
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static String trimSuffix(String str, String suffix) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)str, (Object)suffix))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[1].call((Object)str, (Object)0, callSiteArray[2].call(callSiteArray[3].call((Object)str), callSiteArray[4].call((Object)suffix))));
        }
        return str;
    }

    private static String runCmd(List<String> cmd) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        Object stdout = callSiteArray[5].callConstructor(StringBuffer.class);
        Object stderr = callSiteArray[6].callConstructor(StringBuffer.class);
        Object process = callSiteArray[7].call(cmd);
        callSiteArray[8].call(process, stdout, stderr);
        callSiteArray[9].call(process, (Object)1000);
        int exitVal = DefaultTypeTransformation.intUnbox((Object)callSiteArray[10].call(process));
        Object stdOutStr = callSiteArray[11].callStatic(GitHelper.class, callSiteArray[12].call(stdout), (Object)"\n");
        Object stdErrStr = callSiteArray[13].callStatic(GitHelper.class, callSiteArray[14].call(stderr), (Object)"\n");
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (exitVal != 0) {
                throw (Throwable)callSiteArray[15].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{cmd, stdOutStr, stdErrStr}, new String[]{"Error executing command:\n'", "'\nstdout:\n'", "'\nstderr:\n'", "'\n----------"}));
            }
            return ShortTypeHandling.castToString((Object)stdOutStr);
        }
        if (exitVal != 0) {
            throw (Throwable)callSiteArray[16].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{cmd, stdOutStr, stdErrStr}, new String[]{"Error executing command:\n'", "'\nstdout:\n'", "'\nstderr:\n'", "'\n----------"}));
        }
        return ShortTypeHandling.castToString((Object)stdOutStr);
    }

    public static void deleteBranch(String name) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[17].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "branch", "-D", name}));
    }

    public static void resolveConflictTheirs(String filename) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[18].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "checkout", "--theirs", filename}));
    }

    public static void resolveConflictOurs(String filename) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[19].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "checkout", "--ours", filename}));
    }

    public static String[] getConflictedFiles() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        String result = ShortTypeHandling.castToString((Object)callSiteArray[20].call(callSiteArray[21].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "diff", "--name-only", "--diff-filter=U"}))));
        if (ScriptBytecodeAdapter.compareEqual((Object)result, (Object)"")) {
            return (String[])ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), String[].class);
        }
        return (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call((Object)result, (Object)"\n"), String[].class);
    }

    public static void createBranch(String branchName) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[23].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "branch", branchName}));
    }

    public static void createBranchAndTrackOrigin(String branchName) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[24].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "branch", branchName, "--track", new GStringImpl(new Object[]{branchName}, new String[]{"origin/", ""})}));
    }

    public static void createAndCheckout(String branchName) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[25].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "checkout", "-b", branchName}));
    }

    public static void checkoutExisting(String branchName) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[26].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "checkout", branchName}));
    }

    public static void add(File file) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[27].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "add", callSiteArray[28].call((Object)file)}));
    }

    public static void add(String fileName) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[29].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "add", fileName}));
    }

    public static void addAll() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[30].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "add", "-A"}));
    }

    public static void commit() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[31].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "commit", "--no-edit"}));
    }

    public static void commit(String commitMessage) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[32].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "commit", "-m", commitMessage}));
    }

    public static void mergeNoFf(String branchName, String msg) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        List cmd = ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "merge", "--no-edit", "--no-ff", branchName});
        if (ScriptBytecodeAdapter.compareNotEqual((Object)msg, null)) {
            cmd = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call((Object)cmd, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"-m", msg})), List.class);
        }
        callSiteArray[34].callStatic(GitHelper.class, (Object)cmd);
    }

    public static void mergeAbort() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[35].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "merge", "--abort"}));
    }

    public static void tagAnnotated(String tagName, String tagMessage) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[36].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "tag", "-a", tagName, "-m", tagMessage}));
    }

    public static String getBranchName() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[37].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "rev-parse", "--abbrev-ref", "HEAD"})));
    }

    public static void ensureMasterBranch() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[38].callStatic(GitHelper.class, (Object)"master", (Object)"You must be on branch 'master' to run this task");
        } else {
            GitHelper.ensureBranchMatches("master", "You must be on branch 'master' to run this task");
        }
    }

    public static void ensureDevBranch() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[39].callStatic(GitHelper.class, (Object)"develop", (Object)"You must be on branch 'develop' to run this task");
        } else {
            GitHelper.ensureBranchMatches("develop", "You must be on branch 'develop' to run this task");
        }
    }

    public static void ensureBranchMatches(String regex, String errMsg) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        callSiteArray[40].callStatic(GitHelper.class, ScriptBytecodeAdapter.bitwiseNegate((Object)regex), (Object)errMsg);
    }

    public static void ensureBranchMatches(Pattern regex, String errMsg) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        Object branchName = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            branchName = object = callSiteArray[41].callStatic(GitHelper.class);
        } else {
            String string = GitHelper.getBranchName();
            branchName = string;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)branchName, (Object)regex))) {
            throw (Throwable)callSiteArray[42].callConstructor(Exception.class, (Object)errMsg);
        }
    }

    public static int numCommitsBehind() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        String currentBranch = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[43].callStatic(GitHelper.class);
            currentBranch = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            currentBranch = string = GitHelper.getBranchName();
        }
        String isBehindOutput = ShortTypeHandling.castToString((Object)callSiteArray[44].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "log", "--oneline", new GStringImpl(new Object[]{currentBranch, currentBranch}, new String[]{"", "..origin/", ""})})));
        if (ScriptBytecodeAdapter.compareEqual((Object)isBehindOutput, (Object)"")) {
            return 0;
        }
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[45].callGetProperty(callSiteArray[46].call((Object)isBehindOutput, (Object)"\n")));
    }

    public static int numCommitsAhead() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        String currentBranch = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[47].callStatic(GitHelper.class);
            currentBranch = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            currentBranch = string = GitHelper.getBranchName();
        }
        String isAheadOutput = ShortTypeHandling.castToString((Object)callSiteArray[48].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "log", "--oneline", new GStringImpl(new Object[]{currentBranch, currentBranch}, new String[]{"origin/", "..", ""})})));
        if (ScriptBytecodeAdapter.compareEqual((Object)isAheadOutput, (Object)"")) {
            return 0;
        }
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[49].callGetProperty(callSiteArray[50].call((Object)isAheadOutput, (Object)"\n")));
    }

    public static void ensureNotBehind() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int numBehind = DefaultTypeTransformation.intUnbox((Object)callSiteArray[51].callStatic(GitHelper.class));
            if (numBehind > 0) {
                int numAhead = DefaultTypeTransformation.intUnbox((Object)callSiteArray[52].callStatic(GitHelper.class));
                String branch = ShortTypeHandling.castToString((Object)callSiteArray[53].callStatic(GitHelper.class));
                if (numAhead > 0) {
                    throw (Throwable)callSiteArray[54].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numAhead, numBehind, branch}, new String[]{"Unable to proceed: ", " is ", " commits ahead and ", " behind origin/", ""}));
                }
                throw (Throwable)callSiteArray[55].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numBehind, branch}, new String[]{"", " is ", " commits behind origin/", " and can be fast-forwarded. Consider running `git pull`"}));
            }
        } else {
            int numBehind = GitHelper.numCommitsBehind();
            if (numBehind > 0) {
                int numAhead = GitHelper.numCommitsAhead();
                String branch = GitHelper.getBranchName();
                if (numAhead > 0) {
                    throw (Throwable)callSiteArray[56].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numAhead, numBehind, branch}, new String[]{"Unable to proceed: ", " is ", " commits ahead and ", " behind origin/", ""}));
                }
                throw (Throwable)callSiteArray[57].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numBehind, branch}, new String[]{"", " is ", " commits behind origin/", " and can be fast-forwarded. Consider running `git pull`"}));
            }
        }
    }

    public static void ensureNotAhead() {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int numAhead = DefaultTypeTransformation.intUnbox((Object)callSiteArray[58].callStatic(GitHelper.class));
            if (numAhead > 0) {
                int numBehind = DefaultTypeTransformation.intUnbox((Object)callSiteArray[59].callStatic(GitHelper.class));
                String branch = ShortTypeHandling.castToString((Object)callSiteArray[60].callStatic(GitHelper.class));
                if (numBehind > 0) {
                    throw (Throwable)callSiteArray[61].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numAhead, numBehind, branch}, new String[]{"Unable to proceed: ", " is ", " commits ahead and ", " behind origin/", ""}));
                }
                throw (Throwable)callSiteArray[62].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numAhead, branch}, new String[]{"", " is ", " commits ahead of origin/", ". Consider running `git push`"}));
            }
        } else {
            int numAhead = GitHelper.numCommitsAhead();
            if (numAhead > 0) {
                int numBehind = GitHelper.numCommitsBehind();
                String branch = GitHelper.getBranchName();
                if (numBehind > 0) {
                    throw (Throwable)callSiteArray[63].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numAhead, numBehind, branch}, new String[]{"Unable to proceed: ", " is ", " commits ahead and ", " behind origin/", ""}));
                }
                throw (Throwable)callSiteArray[64].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{branch, numAhead, branch}, new String[]{"", " is ", " commits ahead of origin/", ". Consider running `git push`"}));
            }
        }
    }

    public static void ensureClean() {
        int n;
        int n2;
        int n3;
        int n4;
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        String nothingToCommitOutput = ShortTypeHandling.castToString((Object)callSiteArray[65].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "status", "--porcelain"})));
        int nothingToCommit = 0;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)nothingToCommitOutput, (Object)"");
            nothingToCommit = bl ? 1 : 0;
        } else {
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)nothingToCommitOutput, (Object)"");
            nothingToCommit = bl ? 1 : 0;
        }
        if (nothingToCommit == 0) {
            throw (Throwable)callSiteArray[66].callConstructor(Exception.class, (Object)"You must commit and push your changes before running this task");
        }
        String currentBranch = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[67].callStatic(GitHelper.class);
            currentBranch = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            currentBranch = string = GitHelper.getBranchName();
        }
        try {
            callSiteArray[68].callStatic(GitHelper.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "rev-parse", "--abbrev-ref", "--symbolic-full-name", "@{u}"}));
        }
        catch (Exception ignored) {
            throw (Throwable)callSiteArray[69].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{currentBranch, currentBranch}, new String[]{"Unable to find remote tracking branch for ", ". Try running `git push -u origin ", "`"}));
        }
        int numBehind = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[70].callStatic(GitHelper.class);
            numBehind = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            int n5;
            numBehind = n5 = GitHelper.numCommitsBehind();
        }
        int isBehind = 0;
        isBehind = !BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n4 = numBehind > 0 ? 1 : 0) : (n3 = numBehind > 0 ? 1 : 0);
        int numAhead = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[71].callStatic(GitHelper.class);
            numAhead = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            int n6;
            numAhead = n6 = GitHelper.numCommitsAhead();
        }
        int isAhead = 0;
        isAhead = !BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = numAhead > 0 ? 1 : 0) : (n = numAhead > 0 ? 1 : 0);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (isBehind != 0 || isAhead != 0) {
                List msgs = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                if (isAhead != 0) {
                    callSiteArray[72].call((Object)msgs, (Object)new GStringImpl(new Object[]{numAhead}, new String[]{"ahead by ", " commits"}));
                }
                if (isBehind != 0) {
                    callSiteArray[73].call((Object)msgs, (Object)new GStringImpl(new Object[]{numBehind}, new String[]{"behind by ", " commits"}));
                }
                String subMsgs = ShortTypeHandling.castToString((Object)callSiteArray[74].call((Object)msgs, (Object)" and "));
                String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{currentBranch, subMsgs}, new String[]{"Branch ", " must be synced with origin. You are ", ""}));
                throw (Throwable)callSiteArray[75].callConstructor(Exception.class, (Object)msg);
            }
        } else if (isBehind != 0 || isAhead != 0) {
            List msgs = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            if (isAhead != 0) {
                callSiteArray[76].call((Object)msgs, (Object)new GStringImpl(new Object[]{numAhead}, new String[]{"ahead by ", " commits"}));
            }
            if (isBehind != 0) {
                callSiteArray[77].call((Object)msgs, (Object)new GStringImpl(new Object[]{numBehind}, new String[]{"behind by ", " commits"}));
            }
            String subMsgs = ShortTypeHandling.castToString((Object)callSiteArray[78].call((Object)msgs, (Object)" and "));
            String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{currentBranch, subMsgs}, new String[]{"Branch ", " must be synced with origin. You are ", ""}));
            throw (Throwable)callSiteArray[79].callConstructor(Exception.class, (Object)msg);
        }
    }

    public static void mergeNoFf(String branchName) {
        CallSite[] callSiteArray = GitHelper.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            GitHelper.mergeNoFf(branchName, null);
        } else {
            GitHelper.mergeNoFf(branchName, null);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "endsWith";
        stringArray[1] = "substring";
        stringArray[2] = "minus";
        stringArray[3] = "length";
        stringArray[4] = "length";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "execute";
        stringArray[8] = "consumeProcessOutput";
        stringArray[9] = "waitForOrKill";
        stringArray[10] = "exitValue";
        stringArray[11] = "trimSuffix";
        stringArray[12] = "toString";
        stringArray[13] = "trimSuffix";
        stringArray[14] = "toString";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "runCmd";
        stringArray[18] = "runCmd";
        stringArray[19] = "runCmd";
        stringArray[20] = "trim";
        stringArray[21] = "runCmd";
        stringArray[22] = "split";
        stringArray[23] = "runCmd";
        stringArray[24] = "runCmd";
        stringArray[25] = "runCmd";
        stringArray[26] = "runCmd";
        stringArray[27] = "runCmd";
        stringArray[28] = "toString";
        stringArray[29] = "runCmd";
        stringArray[30] = "runCmd";
        stringArray[31] = "runCmd";
        stringArray[32] = "runCmd";
        stringArray[33] = "plus";
        stringArray[34] = "runCmd";
        stringArray[35] = "runCmd";
        stringArray[36] = "runCmd";
        stringArray[37] = "runCmd";
        stringArray[38] = "ensureBranchMatches";
        stringArray[39] = "ensureBranchMatches";
        stringArray[40] = "ensureBranchMatches";
        stringArray[41] = "getBranchName";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "getBranchName";
        stringArray[44] = "runCmd";
        stringArray[45] = "length";
        stringArray[46] = "split";
        stringArray[47] = "getBranchName";
        stringArray[48] = "runCmd";
        stringArray[49] = "length";
        stringArray[50] = "split";
        stringArray[51] = "numCommitsBehind";
        stringArray[52] = "numCommitsAhead";
        stringArray[53] = "getBranchName";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "numCommitsAhead";
        stringArray[59] = "numCommitsBehind";
        stringArray[60] = "getBranchName";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "runCmd";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "getBranchName";
        stringArray[68] = "runCmd";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "numCommitsBehind";
        stringArray[71] = "numCommitsAhead";
        stringArray[72] = "add";
        stringArray[73] = "add";
        stringArray[74] = "join";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "add";
        stringArray[77] = "add";
        stringArray[78] = "join";
        stringArray[79] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[80];
        GitHelper.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GitHelper.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GitHelper.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

