package com.nobleworks_software.gradle.gitflow

import org.gradle.api.tasks.TaskAction

class WriteVersionTask extends BaseGitflowTask {

    Version newVersion

    String commitMessageTemplate = 'bumping version to ${newVersion}'

    @TaskAction
    def run() {

        Version oldVersion = null
        try {
            // there may not be an existing version, e.g. in the
            // case of the setVersion task
            oldVersion = getVersion()
        }
        catch (Exception ignored) { /* do nothing */ }

        Version.changeProjectVersion(project, oldVersion, newVersion)
        GitHelper.addAll() // project may modify files in version-change event

        String commitMessage = commitMessageTemplate.replaceFirst(/\$\{?newVersion}?/, newVersion.toString())
        GitHelper.commit("gitflow-plugin: $commitMessage")

        project.logger.quiet("\nNEW VERSION: ${newVersion.toString()}")

        // Notify the user that we're not done yet. Provide them
        // with the appropriate git commands to run, depending
        // on how they'd like to proceed.
        String pushCommand = "git push origin develop"
        String undoCommand = "git reset --hard HEAD~1"
        writeFormattedMessage(
            'IMPORTANT:',
            "A new ${versionFile.toString()} file has been committed, but not",
            'pushed. You must manually push to origin if you approve of the change',
            '',
            "To push: `${pushCommand}`",
            "To undo: `${undoCommand}`"
        )
    }
}