package com.nobleworks_software.gradle.gitflow

import org.gradle.api.Project

class GitflowExtension {
    String releaseBranchNameTemplate = 'release/${version.toString()}'
    String hotfixBranchNameTemplate = 'hotfix/${version.toString()}'
    String tagNameTemplate = '${version.toString()}'
    String versionFile = 'version.properties'

    Version getVersion(Project project) {
        Version.loadProjectVersion(project)
    }

    def onVersionChange(Closure closure) {
        def project = closure.thisObject
        GitflowEvent evt = project.versionChangeEvent
        evt.addListener(closure)
    }

    def onMasterMerge(Closure closure) {
        def project = closure.thisObject
        GitflowEvent evt = project.masterMergeEvent
        evt.addListener(closure)
    }
}
