package com.nobleworks_software.gradle.gitflow

class GitflowEvent<TEvent> {

    String name

    private List<Closure> listeners = new ArrayList<Closure>()

    void addListener(Closure listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener)
        }
    }

    void removeListener(Closure listener) {
        listeners.remove(listener)
    }

    void fire(TEvent event) {
        listeners.each { it(event) }
    }

}