package com.nobleworks_software.gradle.gitflow

import org.gradle.api.DefaultTask

import groovy.text.SimpleTemplateEngine

class BaseGitflowTask extends DefaultTask {

    protected String computeVersionTemplate(Version version, String templateStr) {
        def engine = new SimpleTemplateEngine()
        def template = engine.createTemplate(templateStr)
        return template.make([
            'version': version
        ])
    }

    protected void writeFormattedMessage(String... lines) {
        project.logger.quiet(
            lines.collect({line -> "\n\t" + line}).join('')
        )
    }

    protected Version getVersion() {
        return Version.load(getVersionFile())
    }

    protected File getVersionFile() {
        new File(project.gitflow.versionFile)
    }
}