/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.gradle.xcc;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.Session;
import java.net.URI;

public class XccHelper
extends LoggingObject {
    private ContentSource contentSource;

    public XccHelper(String uri) {
        try {
            this.contentSource = ContentSourceFactory.newContentSource((URI)new URI(uri));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public XccHelper(String uri, SecurityOptions securityOptions) {
        try {
            this.contentSource = ContentSourceFactory.newContentSource((URI)new URI(uri), (SecurityOptions)securityOptions);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public XccHelper(ContentSource contentSource) {
        this.contentSource = contentSource;
    }

    public String executeXquery(String xquery) {
        try (Session session = this.contentSource.newSession();){
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Executing XQuery: " + xquery);
            }
            AdhocQuery q = session.newAdhocQuery(xquery);
            String string = session.submitRequest((Request)q).asString();
            return string;
        }
    }
}

