/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework.utils;

import com.liferay.gs.testFramework.utils.SeleniumCommonMethods;
import com.liferay.gs.testFramework.utils.SeleniumWaitMethods;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class LiferaySeleniumCommonMethods {
    private WebDriver _webDriver;
    private Actions actionBuilder;
    private final By addButtonLocator;
    private final By applicationHeadingLocator;
    private final By searchApplicationLocator;
    private SeleniumCommonMethods scm;

    public LiferaySeleniumCommonMethods(WebDriver webDriver) {
        this.actionBuilder = new Actions(this._webDriver);
        this.addButtonLocator = By.xpath((String)".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_addToggleId']");
        this.applicationHeadingLocator = By.xpath((String)".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_addApplicationHeading']");
        this.searchApplicationLocator = By.xpath((String)".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_searchApplication']");
        this.scm = new SeleniumCommonMethods(this._webDriver);
        this._webDriver = webDriver;
    }

    public void addPortletOnScreen(String portletName, String column) {
        this.clickOnAddButton();
        this.clickOnApplicationCategory();
        this.searchForPortletByName(portletName);
        this.dragAndDropPortletToColumn(portletName, column);
    }

    public void removeAllPorlets() {
        List portlets = this._webDriver.findElements(By.cssSelector((String)".portlet-layout .portlet"));
        for (WebElement portlet : portlets) {
            this.openPortletActionDropDown(portlet);
            this.clickOnPortletConfigurationMenu("Remove");
            this.scm.acceptBrowserDialog();
        }
    }

    public void removeAllSpecificPorlets(String partOfPortletID) {
        List portlets = this._webDriver.findElements(By.xpath((String)(".//*[contains(@id,'" + partOfPortletID + "')]")));
        for (WebElement portlet : portlets) {
            this.openPortletActionDropDown(portlet);
            this.clickOnPortletConfigurationMenu("Remove");
            this.scm.acceptBrowserDialog();
        }
    }

    private void dragAndDropPortletToColumn(String portletName, String column) {
        SeleniumWaitMethods.waitMediumTime();
        By searchApplicationResultLocator = By.xpath((String)(".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_portletCategory0']//*[contains (text(), '" + portletName + "')]"));
        By columnLocator = By.xpath((String)(".//*[@id='" + column + "']"));
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.visibilityOfElementLocated((By)searchApplicationResultLocator));
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.elementToBeClickable((By)searchApplicationResultLocator));
        WebElement element = this._webDriver.findElement(searchApplicationResultLocator);
        WebElement target = this._webDriver.findElement(columnLocator);
        new Actions(this._webDriver).dragAndDrop(element, target).perform();
        SeleniumWaitMethods.waitMediumTime();
    }

    private void searchForPortletByName(String portletName) {
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.visibilityOfElementLocated((By)this.searchApplicationLocator));
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.elementToBeClickable((By)this.searchApplicationLocator));
        this._webDriver.findElement(this.searchApplicationLocator).sendKeys(new CharSequence[]{portletName});
    }

    private void clickOnAddButton() {
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.visibilityOfElementLocated((By)this.addButtonLocator));
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.elementToBeClickable((By)this.addButtonLocator));
        this._webDriver.findElement(this.addButtonLocator).click();
    }

    private void clickOnApplicationCategory() {
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.visibilityOfElementLocated((By)this.applicationHeadingLocator));
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.elementToBeClickable((By)this.applicationHeadingLocator));
        By portletContentCategories = By.cssSelector((String)".add-content-menu .lfr-content-category");
        boolean isApplicationCategoriesDisplayed = this._webDriver.findElement(portletContentCategories).isDisplayed();
        if (!isApplicationCategoriesDisplayed) {
            SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.visibilityOfElementLocated((By)this.applicationHeadingLocator));
            SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.elementToBeClickable((By)this.applicationHeadingLocator));
            this._webDriver.findElement(this.applicationHeadingLocator).click();
        }
    }

    private void openPortletActionDropDown(WebElement portletElement) {
        WebElement configButton = portletElement.findElement(By.cssSelector((String)".lexicon-icon-ellipsis-v"));
        this.actionBuilder.moveToElement(configButton).pause(Duration.ofMillis(200L)).perform();
        configButton.click();
    }

    private void clickOnPortletConfigurationMenu(String title) {
        By dropDownMenu = By.cssSelector((String)".dropdown-menu");
        SeleniumWaitMethods.getWaitDriver(this._webDriver).until((Function)ExpectedConditions.visibilityOfElementLocated((By)dropDownMenu));
        WebElement dropDownMenuElement = this._webDriver.findElement(dropDownMenu);
        List elements = dropDownMenuElement.findElements(By.cssSelector((String)"li a.lfr-icon-item"));
        WebElement element = elements.stream().filter(el -> el.getText().trim().equals(title)).findFirst().get();
        element.click();
    }
}

