/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework;

import com.liferay.gs.testFramework.core.SeleniumReadPropertyKeys;
import com.liferay.gs.testFramework.driver.WebDriverManager;
import com.liferay.gs.testFramework.errorHandling.RetryTestExecution;
import com.liferay.gs.testFramework.errorHandling.ScreenshotTaker;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.rules.Timeout;
import org.junit.runner.Description;
import org.openqa.selenium.WebDriver;

public abstract class FunctionalTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);
    @Rule
    public RetryTestExecution retry;
    @Rule
    public TestWatcher writeScreenshotOnFailure = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            String fileName = description.getClassName() + "." + description.getMethodName() + ".png";
            FunctionalTest.this._screenshotTaker.save(fileName);
        }
    };
    private final ScreenshotTaker _screenshotTaker = new ScreenshotTaker();
    private final WebDriver _webDriver;
    private final WebDriverManager _webDriverManager = new WebDriverManager();

    public FunctionalTest() {
        this._webDriver = this._webDriverManager.get();
        this.retry = new RetryTestExecution(this._webDriver, SeleniumReadPropertyKeys.getNumberOfFailedTestsRetryTestExecution());
    }

    @After
    public void after() {
        this._screenshotTaker.take(this._webDriver);
    }

    @Before
    public void before() throws IOException {
    }

    public WebDriver getWebDriver() {
        return this._webDriver;
    }

    public void openURL(String url) {
        this.getWebDriver().get(url);
    }
}

