/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.rest.builder;

import com.liferay.gradle.plugins.rest.builder.BuildRESTTask;
import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class RESTBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_REST_TASK_NAME = "buildRest";
    public static final String CONFIGURATION_NAME = "restBuilder";

    public void apply(Project project) {
        Configuration restBuilderConfiguration = this._addConfigurationRESTBuilder(project);
        this._addTaskBuildREST(project);
        this._configureTasksBuildREST(project, restBuilderConfiguration);
    }

    private Configuration _addConfigurationRESTBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                RESTBuilderPlugin.this._addDependenciesRESTBuilder(project);
            }
        });
        configuration.setDescription("Configures Liferay REST Builder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesRESTBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.rest.builder", (String)"latest.release");
    }

    private BuildRESTTask _addTaskBuildREST(Project project) {
        BuildRESTTask buildRESTTask = (BuildRESTTask)GradleUtil.addTask((Project)project, (String)BUILD_REST_TASK_NAME, BuildRESTTask.class);
        buildRESTTask.setDescription("Runs Liferay REST Builder.");
        buildRESTTask.setGroup("build");
        buildRESTTask.setInputFile("rest.yaml");
        return buildRESTTask;
    }

    private void _configureTaskBuildRESTClasspath(BuildRESTTask buildRESTTask, Configuration restBuilderConfiguration) {
        buildRESTTask.setClasspath((FileCollection)restBuilderConfiguration);
    }

    private void _configureTasksBuildREST(Project project, final Configuration restBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildRESTTask.class, (Action)new Action<BuildRESTTask>(){

            public void execute(BuildRESTTask buildRESTTask) {
                RESTBuilderPlugin.this._configureTaskBuildRESTClasspath(buildRESTTask, restBuilderConfiguration);
            }
        });
    }
}

