/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.NodeExecutor;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class ExecuteNodeTask
extends DefaultTask {
    private final NodeExecutor _nodeExecutor = new NodeExecutor(this.getProject());
    private int _npmInstallRetries;
    private String _result;

    public ExecuteNodeTask() {
        this.dependsOn(new Object[]{"downloadNode"});
    }

    public ExecuteNodeTask args(Iterable<?> args) {
        this._nodeExecutor.args(args);
        return this;
    }

    public ExecuteNodeTask args(Object ... args) {
        this._nodeExecutor.args(args);
        return this;
    }

    public ExecuteNodeTask environment(Map<?, ?> environment) {
        this._nodeExecutor.environment(environment);
        return this;
    }

    public ExecuteNodeTask environment(Object key, Object value) {
        this._nodeExecutor.environment(key, value);
        return this;
    }

    @TaskAction
    public void executeNode() throws Exception {
        int npmInstallRetries = this.getNpmInstallRetries();
        NpmInstallTask npmInstallTask = GradleUtil.fetchTask(this.getProject(), "npmInstall", NpmInstallTask.class);
        if (this instanceof ExecutePackageManagerTask || npmInstallRetries <= 0 || npmInstallTask == null) {
            this._result = this._nodeExecutor.execute();
            return;
        }
        Logger logger = this.getLogger();
        for (int i = 1; i <= npmInstallRetries; ++i) {
            try {
                this._result = this._nodeExecutor.execute();
                break;
            }
            catch (IOException ioException) {
                if (i == npmInstallRetries) {
                    throw ioException;
                }
                if (logger.isWarnEnabled()) {
                    logger.warn(ioException.getMessage() + ". Running \"npm install\" again");
                }
                npmInstallTask.executeNpmInstall(true);
                continue;
            }
        }
    }

    @Input
    @Optional
    public List<Object> getArgs() {
        return this._nodeExecutor.getArgs();
    }

    @Input
    @Optional
    public String getCommand() {
        return this._nodeExecutor.getCommand();
    }

    @Input
    @Optional
    public Map<?, ?> getEnvironment() {
        return this._nodeExecutor.getEnvironment();
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getNodeDir() {
        File dir = this._nodeExecutor.getNodeDir();
        if (dir == null) {
            return null;
        }
        Project project = this.getProject();
        project.mkdir((Object)dir);
        return dir;
    }

    @Input
    public int getNpmInstallRetries() {
        return this._npmInstallRetries;
    }

    @Internal
    public String getResult() {
        if (this._result == null) {
            return "";
        }
        return this._result;
    }

    @Internal
    public File getWorkingDir() {
        return this._nodeExecutor.getWorkingDir();
    }

    @Input
    public boolean isInheritProxy() {
        return this._nodeExecutor.isInheritProxy();
    }

    @Input
    public boolean isUseGradleExec() {
        return this._nodeExecutor.isUseGradleExec();
    }

    public void setArgs(Iterable<?> args) {
        this._nodeExecutor.setArgs(args);
    }

    public void setArgs(Object ... args) {
        this._nodeExecutor.setArgs(args);
    }

    public void setCommand(Object command) {
        this._nodeExecutor.setCommand(command);
    }

    public void setEnvironment(Map<?, ?> environment) {
        this._nodeExecutor.setEnvironment(environment);
    }

    public void setInheritProxy(boolean inheritProxy) {
        this._nodeExecutor.setInheritProxy(inheritProxy);
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeExecutor.setNodeDir(nodeDir);
    }

    public void setNpmInstallRetries(int npmInstallRetries) {
        this._npmInstallRetries = npmInstallRetries;
    }

    public void setUseGradleExec(boolean useGradleExec) {
        this._nodeExecutor.setUseGradleExec(useGradleExec);
    }

    public void setWorkingDir(Object workingDir) {
        this._nodeExecutor.setWorkingDir(workingDir);
    }
}

