/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node;

import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.internal.util.NodePluginUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.util.GUtil;

public class NodeExtension {
    private static final Map<String, String> _npmVersions = new HashMap<String, String>(){
        {
            this.put("5.5.0", "3.3.12");
            this.put("5.6.0", "3.6.0");
            this.put("5.7.0", "3.6.0");
            this.put("5.7.1", "3.6.0");
            this.put("5.8.0", "3.7.3");
            this.put("5.9.0", "3.7.3");
            this.put("5.9.1", "3.7.3");
            this.put("5.10.0", "3.8.3");
            this.put("5.10.1", "3.8.3");
            this.put("5.11.0", "3.8.6");
            this.put("5.11.1", "3.8.6");
            this.put("5.12.0", "3.8.6");
            this.put("6.0.0", "3.8.6");
            this.put("6.1.0", "3.8.6");
            this.put("6.2.0", "3.8.9");
        }
    };
    private boolean _download;
    private boolean _global;
    private Object _nodeDir;
    private Object _nodeUrl;
    private Object _nodeVersion = "5.5.0";
    private final List<Object> _npmArgs = new ArrayList<Object>();
    private Object _npmUrl;
    private Object _npmVersion;
    private final Project _project;
    private Object _scriptFile;
    private Object _useNpm;
    private Object _yarnUrl;
    private Object _yarnVersion = "1.13.0";

    public NodeExtension(final Project project) {
        this._download = GradleUtil.getProperty((ExtensionAware)project, (String)"nodeDownload", (boolean)true);
        this._nodeDir = new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (!NodeExtension.this.isDownload()) {
                    return null;
                }
                Project curProject = project;
                if (NodeExtension.this.isGlobal()) {
                    curProject = curProject.getRootProject();
                }
                return new File(curProject.getBuildDir(), "node");
            }
        };
        this._nodeUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String nodeVersion = NodeExtension.this.getNodeVersion();
                if (Validator.isNull((String)nodeVersion)) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("http://nodejs.org/dist/v");
                sb.append(nodeVersion);
                if (OSDetector.isWindows() && _npmVersions.containsKey(nodeVersion)) {
                    sb.append("/win-x");
                    String bitmode = OSDetector.getBitmode();
                    if (bitmode.equals("32")) {
                        bitmode = "86";
                    }
                    sb.append(bitmode);
                    sb.append("/node.exe");
                } else {
                    sb.append("/node-v");
                    sb.append(nodeVersion);
                    sb.append('-');
                    String os = "linux";
                    if (OSDetector.isApple()) {
                        os = "darwin";
                    } else if (OSDetector.isWindows()) {
                        os = "win";
                    }
                    sb.append(os);
                    sb.append("-x");
                    String bitmode = OSDetector.getBitmode();
                    if (bitmode.equals("32")) {
                        bitmode = "86";
                    }
                    sb.append(bitmode);
                    if (OSDetector.isWindows()) {
                        sb.append(".zip");
                    } else {
                        sb.append(".tar.gz");
                    }
                }
                return sb.toString();
            }
        };
        this._npmUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String npmVersion = NodeExtension.this.getNpmVersion();
                if (OSDetector.isWindows() && Validator.isNull((String)npmVersion)) {
                    String nodeVersion = NodeExtension.this.getNodeVersion();
                    if (_npmVersions.containsKey(nodeVersion)) {
                        npmVersion = (String)_npmVersions.get(nodeVersion);
                    }
                }
                if (Validator.isNull((String)npmVersion)) {
                    return null;
                }
                return "https://registry.npmjs.org/npm/-/npm-" + npmVersion + ".tgz";
            }
        };
        this._project = project;
        this._scriptFile = new Callable<File>(){

            @Override
            public File call() throws Exception {
                File nodeDir = NodeExtension.this.getNodeDir();
                if (nodeDir == null) {
                    return null;
                }
                if (NodeExtension.this.isUseNpm()) {
                    File npmDir = NodePluginUtil.getNpmDir(nodeDir);
                    return new File(npmDir, "bin/npm-cli.js");
                }
                File yarnDir = NodePluginUtil.getYarnDir(nodeDir);
                return new File(yarnDir, "yarn-" + NodeExtension.this.getYarnVersion() + ".js");
            }
        };
        this._useNpm = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (FileUtil.exists((Project)project, (String)"package-lock.json")) {
                    return true;
                }
                return false;
            }
        };
        this._yarnUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String yarnVersion = NodeExtension.this.getYarnVersion();
                if (Validator.isNull((String)yarnVersion)) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("https://github.com/yarnpkg/yarn/releases/download/v");
                sb.append(yarnVersion);
                sb.append("/yarn-");
                sb.append(yarnVersion);
                sb.append(".js");
                return sb.toString();
            }
        };
    }

    public File getNodeDir() {
        return GradleUtil.toFile(this._project, this._nodeDir);
    }

    public String getNodeUrl() {
        return GradleUtil.toString((Object)this._nodeUrl);
    }

    public String getNodeVersion() {
        return GradleUtil.toString((Object)this._nodeVersion);
    }

    public List<String> getNpmArgs() {
        return GradleUtil.toStringList(this._npmArgs);
    }

    public String getNpmUrl() {
        return GradleUtil.toString((Object)this._npmUrl);
    }

    public String getNpmVersion() {
        return GradleUtil.toString((Object)this._npmVersion);
    }

    public File getScriptFile() {
        return GradleUtil.toFile(this._project, this._scriptFile);
    }

    public String getYarnUrl() {
        return GradleUtil.toString((Object)this._yarnUrl);
    }

    public String getYarnVersion() {
        return GradleUtil.toString((Object)this._yarnVersion);
    }

    public boolean isDownload() {
        return this._download;
    }

    public boolean isGlobal() {
        return this._global;
    }

    public boolean isUseNpm() {
        return GradleUtil.toBoolean(this._useNpm);
    }

    public NodeExtension npmArgs(Iterable<?> npmArgs) {
        GUtil.addToCollection(this._npmArgs, (Iterable[])new Iterable[]{npmArgs});
        return this;
    }

    public NodeExtension npmArgs(Object ... npmArgs) {
        return this.npmArgs(Arrays.asList(npmArgs));
    }

    public void setDownload(boolean download) {
        this._download = download;
    }

    public void setGlobal(boolean global) {
        this._global = global;
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeDir = nodeDir;
    }

    public void setNodeUrl(Object nodeUrl) {
        this._nodeUrl = nodeUrl;
    }

    public void setNodeVersion(Object nodeVersion) {
        this._nodeVersion = nodeVersion;
    }

    public void setNpmArgs(Iterable<?> npmArgs) {
        this._npmArgs.clear();
        this.npmArgs(npmArgs);
    }

    public void setNpmArgs(Object ... npmArgs) {
        this.setNpmArgs(Arrays.asList(npmArgs));
    }

    public void setNpmUrl(Object npmUrl) {
        this._npmUrl = npmUrl;
    }

    public void setNpmVersion(Object npmVersion) {
        this._npmVersion = npmVersion;
    }

    public void setScriptFile(Object scriptFile) {
        this._scriptFile = scriptFile;
    }

    public void setUseNpm(Object useNpm) {
        this._useNpm = useNpm;
    }

    public void setYarnUrl(Object yarnUrl) {
        this._yarnUrl = yarnUrl;
    }

    public void setYarnVersion(Object yarnVersion) {
        this._yarnVersion = yarnVersion;
    }
}

