/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.node.tasks;

import com.liferay.gradle.plugins.node.internal.NodeExecutor;
import com.liferay.gradle.plugins.node.internal.util.FileUtil;
import com.liferay.gradle.plugins.node.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.internal.util.NodePluginUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class DownloadNodeTask
extends DefaultTask {
    private final NodeExecutor _nodeExecutor = new NodeExecutor(this.getProject());
    private Object _nodeUrl;
    private Object _npmUrl;

    public DownloadNodeTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File nodeDir = DownloadNodeTask.this.getNodeDir();
                return nodeDir == null || !nodeDir.exists();
            }
        });
    }

    @TaskAction
    public void downloadNode() throws IOException {
        final File nodeDir = this.getNodeDir();
        final Project project = this.getProject();
        final File nodeFile = this._download(this.getNodeUrl(), null);
        project.delete(new Object[]{nodeDir});
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
                String nodeFileName = nodeFile.getName();
                if (nodeFileName.endsWith(".zip")) {
                    copySpec.from(new Object[]{project.zipTree((Object)nodeFile)});
                } else {
                    copySpec.from(new Object[]{project.tarTree((Object)nodeFile)});
                }
                copySpec.into((Object)nodeDir);
                copySpec.setIncludeEmptyDirs(false);
            }
        });
        String npmUrl = this.getNpmUrl();
        if (Validator.isNotNull((String)npmUrl)) {
            final File npmFile = this._download(npmUrl, null);
            final File npmDir = NodePluginUtil.getNpmDir(nodeDir);
            project.delete(new Object[]{npmDir});
            project.copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.eachFile((Action)new StripPathSegmentsAction(1));
                    copySpec.from(new Object[]{project.tarTree((Object)npmFile)});
                    copySpec.into((Object)npmDir);
                    copySpec.setIncludeEmptyDirs(false);
                }
            });
        }
    }

    @OutputDirectory
    public File getNodeDir() {
        return this._nodeExecutor.getNodeDir();
    }

    @Input
    public String getNodeUrl() {
        return GradleUtil.toString((Object)this._nodeUrl);
    }

    @Input
    @Optional
    public String getNpmUrl() {
        return GradleUtil.toString((Object)this._npmUrl);
    }

    public void setNodeDir(Object nodeDir) {
        this._nodeExecutor.setNodeDir(nodeDir);
    }

    public void setNodeUrl(Object nodeUrl) {
        this._nodeUrl = nodeUrl;
    }

    public void setNpmUrl(Object npmUrl) {
        this._npmUrl = npmUrl;
    }

    private File _download(String url, File destinationFile) throws IOException {
        String protocol = url.substring(0, url.indexOf(58));
        String proxyPassword = System.getProperty(protocol + ".proxyPassword");
        String proxyUser = System.getProperty(protocol + ".proxyUser");
        if (Validator.isNotNull((String)proxyPassword) && Validator.isNotNull((String)proxyUser)) {
            Project project = this.getProject();
            String nonProxyHosts = System.getProperty(protocol + ".nonProxyHosts");
            String proxyHost = System.getProperty(protocol + ".proxyHost");
            String proxyPort = System.getProperty(protocol + ".proxyPort");
            AntBuilder antBuilder = project.getAnt();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("nonproxyhosts", nonProxyHosts);
            args.put("proxyhost", proxyHost);
            args.put("proxypassword", proxyPassword);
            args.put("proxyport", proxyPort);
            args.put("proxyuser", proxyUser);
            antBuilder.invokeMethod("setproxy", args);
        }
        return FileUtil.get((Project)this.getProject(), (String)url, (File)destinationFile);
    }
}

