/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.plugins.jasper.jspc.CompileJSPUtil;
import com.liferay.gradle.plugins.jasper.jspc.JakartaTransformerJDTCompiler;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CompileJSPTask
extends DefaultTask {
    private FileCollection _compileJspClasspath;
    private Object _destinationDir;
    private FileCollection _jspCClasspath;
    private boolean _poolingEnabled;
    private Object _webAppDir;

    @TaskAction
    public void compileJSP() {
        FileCollection compileJspClasspath = this.getCompileJspClasspath();
        FileCollection jspCClasspath = this.getJspCClasspath();
        Logger logger = this.getLogger();
        if (compileJspClasspath == null || compileJspClasspath.isEmpty()) {
            if (logger.isInfoEnabled()) {
                logger.info("Compiling JSP with standard class path");
            }
            CompileJSPUtil.compileJSP(this._getCompilerClassName(), this._getCompleteArgs(), jspCClasspath.getAsPath());
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Compiling JSP with custom class path");
        }
        Set files = compileJspClasspath.getFiles();
        Stream stream = files.stream();
        URL[] urls = (URL[])stream.map(File::toURI).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new GradleException(malformedURLException.getMessage(), (Throwable)malformedURLException);
            }
        }).toArray(URL[]::new);
        try (URLClassLoader urlClassLoader = new URLClassLoader(urls, null);){
            Class<?> compileJSPUtilClass = Class.forName(CompileJSPUtil.class.getName(), true, urlClassLoader);
            Method compileJSPMethod = compileJSPUtilClass.getMethod("compileJSP", String.class, String[].class, String.class);
            compileJSPMethod.invoke(null, this._getCompilerClassName(), this._getCompleteArgs(), jspCClasspath.getAsPath());
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    @Classpath
    @Optional
    public FileCollection getCompileJspClasspath() {
        return this._compileJspClasspath;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    @Classpath
    public FileCollection getJspCClasspath() {
        return this._jspCClasspath;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getJSPFiles() {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", this.getWebAppDir());
        ArrayList<String> excludes = new ArrayList<String>(2);
        excludes.add("**/custom_jsps/**/*");
        excludes.add("**/dependencies/**/*");
        args.put("excludes", excludes);
        args.put("include", "**/*.jsp");
        return project.fileTree(args);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getWebAppDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._webAppDir);
    }

    @Input
    public boolean isPoolingEnabled() {
        return this._poolingEnabled;
    }

    public void setCompileJspClasspath(FileCollection compileJspClasspath) {
        this._compileJspClasspath = compileJspClasspath;
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setJspCClasspath(FileCollection jspCClasspath) {
        this._jspCClasspath = jspCClasspath;
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this._poolingEnabled = poolingEnabled;
    }

    public void setWebAppDir(Object webAppDir) {
        this._webAppDir = webAppDir;
    }

    private String _getCompilerClassName() {
        JavaVersion javaVersion = JavaVersion.current();
        if (!Boolean.getBoolean("build.jakarta.transformer.enabled") || javaVersion.compareTo((Enum)JavaVersion.VERSION_17) < 0) {
            return null;
        }
        String dirNames = System.getProperty("build.jakarta.transformer.include.dirs");
        if (Validator.isNull((String)dirNames)) {
            return null;
        }
        Project project = this.getProject();
        File portalModulesDir = project.getRootDir();
        Path portalModulesPath = portalModulesDir.toPath();
        File projectDir = project.getProjectDir();
        Path projectPath = projectDir.toPath();
        for (String dirName : dirNames.split(",")) {
            if (!projectPath.startsWith(portalModulesPath.resolve(dirName))) continue;
            return JakartaTransformerJDTCompiler.class.getName();
        }
        return null;
    }

    private String[] _getCompleteArgs() {
        return new String[]{"-d", FileUtil.getAbsolutePath((File)this.getDestinationDir()), "-no-strictQuoteEscaping", "-poolingEnabled", String.valueOf(this.isPoolingEnabled()), "-webapp", FileUtil.getAbsolutePath((File)this.getWebAppDir())};
    }
}

