/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;

@CacheableTask
public class CompileJSPTask
extends JavaExec {
    private Object _destinationDir;
    private FileCollection _jspCClasspath;
    private Object _webAppDir;

    public void exec() {
        FileCollection classpath = this.getClasspath();
        FileCollection jspCClasspath = this.getJspCClasspath();
        try {
            CompileJSPTask._runWithClassPath(classpath.getAsPath() + File.pathSeparator + jspCClasspath.getAsPath(), this._getCompleteArgs());
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getJspCClasspath() {
        return this._jspCClasspath;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileCollection getJSPFiles() {
        Project project = this.getProject();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", this.getWebAppDir());
        ArrayList<String> excludes = new ArrayList<String>(2);
        excludes.add("**/custom_jsps/**/*");
        excludes.add("**/dependencies/**/*");
        args.put("excludes", excludes);
        args.put("include", "**/*.jsp");
        return project.fileTree(args);
    }

    public File getWebAppDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._webAppDir);
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setJspCClasspath(FileCollection jspCClasspath) {
        this._jspCClasspath = jspCClasspath;
    }

    public JavaExec setStandardOutput(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public void setWebAppDir(Object webAppDir) {
        this._webAppDir = webAppDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _runWithClassPath(String classpath, String[] args) throws Exception {
        classpath = System.getProperty("java.class.path") + File.pathSeparator + classpath;
        String[] files = classpath.split(File.pathSeparator);
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = new File(files[i]);
            URI uri = file.toURI();
            urls[i] = uri.toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(urls, null);
        Class<?> jspCClass = classLoader.loadClass("org.apache.jasper.JspC");
        Object jspC = jspCClass.newInstance();
        Method setArgsMethod = jspCClass.getMethod("setArgs", String[].class);
        setArgsMethod.invoke(jspC, new Object[]{args});
        Method setClassPathMethod = jspCClass.getMethod("setClassPath", String.class);
        setClassPathMethod.invoke(jspC, classpath);
        Method executeMethod = jspCClass.getMethod("execute", new Class[0]);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(classLoader);
        try {
            executeMethod.invoke(jspC, new Object[0]);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    private String[] _getCompleteArgs() {
        return new String[]{"-d", FileUtil.getAbsolutePath((File)this.getDestinationDir()), "-webapp", FileUtil.getAbsolutePath((File)this.getWebAppDir())};
    }
}

