/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.jasper.jspc;

import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.War;
import org.gradle.api.tasks.compile.JavaCompile;

public class JspCPlugin
implements Plugin<Project> {
    public static final String COMPILE_JSP_TASK_NAME = "compileJSP";
    public static final String CONFIGURATION_NAME = "jspC";
    public static final String GENERATE_JSP_JAVA_TASK_NAME = "generateJSPJava";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        Configuration jspCConfiguration = this._addConfigurationJspC(project);
        CompileJSPTask generateJSPJavaTask = this._addTaskGenerateJSPJava(project, jspCConfiguration);
        final JavaCompile compileJSPTask = this._addTaskCompileJSP(generateJSPJavaTask, jspCConfiguration);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JspCPlugin.this._addDependenciesJspC(project);
                JspCPlugin.this._configureTaskCompileJSP(compileJSPTask);
            }
        });
    }

    private Configuration _addConfigurationJspC(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures the classpath of the JSP compilation tasks.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesJspC(Project project) {
        ModuleDependency moduleDependency = (ModuleDependency)GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.servlet.jsp.compiler", (String)"latest.release");
        moduleDependency.exclude(Collections.singletonMap("group", "com.liferay.portal"));
        DependencyHandler dependencyHandler = project.getDependencies();
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJava");
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{javaCompile});
        configurableFileCollection.builtBy(new Object[]{javaCompile});
        dependencyHandler.add(CONFIGURATION_NAME, (Object)configurableFileCollection);
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        configurableFileCollection = project.files(new Object[]{copy});
        configurableFileCollection.builtBy(new Object[]{copy});
        dependencyHandler.add(CONFIGURATION_NAME, (Object)configurableFileCollection);
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        dependencyHandler.add(CONFIGURATION_NAME, (Object)sourceSet.getCompileClasspath());
    }

    private JavaCompile _addTaskCompileJSP(CompileJSPTask generateJSPJavaTask, Configuration jspCConfiguration) {
        final JavaCompile javaCompile = (JavaCompile)GradleUtil.addTask((Project)generateJSPJavaTask.getProject(), (String)COMPILE_JSP_TASK_NAME, JavaCompile.class);
        javaCompile.setClasspath((FileCollection)jspCConfiguration);
        javaCompile.setDescription("Compile JSP files to check for errors.");
        javaCompile.setGroup("verification");
        javaCompile.setSource((Object)generateJSPJavaTask.getOutputs());
        Project project = generateJSPJavaTask.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                JspCPlugin.this._configureTaskCompileJSPForWarPlugin(javaCompile);
            }
        });
        return javaCompile;
    }

    private CompileJSPTask _addTaskGenerateJSPJava(Project project, Configuration jspCConfiguration) {
        final CompileJSPTask compileJSPTask = (CompileJSPTask)GradleUtil.addTask((Project)project, (String)GENERATE_JSP_JAVA_TASK_NAME, CompileJSPTask.class);
        compileJSPTask.setDescription("Compiles JSP files to Java source files to check for errors.");
        compileJSPTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Project project = compileJSPTask.getProject();
                return new File(project.getBuildDir(), "jspc");
            }
        });
        compileJSPTask.setJspCClasspath((FileCollection)jspCConfiguration);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                JspCPlugin.this._configureTaskGenerateJSPJavaForWarPlugin(compileJSPTask);
            }
        });
        return compileJSPTask;
    }

    private void _configureTaskCompileJSP(JavaCompile compileJSPTask) {
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)compileJSPTask.getProject(), (String)"compileJava");
        compileJSPTask.dependsOn(new Object[]{javaCompile});
        if (compileJSPTask.getDestinationDir() == null) {
            compileJSPTask.setDestinationDir(compileJSPTask.getTemporaryDir());
        }
    }

    private void _configureTaskCompileJSPForWarPlugin(JavaCompile compileJSPTask) {
        War war = (War)GradleUtil.getTask((Project)compileJSPTask.getProject(), (String)"war");
        war.dependsOn(new Object[]{compileJSPTask});
        war.from(new Object[]{compileJSPTask});
    }

    private void _configureTaskGenerateJSPJavaForWarPlugin(final CompileJSPTask compileJSPTask) {
        compileJSPTask.setWebAppDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)compileJSPTask.getProject(), WarPluginConvention.class);
                return warPluginConvention.getWebAppDir();
            }
        });
    }
}

