/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.app.docker.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.process.ExecSpec;

public class ExecStandardOutputCallable
implements Callable<String> {
    private final Object[] _commandLine;
    private final Map<String, ?> _environment;
    private final Project _project;

    public ExecStandardOutputCallable(Project project, Map<String, ?> environment, Object ... commandLine) {
        this._project = project;
        this._environment = environment;
        this._commandLine = commandLine;
    }

    public ExecStandardOutputCallable(Project project, Object ... commandLine) {
        this(project, null, commandLine);
    }

    @Override
    public String call() throws Exception {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this._project.exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    if (ExecStandardOutputCallable.this._environment != null) {
                        execSpec.environment(ExecStandardOutputCallable.this._environment);
                    }
                    execSpec.setCommandLine(ExecStandardOutputCallable.this._commandLine);
                    execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
                }
            });
            String result = byteArrayOutputStream.toString();
            return result.trim();
        }
        catch (GradleException gradleException) {
            Logger logger = this._project.getLogger();
            logger.error("Unable to execute {}", (Object)this._commandLine, (Object)gradleException);
            return null;
        }
    }
}

