/*
 * Decompiled with CFR 0.152.
 */
package com.lazan.dependency.export;

import com.lazan.dependency.export.ModelResolveListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class ModelResolverImpl
implements ModelResolver {
    private final String taskName;
    private final Project project;
    private final ModelResolveListener listener;
    private final AtomicInteger configurationCount = new AtomicInteger(0);

    public ModelResolverImpl(String taskName, Project project, ModelResolveListener listener) {
        this.taskName = taskName;
        this.project = project;
        this.listener = listener;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        String configName = String.format("%s%s", this.taskName, this.configurationCount.getAndIncrement());
        Configuration config = (Configuration)this.project.getConfigurations().create(configName);
        config.setTransitive(false);
        String depNotation = String.format("%s:%s:%s@pom", groupId, artifactId, version);
        org.gradle.api.artifacts.Dependency dependency = this.project.getDependencies().create((Object)depNotation);
        config.getDependencies().add((Object)dependency);
        final File pomXml = config.getSingleFile();
        this.listener.onResolveModel(groupId, artifactId, version, pomXml);
        return new ModelSource(){

            public InputStream getInputStream() throws IOException {
                return new FileInputStream(pomXml);
            }

            public String getLocation() {
                return pomXml.getAbsolutePath();
            }
        };
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
    }

    public ModelResolver newCopy() {
        return this;
    }
}

