/*
 * Decompiled with CFR 0.152.
 */
package com.innobead.grpc.task;

import com.innobead.grpc.GrpcPluginExtension;
import com.innobead.grpc.package$;
import com.innobead.grpc.task.GrpcDownloadTask;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u0017\t\u0001rI\u001d9d\u000f\u0016tWM]1uKR\u000b7o\u001b\u0006\u0003\u0007\u0011\tA\u0001^1tW*\u0011QAB\u0001\u0005OJ\u00048M\u0003\u0002\b\u0011\u0005A\u0011N\u001c8pE\u0016\fGMC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e)5\taB\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012AB4sC\u0012dWMC\u0001\u0014\u0003\ry'oZ\u0005\u0003+9\u00111\u0002R3gCVdG\u000fV1tW\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0015\u0003-q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\r%t'.Z2u\u0015\u0005\t\u0013!\u00026bm\u0006D\u0018BA\u0012\u001f\u0005\u0019IeN[3di\"9Q\u0005\u0001b\u0001\n\u00031\u0013!C3yi\u0016t7/[8o+\u00059\u0003C\u0001\u0015*\u001b\u0005!\u0011B\u0001\u0016\u0005\u0005M9%\u000f]2QYV<\u0017N\\#yi\u0016t7/[8o\u0011\u0019a\u0003\u0001)A\u0005O\u0005QQ\r\u001f;f]NLwN\u001c\u0011\t\u000f9\u0002!\u0019!C\u0001_\u0005Q\u0001O]8u_\u000e\u0004\u0016\r\u001e5\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\u0005%|'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oI\u0012AAR5mK\"1\u0011\b\u0001Q\u0001\nA\n1\u0002\u001d:pi>\u001c\u0007+\u0019;iA!91\b\u0001b\u0001\n\u0003y\u0013\u0001\u00039s_R|G)\u001b:\t\ru\u0002\u0001\u0015!\u00031\u0003%\u0001(o\u001c;p\t&\u0014\b\u0005C\u0004@\u0001\t\u0007I\u0011A\u0018\u0002\u0019\u001d,g.\u001a:bi\u0016$G)\u001b:\t\r\u0005\u0003\u0001\u0015!\u00031\u000359WM\\3sCR,G\rR5sA!)1\t\u0001C\u0001\t\u0006\u0019!/\u001e8\u0015\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013A!\u00168ji\"\u0012!\t\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f:\tQ\u0001^1tWNL!!\u0015(\u0003\u0015Q\u000b7o[!di&|g\u000e")
public class GrpcGenerateTask
extends DefaultTask {
    private final GrpcPluginExtension extension;
    private final File protocPath;
    private final File protoDir;
    private final File generatedDir;

    public GrpcPluginExtension extension() {
        return this.extension;
    }

    public File protocPath() {
        return this.protocPath;
    }

    public File protoDir() {
        return this.protoDir;
    }

    public File generatedDir() {
        return this.generatedDir;
    }

    @TaskAction
    public void run() {
        block1: {
            if (!this.extension().goEnabled()) break block1;
            better.files.File qual$1 = better.files.package$.MODULE$.StringOps(package$.MODULE$.FileExtension(this.extension().protoDir()).ensure().getCanonicalPath()).toFile();
            Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GrpcGenerateTask.$anonfun$run$1(f));
            Seq x$4 = qual$1.collectChildren$default$2((Function1)x$3);
            Iterator protoFiles = qual$1.collectChildren((Function1)x$3, x$4);
            Map goPackageFilePaths = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            protoFiles.foreach((Function1 & Serializable & scala.Serializable)protoFile -> {
                GrpcGenerateTask.$anonfun$run$3(this, goPackageFilePaths, protoFile);
                return BoxedUnit.UNIT;
            });
            if (goPackageFilePaths.isEmpty()) {
                this.getLogger().lifecycle("No proto packages found");
                return;
            }
            goPackageFilePaths.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String packageName = (String)tuple2._1();
                ListBuffer filePaths = (ListBuffer)tuple2._2();
                String command = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(256).append(this.protocPath()).append("\n             |-I").append(this.extension().protoDir()).append("\n             |-I").append(this.extension().goPath()).append("/src\n             |-I").append(this.extension().goPath()).append("/src/github.com/grpc-ecosystem/grpc-gateway/third_party/googleapis\n             |--go_out=plugins=grpc:").append(this.generatedDir()).append(" ").append(filePaths.mkString(" ")).append("\n             |--grpc-gateway_out=logtostderr=true:").append(this.generatedDir()).append("\n             |--swagger_out=logtostderr=true:").append(this.generatedDir()).toString())).stripMargin();
                this.getLogger().lifecycle(new StringBuilder(51).append("Running command to generate code for '").append(packageName).append("' package ...").toString());
                this.getLogger().debug(String.valueOf(command), (Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing()));
                ExecResult execResult = this.getProject().exec(spec -> {
                    spec.setCommandLine((Object[])command.split("\\s+"));
                    spec.setEnvironment((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(package$.MODULE$.goEnvVars(this.extension())).asJava());
                }).rethrowFailure();
                return execResult;
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$run$1(better.files.File f) {
        if (!f.isRegularFile(f.isRegularFile$default$1())) return false;
        Object object = f.extension().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String string = ".proto";
        if (object != null) {
            if (!object.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$run$3(GrpcGenerateTask $this, Map goPackageFilePaths$1, better.files.File protoFile) {
        $this.getLogger().lifecycle(protoFile.pathAsString());
        protoFile.bufferedReader(protoFile.bufferedReader$default$1()).foreach((Function1 & Serializable & scala.Serializable)reader -> {
            Boolean bl;
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)reader.lines().anyMatch(line -> {
                    boolean bl;
                    Option option = new StringOps(Predef$.MODULE$.augmentString("package (\\S+);")).r().findFirstMatchIn((CharSequence)line);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Regex.Match matchResult = (Regex.Match)some.value();
                        String packageName = matchResult.group(1);
                        Object object = goPackageFilePaths$1.contains((Object)packageName) ? ((ListBuffer)goPackageFilePaths$1.apply((Object)packageName)).$plus$eq((Object)protoFile.pathAsString()) : goPackageFilePaths$1.put((Object)packageName, (Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{protoFile.pathAsString()})));
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }));
            }
            catch (Throwable e) {
                $this.getLogger().error(new StringBuilder(8).append("Error!! ").append(e).toString(), e);
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
    }

    @Inject
    public GrpcGenerateTask() {
        this.setGroup("grpc");
        this.setDescription("Generate code from protobuf schemas");
        this.dependsOn(new Object[]{package$.MODULE$.taskName(GrpcDownloadTask.class)});
        this.extension = (GrpcPluginExtension)package$.MODULE$.getExtension(this.getProject(), "grpc");
        this.protocPath = new File(this.extension().protocDir(), ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bin", "protoc"}))).mkString(File.separator));
        this.protoDir = package$.MODULE$.KotlinExtension(this.extension().protocDir()).also((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.mkdirs();
            return BoxedUnit.UNIT;
        });
        this.generatedDir = package$.MODULE$.KotlinExtension(this.extension().generatedDir()).also((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.mkdirs();
            return BoxedUnit.UNIT;
        });
    }
}

