/*
 * Decompiled with CFR 0.152.
 */
package com.innobead.grpc.task;

import com.innobead.grpc.GrpcPluginExtension;
import com.innobead.grpc.package$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.attribute.PosixFilePermission;
import javax.inject.Inject;
import jodd.io.ZipUtil;
import okhttp3.Request;
import okhttp3.Response;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.lang3.SystemUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u0017\t\u0001rI\u001d9d\t><h\u000e\\8bIR\u000b7o\u001b\u0006\u0003\u0007\u0011\tA\u0001^1tW*\u0011QAB\u0001\u0005OJ\u00048M\u0003\u0002\b\u0011\u0005A\u0011N\u001c8pE\u0016\fGMC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e)5\taB\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012AB4sC\u0012dWMC\u0001\u0014\u0003\ry'oZ\u0005\u0003+9\u00111\u0002R3gCVdG\u000fV1tW\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005e\u0011cB\u0001\u000e!!\tYb$D\u0001\u001d\u0015\ti\"\"\u0001\u0004=e>|GO\u0010\u0006\u0002?\u0005)1oY1mC&\u0011\u0011EH\u0001\u0007!J,G-\u001a4\n\u0005\r\"#AB*ue&twM\u0003\u0002\"=!)a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001\u000b\u0016\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000b])\u0003\u0019\u0001\r)\u0005\u0015b\u0003CA\u00173\u001b\u0005q#BA\u00181\u0003\u0019IgN[3di*\t\u0011'A\u0003kCZ\f\u00070\u0003\u00024]\t1\u0011J\u001c6fGRDq!\u000e\u0001C\u0002\u0013\u0005a'A\u0005fqR,gn]5p]V\tq\u0007\u0005\u00029s5\tA!\u0003\u0002;\t\t\u0019rI\u001d9d!2,x-\u001b8FqR,gn]5p]\"1A\b\u0001Q\u0001\n]\n!\"\u001a=uK:\u001c\u0018n\u001c8!\u0011\u001dq\u0004A1A\u0005\u0002}\nq\u0002\u001d:pi>\u0014V\r\\3bg\u0016,&\u000f\\\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005Y\u0006twMC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\r\u0012\u0005B\u0002%\u0001A\u0003%\u0001)\u0001\tqe>$xNU3mK\u0006\u001cX-\u0016:mA!9!\n\u0001a\u0001\n\u0003Y\u0015A\u00069s_R|7\rR8x]2|\u0017\rZ!si&4\u0017m\u0019;\u0016\u00031\u00032!\u0014(Q\u001b\u0005q\u0012BA(\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bR\u0001\u0003S>L!!\u0016*\u0003\t\u0019KG.\u001a\u0005\b/\u0002\u0001\r\u0011\"\u0001Y\u0003i\u0001(o\u001c;pG\u0012{wO\u001c7pC\u0012\f%\u000f^5gC\u000e$x\fJ3r)\tIF\f\u0005\u0002N5&\u00111L\b\u0002\u0005+:LG\u000fC\u0004^-\u0006\u0005\t\u0019\u0001'\u0002\u0007a$\u0013\u0007\u0003\u0004`\u0001\u0001\u0006K\u0001T\u0001\u0018aJ|Go\\2E_^tGn\\1e\u0003J$\u0018NZ1di\u0002Bq!\u0019\u0001C\u0002\u0013\u0005!-\u0001\u0006qe>$xn\u0019)bi\",\u0012\u0001\u0015\u0005\u0007I\u0002\u0001\u000b\u0011\u0002)\u0002\u0017A\u0014x\u000e^8d!\u0006$\b\u000e\t\u0005\u0006M\u0002!\taZ\u0001\u0004eVtG#A-)\u0005\u0015L\u0007C\u00016n\u001b\u0005Y'B\u00017\u000f\u0003\u0015!\u0018m]6t\u0013\tq7N\u0001\u0006UCN\\\u0017i\u0019;j_:DQ\u0001\u001d\u0001\u0005\u0002E\fA\u0002Z8x]2|\u0017\r\u001a$jY\u0016$\"\u0001\u0014:\t\u000bM|\u0007\u0019\u0001\r\u0002\u0007U\u0014H\u000e")
public class GrpcDownloadTask
extends DefaultTask {
    private final String version;
    private final GrpcPluginExtension extension;
    private final String protoReleaseUrl;
    private Option<File> protocDownloadArtifact;
    private final File protocPath;

    public GrpcPluginExtension extension() {
        return this.extension;
    }

    public String protoReleaseUrl() {
        return this.protoReleaseUrl;
    }

    public Option<File> protocDownloadArtifact() {
        return this.protocDownloadArtifact;
    }

    public void protocDownloadArtifact_$eq(Option<File> x$1) {
        this.protocDownloadArtifact = x$1;
    }

    public File protocPath() {
        return this.protocPath;
    }

    @TaskAction
    public void run() {
        block10: {
            Tuple2 tuple2;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_MAC_OSX) {
                tuple2 = new Tuple2((Object)"osx", (Object)SystemUtils.OS_ARCH);
            } else if (SystemUtils.IS_OS_LINUX) {
                tuple2 = new Tuple2((Object)"linux", (Object)SystemUtils.OS_ARCH);
            } else {
                throw new GradleException(new StringBuilder(58).append("Failed to download protoc, due to unsupported platform (").append(SystemUtils.OS_NAME).append("/").append(SystemUtils.OS_ARCH).append(")").toString());
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String platform = (String)tuple22._1();
            String arch = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)platform, (Object)arch);
            Tuple2 tuple24 = tuple23;
            String platform2 = (String)tuple24._1();
            String arch2 = (String)tuple24._2();
            if (((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amd64"}))).contains((Object)arch2)) {
                arch2 = "x86_64";
            }
            this.getLogger().lifecycle(new StringBuilder(42).append("Recognized system info, platform: ").append(platform2).append(", arch: ").append(arch2).toString());
            if (this.protocPath().exists()) break block10;
            package$.MODULE$.FileExtension(this.protocPath().getParentFile()).ensure();
            this.getLogger().lifecycle(new StringBuilder(28).append(this.protocPath()).append(" not found, need to download").toString());
            this.protocDownloadArtifact_$eq(this.downloadFile(new StringBuilder(16).append(this.protoReleaseUrl()).append("/v").append(this.version).append("/protoc-").append(this.version).append("-").append(platform2).append("-").append(arch2).append(".zip").toString()));
            try {
                ZipUtil.unzip((File)((File)this.protocDownloadArtifact().get()), (File)this.extension().protocDir(), (String[])new String[0]);
                better.files.package$.MODULE$.StringOps(((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.extension().protocDir(), "bin"}))).mkString(File.separator)).toFile().children().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isRegularFile(x$2.isRegularFile$default$1()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    PosixFilePermission x$4 = PosixFilePermission.OWNER_EXECUTE;
                    Seq x$5 = x$3.addPermission$default$2(x$4);
                    return x$3.addPermission(x$4, x$5);
                });
            }
            catch (Throwable throwable) {
                throw new GradleException(new StringBuilder(30).append("Failed to extract protoc from ").append(this.protocDownloadArtifact()).toString());
            }
            if (this.extension().goEnabled()) {
                this.getLogger().lifecycle("Downloading protoc-gen-go");
                if (!scala.sys.package$.MODULE$.env().contains((Object)"GOROOT")) {
                    throw new GradleException("GOROOT environment variable unavailable");
                }
                String go = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)scala.sys.package$.MODULE$.env().apply((Object)"GOROOT"), "bin", "go"}))).mkString(File.separator);
                Seq commands = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(70).append(go).append(" get -u github.com/grpc-ecosystem/grpc-gateway/protoc-gen-grpc-gateway").toString(), new StringBuilder(65).append(go).append(" get -u github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger").toString(), new StringBuilder(48).append(go).append(" get -u github.com/golang/protobuf/protoc-gen-go").toString(), new StringBuilder(30).append(go).append(" get -u google.golang.org/grpc").toString(), new StringBuilder(35).append(go).append(" get -u github.com/wadey/gocovmerge").toString(), new StringBuilder(34).append(go).append(" get -u github.com/axw/gocov/gocov").toString(), new StringBuilder(35).append(go).append(" get -u github.com/AlekSi/gocov-xml").toString(), new StringBuilder(39).append(go).append(" get -u github.com/swaggo/swag/cmd/swag").toString()}))).$plus$plus(this.extension().goExtraPackages(), Seq$.MODULE$.canBuildFrom());
                commands.foreach((Function1 & Serializable & scala.Serializable)command -> {
                    this.getLogger().lifecycle(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("Running command ...\n               |").append((String)command).toString())).stripMargin());
                    return this.getProject().exec(spec -> {
                        spec.setCommandLine((Object[])command.split("\\s+"));
                        spec.setEnvironment((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.sys.package$.MODULE$.env().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GOPATH"), (Object)this.extension().goPath().toString())})))).asJava());
                    });
                });
            }
        }
    }

    public Option<File> downloadFile(String url) {
        Request request = new Request.Builder().url(url).build();
        Response response = package$.MODULE$.httpClient().newCall(request).execute();
        if (response.code() != 200) {
            throw new GradleException(new StringBuilder(51).append("Failed to download file from ").append(url).append(", due to HTTP error (").append(response.code()).append(")").toString());
        }
        String disposition = response.header("Content-Disposition");
        Option option = new StringOps(Predef$.MODULE$.augmentString("filename=(\\S+)")).r().findFirstMatchIn((CharSequence)disposition);
        if (!(option instanceof Some)) {
            throw new GradleException("Failed to download protoc, no filename= found in Content-Disposition");
        }
        Some some = (Some)option;
        Regex.Match matchResult = (Regex.Match)some.value();
        Some some2 = new Some((Object)new File(package$.MODULE$.FileExtension(this.extension().tempDir()).ensure(), matchResult.group(1)));
        Some downloadArtifact = some2;
        package$.MODULE$.use(Okio.buffer((Sink)Okio.sink((File)((File)downloadArtifact.get()))), (Function1 & Serializable & scala.Serializable)sink -> {
            sink.writeAll((Source)response.body().source());
            return BoxedUnit.UNIT;
        });
        this.getLogger().lifecycle(new StringBuilder(33).append("Downloaded file from ").append(url).append(" to save in ").append(downloadArtifact).toString());
        return downloadArtifact;
    }

    @Inject
    public GrpcDownloadTask(String version) {
        this.version = version;
        this.setGroup("grpc");
        this.setDescription("Download gRPC toolset");
        this.extension = (GrpcPluginExtension)package$.MODULE$.getExtension(this.getProject(), "grpc");
        this.protoReleaseUrl = "https://github.com/google/protobuf/releases/download";
        this.protocDownloadArtifact = None$.MODULE$;
        this.protocPath = new File(this.extension().protocDir(), ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bin", "protoc"}))).mkString(File.separator));
    }
}

