/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Base64;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.registry.RegistryAliasGroup;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperNotFoundException;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperUnhandledServerUrlException;
import com.google.cloud.tools.jib.registry.credentials.DockerConfig;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.cloud.tools.jib.registry.credentials.json.DockerConfigTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class DockerConfigCredentialRetriever {
    private final String registry;
    private final Path dockerConfigFile;
    private final boolean legacyConfigFormat;

    public static DockerConfigCredentialRetriever create(String registry, Path dockerConfigFile) {
        return new DockerConfigCredentialRetriever(registry, dockerConfigFile, false);
    }

    public static DockerConfigCredentialRetriever createForLegacyFormat(String registry, Path dockerConfigFile) {
        return new DockerConfigCredentialRetriever(registry, dockerConfigFile, true);
    }

    private DockerConfigCredentialRetriever(String registry, Path dockerConfigFile, boolean legacyConfigFormat) {
        this.registry = registry;
        this.dockerConfigFile = dockerConfigFile;
        this.legacyConfigFormat = legacyConfigFormat;
    }

    public Path getDockerConfigFile() {
        return this.dockerConfigFile;
    }

    public Optional<Credential> retrieve(Consumer<LogEvent> logger) throws IOException {
        if (!Files.exists(this.dockerConfigFile, new LinkOption[0])) {
            return Optional.empty();
        }
        ObjectMapper objectMapper = new ObjectMapper().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        try (InputStream fileIn = Files.newInputStream(this.dockerConfigFile, new OpenOption[0]);){
            if (this.legacyConfigFormat) {
                Map auths = (Map)objectMapper.readValue(fileIn, (TypeReference)new TypeReference<Map<String, DockerConfigTemplate.AuthTemplate>>(){});
                DockerConfig dockerConfig = new DockerConfig(new DockerConfigTemplate(auths));
                Optional<Credential> optional = this.retrieve(dockerConfig, logger);
                return optional;
            }
            DockerConfig dockerConfig = new DockerConfig((DockerConfigTemplate)objectMapper.readValue(fileIn, DockerConfigTemplate.class));
            Optional<Credential> optional = this.retrieve(dockerConfig, logger);
            return optional;
        }
    }

    @VisibleForTesting
    Optional<Credential> retrieve(DockerConfig dockerConfig, Consumer<LogEvent> logger) {
        for (String registryAlias : RegistryAliasGroup.getAliasesGroup(this.registry)) {
            DockerConfigTemplate.AuthTemplate auth;
            block6: {
                DockerCredentialHelper dockerCredentialHelper = dockerConfig.getCredentialHelperFor(registryAlias);
                if (dockerCredentialHelper != null) {
                    try {
                        Path helperPath = dockerCredentialHelper.getCredentialHelper();
                        logger.accept(LogEvent.info("trying " + helperPath + " for " + registryAlias));
                        return Optional.of(dockerCredentialHelper.retrieve());
                    }
                    catch (CredentialHelperNotFoundException | CredentialHelperUnhandledServerUrlException | IOException ex) {
                        if (ex.getMessage() == null) break block6;
                        logger.accept(LogEvent.warn(ex.getMessage()));
                        if (ex.getCause() == null || ex.getCause().getMessage() == null) break block6;
                        logger.accept(LogEvent.warn("  Caused by: " + ex.getCause().getMessage()));
                    }
                }
            }
            if ((auth = dockerConfig.getAuthFor(registryAlias)) == null) continue;
            if (auth.getAuth() != null) {
                String usernameColonPassword = new String(Base64.decodeBase64((String)auth.getAuth()), StandardCharsets.UTF_8);
                String username = usernameColonPassword.substring(0, usernameColonPassword.indexOf(":"));
                String password = usernameColonPassword.substring(usernameColonPassword.indexOf(":") + 1);
                logger.accept(LogEvent.info("Docker config auths section defines credentials for " + registryAlias));
                if (auth.getIdentityToken() != null && username.equals("00000000-0000-0000-0000-000000000000") && password.isEmpty()) {
                    logger.accept(LogEvent.info("Using 'identityToken' in Docker config auth for " + registryAlias));
                    return Optional.of(Credential.from("<token>", auth.getIdentityToken()));
                }
                return Optional.of(Credential.from(username, password));
            }
            if (auth.getUsername() == null || auth.getPassword() == null) continue;
            logger.accept(LogEvent.info("Docker config auths section defines username and password for " + registryAlias));
            return Optional.of(Credential.from(auth.getUsername(), auth.getPassword()));
        }
        return Optional.empty();
    }
}

