/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public class DockerClientParameters {
    @Nullable
    private Path executable;
    private Map<String, String> environment = Collections.emptyMap();

    @Input
    @Nullable
    @Optional
    public String getExecutable() {
        if (System.getProperty("jib.dockerClient.executable") != null) {
            return System.getProperty("jib.dockerClient.executable");
        }
        return this.executable == null ? null : this.executable.toString();
    }

    @Internal
    @Nullable
    Path getExecutablePath() {
        if (System.getProperty("jib.dockerClient.executable") != null) {
            return Paths.get(System.getProperty("jib.dockerClient.executable"), new String[0]);
        }
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = Paths.get(executable, new String[0]);
    }

    @Input
    @Optional
    public Map<String, String> getEnvironment() {
        if (System.getProperty("jib.dockerClient.environment") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.dockerClient.environment"));
        }
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }
}

