/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.hash.Digests;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class FileBlob
implements Blob {
    private final Path file;

    FileBlob(Path file) {
        this.file = file;
    }

    @Override
    public BlobDescriptor writeTo(OutputStream outputStream) throws IOException {
        try (BufferedInputStream fileIn = new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]));){
            BlobDescriptor blobDescriptor = Digests.computeDigest(fileIn, outputStream);
            return blobDescriptor;
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

