/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.api.client.http.HttpTransport;
import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.UpdateChecker;
import com.google.common.util.concurrent.Futures;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.slf4j.OutputEventListenerBackedLoggerContext;
import org.slf4j.LoggerFactory;

class TaskCommon {
    public static final String VERSION_URL = "https://storage.googleapis.com/jib-versions/jib-gradle";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Future<Optional<String>> newUpdateChecker(ProjectProperties projectProperties, org.gradle.api.logging.Logger logger) {
        if (projectProperties.isOffline() || !logger.isLifecycleEnabled()) {
            return Futures.immediateFuture(Optional.empty());
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<Optional<String>> future = UpdateChecker.checkForUpdate(executorService, projectProperties::log, VERSION_URL, projectProperties.getToolName());
            return future;
        }
        finally {
            executorService.shutdown();
        }
    }

    static void finishUpdateChecker(ProjectProperties projectProperties, Future<Optional<String>> updateCheckFuture) {
        UpdateChecker.finishUpdateCheck(updateCheckFuture).ifPresent(updateMessage -> projectProperties.log(LogEvent.lifecycle("\n\u001b[33m" + updateMessage + "\n" + "https://github.com/GoogleContainerTools/jib" + "/blob/master/jib-gradle-plugin/CHANGELOG.md\u001b[0m\n")));
    }

    @Nullable
    static TaskProvider<Task> getWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin(WarPlugin.class)) {
            return project.getTasks().named("war");
        }
        return null;
    }

    @Nullable
    static TaskProvider<Task> getBootWarTaskProvider(Project project) {
        if (project.getPlugins().hasPlugin("org.springframework.boot")) {
            try {
                return project.getTasks().named("bootWar");
            }
            catch (UnknownTaskException unknownTaskException) {
                // empty catch block
            }
        }
        return null;
    }

    static void disableHttpLogging() {
        OutputEventListenerBackedLoggerContext context = (OutputEventListenerBackedLoggerContext)LoggerFactory.getILoggerFactory();
        OutputEventListener defaultOutputEventListener = context.getOutputEventListener();
        context.setOutputEventListener(event -> {
            org.gradle.internal.logging.events.LogEvent logEvent = (org.gradle.internal.logging.events.LogEvent)event;
            if (!logEvent.getCategory().contains("org.apache")) {
                defaultOutputEventListener.onOutput(event);
            }
        });
        Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.OFF);
    }

    static Map<AbsoluteUnixPath, FilePermissions> convertPermissionsMap(Map<String, String> stringMap) {
        HashMap<AbsoluteUnixPath, FilePermissions> permissionsMap = new HashMap<AbsoluteUnixPath, FilePermissions>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            AbsoluteUnixPath key = AbsoluteUnixPath.get(entry.getKey());
            FilePermissions value = FilePermissions.fromOctalString(entry.getValue());
            permissionsMap.put(key, value);
        }
        return permissionsMap;
    }

    private TaskCommon() {
    }
}

