/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

class AnsiLoggerWithFooter
implements ConsoleLogger {
    private static final int MAX_FOOTER_WIDTH = 50;
    private static final String CURSOR_UP_SEQUENCE = "\u001b[1A";
    private static final String ERASE_DISPLAY_BELOW = "\u001b[0J";
    private static final String BOLD = "\u001b[1m";
    private static final String UNBOLD = "\u001b[0m";
    private final ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers;
    private final Consumer<String> lifecycleConsumer;
    private final SingleThreadedExecutor singleThreadedExecutor;
    private List<String> footerLines = Collections.emptyList();

    @VisibleForTesting
    static List<String> truncateToMaxWidth(List<String> lines) {
        ArrayList<String> truncatedLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.length() > 50) {
                truncatedLines.add(line.substring(0, 47) + "...");
                continue;
            }
            truncatedLines.add(line);
        }
        return truncatedLines;
    }

    AnsiLoggerWithFooter(ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers, SingleThreadedExecutor singleThreadedExecutor) {
        Preconditions.checkArgument((boolean)messageConsumers.containsKey((Object)LogEvent.Level.LIFECYCLE), (Object)"Cannot construct AnsiLoggerFooter without LIFECYCLE message consumer");
        this.messageConsumers = messageConsumers;
        this.lifecycleConsumer = (Consumer)Preconditions.checkNotNull((Object)((Consumer)messageConsumers.get((Object)LogEvent.Level.LIFECYCLE)));
        this.singleThreadedExecutor = singleThreadedExecutor;
    }

    @Override
    public void log(LogEvent.Level logLevel, String message) {
        if (!this.messageConsumers.containsKey((Object)logLevel)) {
            return;
        }
        Consumer messageConsumer = (Consumer)this.messageConsumers.get((Object)logLevel);
        this.singleThreadedExecutor.execute(() -> {
            boolean didErase = this.eraseFooter();
            String messagePrefix = didErase ? CURSOR_UP_SEQUENCE : "";
            messageConsumer.accept(messagePrefix + message);
            for (String footerLine : this.footerLines) {
                this.lifecycleConsumer.accept(BOLD + footerLine + UNBOLD);
            }
        });
    }

    @Override
    public void setFooter(List<String> newFooterLines) {
        List<String> truncatedNewFooterLines = AnsiLoggerWithFooter.truncateToMaxWidth(newFooterLines);
        if (truncatedNewFooterLines.equals(this.footerLines)) {
            return;
        }
        this.singleThreadedExecutor.execute(() -> {
            boolean didErase = this.eraseFooter();
            String newFooterPrefix = didErase ? CURSOR_UP_SEQUENCE : "";
            for (String newFooterLine : truncatedNewFooterLines) {
                this.lifecycleConsumer.accept(newFooterPrefix + BOLD + newFooterLine + UNBOLD);
                newFooterPrefix = "";
            }
            this.footerLines = truncatedNewFooterLines;
        });
    }

    private boolean eraseFooter() {
        if (this.footerLines.isEmpty()) {
            return false;
        }
        StringBuilder footerEraserBuilder = new StringBuilder();
        for (int i = 0; i < this.footerLines.size(); ++i) {
            footerEraserBuilder.append(CURSOR_UP_SEQUENCE);
        }
        footerEraserBuilder.append(ERASE_DISPLAY_BELOW);
        this.lifecycleConsumer.accept(footerEraserBuilder.toString());
        return true;
    }
}

