/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.ProjectInfo;
import com.google.cloud.tools.jib.gradle.BuildDockerTask;
import com.google.cloud.tools.jib.gradle.BuildImageTask;
import com.google.cloud.tools.jib.gradle.BuildTarTask;
import com.google.cloud.tools.jib.gradle.CheckJibVersionTask;
import com.google.cloud.tools.jib.gradle.ExplodedWarTask;
import com.google.cloud.tools.jib.gradle.FilesTask;
import com.google.cloud.tools.jib.gradle.FilesTaskV2;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.SkaffoldInitTask;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.plugins.common.VersionChecker;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.bundling.War;
import org.gradle.util.GradleVersion;

public class JibPlugin
implements Plugin<Project> {
    @VisibleForTesting
    static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.version((String)"4.6");
    @VisibleForTesting
    static final String JIB_EXTENSION_NAME = "jib";
    @VisibleForTesting
    static final String BUILD_IMAGE_TASK_NAME = "jib";
    @VisibleForTesting
    static final String BUILD_TAR_TASK_NAME = "jibBuildTar";
    @VisibleForTesting
    static final String BUILD_DOCKER_TASK_NAME = "jibDockerBuild";
    @VisibleForTesting
    static final String FILES_TASK_NAME = "_jibSkaffoldFiles";
    @VisibleForTesting
    static final String FILES_TASK_V2_NAME = "_jibSkaffoldFilesV2";
    @VisibleForTesting
    static final String INIT_TASK_NAME = "_jibSkaffoldInit";
    @VisibleForTesting
    static final String EXPLODED_WAR_TASK_NAME = "jibExplodedWar";
    static final String CHECK_REQUIRED_VERSION_TASK_NAME = "_skaffoldFailIfJibOutOfDate";
    static final String REQUIRED_VERSION_PROPERTY_NAME = "jib.requiredVersion";

    @VisibleForTesting
    static List<Project> getProjectDependencies(Project project) {
        return project.getConfigurations().stream().map(Configuration::getDependencies).flatMap(Collection::stream).filter(ProjectDependency.class::isInstance).map(ProjectDependency.class::cast).map(ProjectDependency::getDependencyProject).collect(Collectors.toList());
    }

    private static void checkGradleVersion() {
        if (GRADLE_MIN_VERSION.compareTo(GradleVersion.current()) > 0) {
            throw new GradleException("Detected " + GradleVersion.current() + ", but jib requires " + GRADLE_MIN_VERSION + " or higher. You can upgrade by running 'gradle wrapper --gradle-version=" + GRADLE_MIN_VERSION.getVersion() + "'.");
        }
    }

    private static void checkJibVersion(Project project) {
        String requiredVersion = System.getProperty(REQUIRED_VERSION_PROPERTY_NAME);
        if (requiredVersion == null) {
            return;
        }
        String actualVersion = ProjectInfo.VERSION;
        if (actualVersion == null) {
            throw new GradleException("Could not determine Jib plugin version");
        }
        VersionChecker<GradleVersion> checker = new VersionChecker<GradleVersion>(GradleVersion::version);
        if (!checker.compatibleVersion(requiredVersion, actualVersion)) {
            String failure = String.format("Jib plugin version is %s but is required to be %s", actualVersion, requiredVersion);
            throw new GradleException(failure);
        }
    }

    public void apply(Project project) {
        JibPlugin.checkGradleVersion();
        JibPlugin.checkJibVersion(project);
        JibExtension jibExtension = (JibExtension)project.getExtensions().create("jib", JibExtension.class, new Object[]{project});
        BuildImageTask buildImageTask = ((BuildImageTask)project.getTasks().create("jib", BuildImageTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a registry.");
        })).setJibExtension(jibExtension);
        BuildDockerTask buildDockerTask = ((BuildDockerTask)project.getTasks().create(BUILD_DOCKER_TASK_NAME, BuildDockerTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a Docker daemon.");
        })).setJibExtension(jibExtension);
        BuildTarTask buildTarTask = ((BuildTarTask)project.getTasks().create(BUILD_TAR_TASK_NAME, BuildTarTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a tarball.");
        })).setJibExtension(jibExtension);
        ((FilesTask)project.getTasks().create(FILES_TASK_NAME, FilesTask.class)).setJibExtension(jibExtension);
        ((FilesTaskV2)project.getTasks().create(FILES_TASK_V2_NAME, FilesTaskV2.class)).setJibExtension(jibExtension);
        ((SkaffoldInitTask)project.getTasks().create(INIT_TASK_NAME, SkaffoldInitTask.class)).setJibExtension(jibExtension);
        project.getTasks().create(CHECK_REQUIRED_VERSION_TASK_NAME, CheckJibVersionTask.class);
        project.afterEvaluate(projectAfterEvaluation -> {
            try {
                Object dependsOnTask;
                War warTask = TaskCommon.getWarTask(project);
                if (warTask != null) {
                    ExplodedWarTask explodedWarTask = (ExplodedWarTask)project.getTasks().create(EXPLODED_WAR_TASK_NAME, ExplodedWarTask.class);
                    explodedWarTask.dependsOn(new Object[]{warTask});
                    explodedWarTask.setWarFile(warTask.getArchivePath().toPath());
                    explodedWarTask.setExplodedWarDirectory(GradleProjectProperties.getExplodedWarDirectory(projectAfterEvaluation));
                    dependsOnTask = explodedWarTask;
                } else {
                    dependsOnTask = "packaged".equals(jibExtension.getContainerizingMode()) ? projectAfterEvaluation.getTasks().getByPath("jar") : projectAfterEvaluation.getTasks().getByPath("classes");
                }
                buildImageTask.dependsOn(new Object[]{dependsOnTask});
                buildDockerTask.dependsOn(new Object[]{dependsOnTask});
                buildTarTask.dependsOn(new Object[]{dependsOnTask});
                List<Project> computedDependencies = JibPlugin.getProjectDependencies(projectAfterEvaluation);
                for (Project dependencyProject : computedDependencies) {
                    dependencyProject.getPlugins().withType(BasePlugin.class, unused -> {
                        Task assembleTask = dependencyProject.getTasks().getByPath("assemble");
                        buildImageTask.dependsOn(new Object[]{assembleTask});
                        buildDockerTask.dependsOn(new Object[]{assembleTask});
                        buildTarTask.dependsOn(new Object[]{assembleTask});
                    });
                }
            }
            catch (UnknownTaskException ex) {
                throw new GradleException("Could not find task 'classes' on project " + projectAfterEvaluation.getDisplayName() + " - perhaps you did not apply the 'java' plugin?", (Throwable)ex);
            }
        });
    }
}

