/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.events.TimerEvent;
import com.google.cloud.tools.jib.event.progress.ProgressEventHandler;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.JavaContainerBuilderHelper;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.TimerEventHandler;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLoggerBuilder;
import com.google.cloud.tools.jib.plugins.common.logging.ProgressDisplayGenerator;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.tasks.Jar;

class GradleProjectProperties
implements ProjectProperties {
    private static final String TOOL_NAME = "jib-gradle-plugin";
    private static final String PLUGIN_NAME = "jib";
    private static final String JAR_PLUGIN_NAME = "'jar' task";
    private static final String MAIN_SOURCE_SET_NAME = "main";
    private final Project project;
    private final SingleThreadedExecutor singleThreadedExecutor = new SingleThreadedExecutor();
    private final Logger logger;
    private final ConsoleLogger consoleLogger;

    static GradleProjectProperties getForProject(Project project, Logger logger) {
        return new GradleProjectProperties(project, logger);
    }

    static Path getExplodedWarDirectory(Project project) {
        return project.getBuildDir().toPath().resolve("jib-exploded-war");
    }

    private static boolean isProgressFooterEnabled(Project project) {
        if ("plain".equals(System.getProperty("jib.console"))) {
            return false;
        }
        switch (project.getGradle().getStartParameter().getConsoleOutput()) {
            case Plain: {
                return false;
            }
            case Auto: {
                return Os.isFamily((String)"windows") || !"dumb".equals(System.getenv("TERM"));
            }
        }
        return true;
    }

    @VisibleForTesting
    GradleProjectProperties(Project project, Logger logger) {
        this.project = project;
        this.logger = logger;
        ConsoleLoggerBuilder consoleLoggerBuilder = (GradleProjectProperties.isProgressFooterEnabled(project) ? ConsoleLoggerBuilder.rich(this.singleThreadedExecutor) : ConsoleLoggerBuilder.plain(this.singleThreadedExecutor).progress(arg_0 -> ((Logger)logger).lifecycle(arg_0))).lifecycle(arg_0 -> ((Logger)logger).lifecycle(arg_0));
        if (logger.isDebugEnabled()) {
            consoleLoggerBuilder.debug(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        if (logger.isInfoEnabled()) {
            consoleLoggerBuilder.info(arg_0 -> ((Logger)logger).info(arg_0));
        }
        if (logger.isWarnEnabled()) {
            consoleLoggerBuilder.warn(arg_0 -> ((Logger)logger).warn(arg_0));
        }
        if (logger.isErrorEnabled()) {
            consoleLoggerBuilder.error(arg_0 -> ((Logger)logger).error(arg_0));
        }
        this.consoleLogger = consoleLoggerBuilder.build();
    }

    @Override
    public JibContainerBuilder createContainerBuilder(RegistryImage baseImage, AbsoluteUnixPath appRoot, ContainerizingMode containerizingMode) {
        JavaContainerBuilder javaContainerBuilder = JavaContainerBuilder.from(baseImage).setAppRoot(appRoot);
        try {
            if (this.isWarProject()) {
                this.logger.info("WAR project identified, creating WAR image: " + this.project.getDisplayName());
                Path explodedWarPath = GradleProjectProperties.getExplodedWarDirectory(this.project);
                return JavaContainerBuilderHelper.fromExplodedWar(javaContainerBuilder, explodedWarPath);
            }
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
            FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs().filter(File::exists);
            Path resourcesOutputDirectory = mainSourceSet.getOutput().getResourcesDir().toPath();
            FileCollection allFiles = mainSourceSet.getRuntimeClasspath().filter(File::exists);
            ConfigurableFileCollection projectDependencies = this.project.files(new Object[]{this.project.getConfigurations().getByName("runtimeClasspath").getResolvedConfiguration().getResolvedArtifacts().stream().filter(artifact -> artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier).map(ResolvedArtifact::getFile).collect(Collectors.toList())});
            FileCollection nonProjectDependencies = allFiles.minus(classesOutputDirectories).minus((FileCollection)projectDependencies).filter(file -> !file.toPath().equals(resourcesOutputDirectory));
            FileCollection snapshotDependencies = nonProjectDependencies.filter(file -> file.getName().contains("SNAPSHOT"));
            FileCollection dependencies = nonProjectDependencies.minus(snapshotDependencies);
            javaContainerBuilder.addDependencies(dependencies.getFiles().stream().map(File::toPath).collect(Collectors.toList())).addSnapshotDependencies(snapshotDependencies.getFiles().stream().map(File::toPath).collect(Collectors.toList())).addProjectDependencies(projectDependencies.getFiles().stream().map(File::toPath).collect(Collectors.toList()));
            switch (containerizingMode) {
                case EXPLODED: {
                    if (Files.exists(resourcesOutputDirectory, new LinkOption[0])) {
                        javaContainerBuilder.addResources(resourcesOutputDirectory);
                    }
                    for (File classesOutputDirectory : classesOutputDirectories) {
                        javaContainerBuilder.addClasses(classesOutputDirectory.toPath());
                    }
                    if (!classesOutputDirectories.isEmpty()) break;
                    this.logger.warn("No classes files were found - did you compile your project?");
                    break;
                }
                case PACKAGED: {
                    Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
                    javaContainerBuilder.addToClasspath(jarTask.getDestinationDir().toPath().resolve(jarTask.getArchiveName()));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown containerizing mode: " + (Object)((Object)containerizingMode));
                }
            }
            return javaContainerBuilder.toContainerBuilder();
        }
        catch (IOException ex) {
            throw new GradleException("Obtaining project build output files failed", (Throwable)ex);
        }
    }

    @Override
    public List<Path> getClassFiles() throws IOException {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
        FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs().filter(File::exists);
        ArrayList<Path> classFiles = new ArrayList<Path>();
        for (File classesOutputDirectory : classesOutputDirectories) {
            classFiles.addAll((Collection<Path>)new DirectoryWalker(classesOutputDirectory.toPath()).walk().asList());
        }
        return classFiles;
    }

    @Override
    public void waitForLoggingThread() {
        this.singleThreadedExecutor.shutDownAndAwaitTermination();
    }

    @Override
    public void configureEventHandlers(Containerizer containerizer) {
        containerizer.addEventHandler(LogEvent.class, this::log).addEventHandler(TimerEvent.class, new TimerEventHandler(message -> this.consoleLogger.log(LogEvent.Level.DEBUG, (String)message))).addEventHandler(ProgressEvent.class, new ProgressEventHandler(update -> {
            List<String> footer = ProgressDisplayGenerator.generateProgressDisplay(update.getProgress(), update.getUnfinishedLeafTasks());
            footer.add("");
            this.consoleLogger.setFooter(footer);
        }));
    }

    @Override
    public void log(LogEvent logEvent) {
        this.consoleLogger.log(logEvent.getLevel(), logEvent.getMessage());
    }

    @Override
    public String getToolName() {
        return TOOL_NAME;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
        if (jarTask == null) {
            return null;
        }
        return (String)jarTask.getManifest().getAttributes().get((Object)"Main-Class");
    }

    @Override
    public Path getDefaultCacheDirectory() {
        return this.project.getBuildDir().toPath().resolve("jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    @Override
    public boolean isWarProject() {
        return this.project.getPlugins().hasPlugin(WarPlugin.class);
    }

    static FileCollection getInputFiles(Project project, List<Path> extraDirectories) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
        ArrayList<FileCollection> dependencyFileCollections = new ArrayList<FileCollection>();
        dependencyFileCollections.add(mainSourceSet.getRuntimeClasspath());
        extraDirectories.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toFile).map(xva$0 -> project.files(new Object[]{xva$0})).forEach(dependencyFileCollections::add);
        return project.files(new Object[]{dependencyFileCollections});
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public String getVersion() {
        return this.project.getVersion().toString();
    }

    @Override
    public int getMajorJavaVersion() {
        JavaVersion version = JavaVersion.current();
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention != null) {
            version = javaPluginConvention.getTargetCompatibility();
        }
        return Integer.valueOf(version.getMajorVersion());
    }

    @Override
    public boolean isOffline() {
        return this.project.getGradle().getStartParameter().isOffline();
    }
}

