/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.AuthConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class ImageConfiguration {
    private AuthConfiguration auth;
    @Nullable
    private String image;
    @Nullable
    private String credHelper;

    @Inject
    public ImageConfiguration(ObjectFactory objectFactory) {
        this.auth = (AuthConfiguration)objectFactory.newInstance(AuthConfiguration.class, new Object[0]);
    }

    @Input
    @Nullable
    @Optional
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Input
    @Nullable
    @Optional
    public String getCredHelper() {
        return this.credHelper;
    }

    public void setCredHelper(String credHelper) {
        this.credHelper = credHelper;
    }

    @Nested
    @Optional
    AuthConfiguration getAuth() {
        return this.auth;
    }

    public void auth(Action<? super AuthConfiguration> action) {
        action.execute((Object)this.auth);
    }

    @Internal
    @Nullable
    Authorization getImageAuthorization() {
        if (this.auth.getUsername() == null || this.auth.getPassword() == null) {
            return null;
        }
        return Authorizations.withBasicCredentials(this.auth.getUsername(), this.auth.getPassword());
    }
}

