/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CacheMetadataTranslator;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class Cache
implements Closeable {
    private final Path cacheDirectory;
    private final CacheMetadata cacheMetadata;
    private final CacheMetadata.Builder cacheMetadataBuilder;

    public static Cache init(Path cacheDirectory) throws NotDirectoryException, CacheMetadataCorruptedException {
        if (!Files.isDirectory(cacheDirectory, new LinkOption[0])) {
            throw new NotDirectoryException("The cache can only write to a directory");
        }
        CacheMetadata cacheMetadata = Cache.loadCacheMetadata(cacheDirectory);
        return new Cache(cacheDirectory, cacheMetadata);
    }

    private static CacheMetadata loadCacheMetadata(Path cacheDirectory) throws CacheMetadataCorruptedException {
        Path cacheMetadataJsonFile = cacheDirectory.resolve("metadata-v2.json");
        if (!Files.exists(cacheMetadataJsonFile, new LinkOption[0])) {
            return CacheMetadata.builder().build();
        }
        try {
            CacheMetadataTemplate cacheMetadataJson = JsonTemplateMapper.readJsonFromFile(cacheMetadataJsonFile, CacheMetadataTemplate.class);
            return CacheMetadataTranslator.fromTemplate(cacheMetadataJson, cacheDirectory);
        }
        catch (IOException ex) {
            throw new CacheMetadataCorruptedException(ex);
        }
    }

    private Cache(Path cacheDirectory, CacheMetadata cacheMetadata) {
        this.cacheDirectory = cacheDirectory;
        this.cacheMetadata = cacheMetadata;
        this.cacheMetadataBuilder = cacheMetadata.newAppendingBuilder();
    }

    @Override
    public void close() throws IOException {
        this.saveCacheMetadata(this.cacheDirectory);
    }

    public void addCachedLayersToMetadata(List<CachedLayer> cachedLayers) {
        for (CachedLayer cachedLayer : cachedLayers) {
            this.cacheMetadataBuilder.addLayer(new CachedLayerWithMetadata(cachedLayer, null));
        }
    }

    public void addCachedLayersWithMetadataToMetadata(List<CachedLayerWithMetadata> cachedLayersWithMetadata) {
        for (CachedLayerWithMetadata cachedLayerWithMetadata : cachedLayersWithMetadata) {
            this.cacheMetadataBuilder.addLayer(cachedLayerWithMetadata);
        }
    }

    @VisibleForTesting
    Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    @VisibleForTesting
    CacheMetadata getMetadata() {
        return this.cacheMetadata;
    }

    @VisibleForTesting
    CacheMetadata getUpdatedMetadata() {
        return this.cacheMetadataBuilder.build();
    }

    private void saveCacheMetadata(Path cacheDirectory) throws IOException {
        Path cacheMetadataJsonFile = cacheDirectory.resolve("metadata-v2.json");
        CacheMetadataTemplate cacheMetadataJson = CacheMetadataTranslator.toTemplate(this.cacheMetadataBuilder.build());
        try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(cacheMetadataJsonFile, new OpenOption[0]));){
            JsonTemplateMapper.toBlob(cacheMetadataJson).writeTo(fileOutputStream);
        }
    }
}

